/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IServerUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.SetItemFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ItemCollectorUtils {
    @NotNull
    public static List<Item> collectLootTable(IServerUtils utils, LootTable lootTable) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPool pool : lootTable.pools) {
            result.addAll(ItemCollectorUtils.collectLootPool(utils, pool));
        }
        result.addAll(lootTable.functions.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<Item> collectLootPool(IServerUtils utils, LootPool pool) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPoolEntryContainer entry : pool.entries) {
            result.addAll(utils.collectItems(utils, entry));
        }
        result.addAll(pool.conditions.stream().map(c -> utils.collectItems(utils, List.copyOf(result), c)).flatMap(Collection::stream).toList());
        result.addAll(pool.functions.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectItems(IServerUtils utils, LootItem entry) {
        LinkedList<Item> result = new LinkedList<Item>(List.of((Item)entry.item.value()));
        result.addAll(entry.functions.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectTags(IServerUtils utils, TagEntry entry) {
        LinkedList<Item> result = new LinkedList<Item>(BuiltInRegistries.ITEM.getTag(entry.tag).map(tag -> tag.stream().map(Holder::value).toList()).orElse(List.of()));
        result.addAll(entry.functions.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        return result;
    }

    @NotNull
    public static List<Item> collectComposite(IServerUtils utils, CompositeEntryBase entry) {
        LinkedList<Item> result = new LinkedList<Item>();
        for (LootPoolEntryContainer child : entry.children) {
            result.addAll(utils.collectItems(utils, child));
        }
        return result;
    }

    public static @Unmodifiable @NotNull List<Item> collectSingleton(IServerUtils utils, LootPoolSingletonContainer entry) {
        return entry.functions.stream().map(f -> utils.collectItems(utils, List.of(), f)).flatMap(Collection::stream).toList();
    }

    @NotNull
    public static List<Item> collectReference(IServerUtils utils, NestedLootTable entry) {
        LinkedList<Item> result = new LinkedList<Item>();
        LootTable lootTable = utils.getLootTable((Either<ResourceKey<LootTable>, LootTable>)entry.contents);
        if (lootTable != null) {
            result.addAll(ItemCollectorUtils.collectLootTable(utils, lootTable));
            result.addAll(entry.functions.stream().map(f -> utils.collectItems(utils, List.copyOf(result), f)).flatMap(Collection::stream).toList());
        }
        return result;
    }

    @NotNull
    public static List<Item> collectFurnaceSmelt(IServerUtils utils, List<Item> items, SmeltItemFunction function) {
        ServerLevel level = utils.getServerLevel();
        if (level != null) {
            return items.stream().map(i -> level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (Container)new SimpleContainer(new ItemStack[]{i.getDefaultInstance()}), (Level)level).map(l -> List.of(((SmeltingRecipe)l.value()).getResultItem(null).getItem())).orElse(List.of())).flatMap(Collection::stream).toList();
        }
        return List.of();
    }

    public static @Unmodifiable @NotNull List<Item> collectSetItem(IServerUtils utils, List<Item> items, SetItemFunction function) {
        return List.of((Item)function.item.value());
    }
}

