/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBlockLoot;
import com.yanny.ali.compatibility.emi.EmiEntityLoot;
import com.yanny.ali.compatibility.emi.EmiGameplayLoot;
import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.platform.Services;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_52;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EmiEntrypoint
public class EmiCompatibility
implements EmiPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void register(EmiRegistry emiRegistry) {
        this.registerLootTable(emiRegistry);
    }

    private void registerLootTable(EmiRegistry registry) {
        AbstractClient client = Services.PLATFORM.getInfoPropagator().client();
        class_638 level = class_310.method_1551().field_1687;
        if (client != null && level != null) {
            class_2960 location;
            Map<class_2960, class_52> map = GenericUtils.getLootTables();
            Map<LootCategory, EmiRecipeCategory> blockCategoryMap = LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((class_2960)r.getKey(), (EmiRenderable)EmiStack.of((class_1799)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> entityCategoryMap = LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((class_2960)r.getKey(), (EmiRenderable)EmiStack.of((class_1799)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> gameplayCategoryMap = LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((class_2960)r.getKey(), (EmiRenderable)EmiStack.of((class_1799)((LootCategory)r.getValue()).getIcon()))));
            blockCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            entityCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            gameplayCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            EmiRecipeCategory blockCategory = EmiCompatibility.createCategory(LootCategories.BLOCK_LOOT);
            EmiRecipeCategory plantCategory = EmiCompatibility.createCategory(LootCategories.PLANT_LOOT);
            EmiRecipeCategory entityCategory = EmiCompatibility.createCategory(LootCategories.ENTITY_LOOT);
            EmiRecipeCategory gameplayCategory = EmiCompatibility.createCategory(LootCategories.GAMEPLAY_LOOT);
            registry.addCategory(blockCategory);
            registry.addCategory(plantCategory);
            registry.addCategory(entityCategory);
            registry.addCategory(gameplayCategory);
            for (class_2248 block : class_7923.field_41175) {
                location = block.method_26162();
                class_1767[] lootEntry = map.get(location);
                if (lootEntry == null) continue;
                EmiRecipeCategory category = null;
                if (LootCategories.PLANT_LOOT.validate(block)) {
                    category = plantCategory;
                } else {
                    for (Map.Entry<LootCategory, EmiRecipeCategory> entry : blockCategoryMap.entrySet()) {
                        if (!entry.getKey().validate(block)) continue;
                        category = entry.getValue();
                    }
                    if (category == null) {
                        category = blockCategory;
                    }
                }
                registry.addRecipe((EmiRecipe)new EmiBlockLoot(category, new class_2960(location.method_12836(), "/" + location.method_12832()), block, (class_52)lootEntry, GenericUtils.getItems(location)));
                map.remove(location);
            }
            for (class_1299 entityType : class_7923.field_41177) {
                LinkedList<Object> entityList = new LinkedList<Object>();
                if (entityType == class_1299.field_6115) {
                    class_1472 sheep;
                    for (class_1767 color : class_1767.values()) {
                        class_1472 sheep2;
                        try {
                            sheep2 = (class_1472)entityType.method_5883((class_1937)level);
                        }
                        catch (Throwable e) {
                            LOGGER.warn("Failed to create colored sheep with color {}: {}", (Object)color.method_15434(), (Object)e.getMessage());
                            continue;
                        }
                        if (sheep2 == null) continue;
                        sheep2.method_6631(color);
                        entityList.add(sheep2);
                    }
                    try {
                        sheep = (class_1472)entityType.method_5883((class_1937)level);
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Failed to create sheep: {}", (Object)e.getMessage());
                        continue;
                    }
                    if (sheep != null) {
                        sheep.method_6635(true);
                        entityList.add(sheep);
                    }
                } else {
                    class_1297 entity2;
                    try {
                        entity2 = entityType.method_5883((class_1937)level);
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Failed to create entity {}: {}", (Object)class_7923.field_41177.method_10221((Object)entityType), (Object)e.getMessage());
                        continue;
                    }
                    entityList.add(entity2);
                }
                entityList.forEach(entity -> {
                    class_1308 mob;
                    class_2960 location;
                    class_52 lootEntry;
                    if (entity instanceof class_1308 && (lootEntry = (class_52)map.get(location = (mob = (class_1308)entity).method_5989())) != null) {
                        EmiRecipeCategory category = null;
                        for (Map.Entry entry : entityCategoryMap.entrySet()) {
                            if (!((LootCategory)entry.getKey()).validate(entity)) continue;
                            category = (EmiRecipeCategory)entry.getValue();
                        }
                        if (category == null) {
                            category = entityCategory;
                        }
                        registry.addRecipe((EmiRecipe)new EmiEntityLoot(category, new class_2960(location.method_12836(), "/" + location.method_12832()), (class_1297)entity, lootEntry, GenericUtils.getItems(location)));
                        map.remove(location);
                    }
                });
            }
            for (Map.Entry<class_2960, class_52> entry : map.entrySet()) {
                location = entry.getKey();
                EmiRecipeCategory category = null;
                for (Map.Entry<LootCategory, EmiRecipeCategory> gameplayEntry : gameplayCategoryMap.entrySet()) {
                    if (!gameplayEntry.getKey().validate(location.method_12832())) continue;
                    category = gameplayEntry.getValue();
                }
                if (category == null) {
                    category = gameplayCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiGameplayLoot(category, new class_2960(location.method_12836(), "/" + location.method_12832()), entry.getValue(), GenericUtils.getItems(location)));
            }
        }
    }

    @NotNull
    private static EmiRecipeCategory createCategory(LootCategory<?> category) {
        return new EmiRecipeCategory(Utils.modLoc(category.getKey()), (EmiRenderable)EmiStack.of((class_1799)category.getIcon()));
    }
}

