/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.client.GenericTooltipUtils;
import com.yanny.ali.plugin.client.TooltipUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_117;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_5341;
import net.minecraft.class_67;
import net.minecraft.class_6880;
import net.minecraft.class_73;
import net.minecraft.class_79;
import net.minecraft.class_85;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class EntryTooltipUtils {
    @NotNull
    public static List<class_2561> getLootTableTooltip(int pad, int quality, float chance) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
        components.addAll(EntryTooltipUtils.getQualityTooltip(quality));
        components.addAll(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap(chance)));
        return components;
    }

    @NotNull
    public static List<class_2561> getLootPoolTooltip(int pad, RangeValue rolls, RangeValue bonusRolls) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.random", new Object[0])));
        components.add(EntryTooltipUtils.getRolls(rolls, bonusRolls));
        return components;
    }

    public static @Unmodifiable @NotNull List<class_2561> getAlternativesTooltip(int pad) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.alternatives", new Object[0])));
    }

    @NotNull
    public static List<class_2561> getDynamicTooltip(int pad, class_67 entry, int sumWeight) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.dynamic", new Object[0])));
        components.addAll(EntryTooltipUtils.getQualityTooltip(entry.field_994));
        components.addAll(EntryTooltipUtils.getChanceTooltip(EntryTooltipUtils.getBaseMap((float)entry.field_995 / (float)sumWeight * 100.0f)));
        return components;
    }

    @NotNull
    public static List<class_2561> getEmptyTooltip(IClientUtils utils, class_73 entry, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        LinkedList<class_117> allFunctions = new LinkedList<class_117>(functions);
        LinkedList<class_5341> allConditions = new LinkedList<class_5341>(conditions);
        allFunctions.addAll(entry.field_996);
        allConditions.addAll(entry.field_988);
        float rawChance = (float)entry.field_995 / (float)sumWeight;
        Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance = TooltipUtils.getChance(utils, allConditions, rawChance);
        return EntryTooltipUtils.getTooltip(utils, (class_79)entry, chance, EntryTooltipUtils.getBaseMap(1.0f), allFunctions, allConditions);
    }

    public static @Unmodifiable @NotNull List<class_2561> getGroupTooltip(int pad) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.all", new Object[0])));
    }

    public static @Unmodifiable @NotNull List<class_2561> getSequentialTooltip(int pad) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.enum.group_type.sequence", new Object[0])));
    }

    @NotNull
    public static List<class_2561> getTooltip(IClientUtils utils, class_79 entry, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count, List<class_117> functions, List<class_5341> conditions) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        if (entry instanceof class_85) {
            class_85 singletonEntry = (class_85)entry;
            components.addAll(EntryTooltipUtils.getQualityTooltip(singletonEntry.field_994));
        }
        components.addAll(EntryTooltipUtils.getChanceTooltip(chance));
        components.addAll(EntryTooltipUtils.getCountTooltip(count));
        if (!conditions.isEmpty()) {
            components.add(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.conditions", new Object[0]));
            components.addAll(GenericTooltipUtils.getConditionsTooltip(utils, 0, conditions));
        }
        if (!functions.isEmpty()) {
            components.add(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.functions", new Object[0]));
            components.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, 0, functions));
        }
        return components;
    }

    @NotNull
    public static @Unmodifiable List<class_2561> getQualityTooltip(int quality) {
        if (quality != 0) {
            return List.of(GenericTooltipUtils.translatable("ali.description.quality", GenericTooltipUtils.value(quality)));
        }
        return List.of();
    }

    @NotNull
    public static List<class_2561> getChanceTooltip(Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        components.add(GenericTooltipUtils.translatable("ali.description.chance", GenericTooltipUtils.value(chance.get(null).get(0), "%")));
        for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceEntry : chance.entrySet()) {
            class_6880<class_1887> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                RangeValue value = levelEntry.getValue();
                components.add(GenericTooltipUtils.pad(1, GenericTooltipUtils.translatable("ali.description.chance_bonus", GenericTooltipUtils.value(value, "%"), GenericTooltipUtils.value(class_2561.method_43471((String)((class_1887)enchantment.comp_349()).method_8184())), GenericTooltipUtils.value(class_2561.method_43471((String)("enchantment.level." + level))))));
            }
        }
        return components;
    }

    @NotNull
    public static List<class_2561> getCountTooltip(Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        components.add(GenericTooltipUtils.translatable("ali.description.count", GenericTooltipUtils.value(count.get(null).get(0))));
        for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceEntry : count.entrySet()) {
            class_6880<class_1887> enchantment = chanceEntry.getKey();
            Map<Integer, RangeValue> levelMap = chanceEntry.getValue();
            if (enchantment == null) continue;
            for (Map.Entry<Integer, RangeValue> levelEntry : levelMap.entrySet()) {
                int level = levelEntry.getKey();
                RangeValue value = levelEntry.getValue();
                components.add(GenericTooltipUtils.pad(1, GenericTooltipUtils.translatable("ali.description.count_bonus", GenericTooltipUtils.value(value), GenericTooltipUtils.value(class_2561.method_43471((String)((class_1887)enchantment.comp_349()).method_8184())), GenericTooltipUtils.value(class_2561.method_43471((String)("enchantment.level." + level))))));
            }
        }
        return components;
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getBaseMap(float value) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> map = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(value)));
        return map;
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getBaseMap(float min, float max) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> map = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        map.put(null, Map.of(0, new RangeValue(min, max)));
        return map;
    }

    @NotNull
    private static class_2561 getRolls(RangeValue rolls, RangeValue bonusRolls) {
        return GenericTooltipUtils.translatable("ali.description.rolls", GenericTooltipUtils.value(EntryTooltipUtils.getTotalRolls(rolls, bonusRolls).toIntString(), "x"));
    }

    private static RangeValue getTotalRolls(RangeValue rolls, RangeValue bonusRolls) {
        if (bonusRolls.min() > 0.0f || bonusRolls.max() > 0.0f) {
            return new RangeValue(bonusRolls).add(rolls);
        }
        return rolls;
    }
}

