/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_106;
import net.minecraft.class_109;
import net.minecraft.class_114;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_125;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_137;
import net.minecraft.class_141;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_182;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_219;
import net.minecraft.class_225;
import net.minecraft.class_2561;
import net.minecraft.class_3670;
import net.minecraft.class_44;
import net.minecraft.class_5341;
import net.minecraft.class_5659;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_85;
import net.minecraft.class_94;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    private TooltipUtils() {
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getChance(IClientUtils utils, List<class_5341> conditions, float rawChance) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> chance = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (class_5341 condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<class_6880<class_1887>, Map<Integer, RangeValue>> getCount(IClientUtils utils, List<class_117> functions) {
        LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>> count = new LinkedHashMap<class_6880<class_1887>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (class_117 function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static class_1799 getItemStack(IClientUtils utils, class_79 entry, class_1792 item) {
        class_1799 itemStack = item.method_7854();
        if (entry.field_988.isEmpty() && entry instanceof class_85) {
            class_85 container = (class_85)entry;
            for (class_117 function : container.field_996) {
                itemStack = utils.applyItemStackModifier(utils, function, itemStack);
            }
        }
        return itemStack;
    }

    public static void applyRandomChance(IClientUtils utils, class_219 condition, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap : chance.entrySet()) {
            for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                levelEntry.getValue().multiply(condition.comp_1881());
            }
        }
    }

    public static void applyRandomChanceWithLooting(IClientUtils utils, class_225 condition, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        class_6880 enchantment = class_6880.method_40223((Object)class_1893.field_9110);
        if (chance.containsKey(enchantment)) {
            chance.get(null).get(0).multiply(condition.comp_1882());
            for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                entry.getValue().multiply(condition.comp_1882() + (float)entry.getKey().intValue() * condition.comp_1883());
            }
        } else {
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.comp_1882());
            chance.put((class_6880<class_1887>)enchantment, levelMap);
            for (int level = 1; level <= ((class_1887)enchantment.comp_349()).method_8183(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(condition.comp_1882() + (float)level * condition.comp_1883()));
            }
        }
    }

    public static void applyTableBonus(IClientUtils utils, class_182 condition, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        block2: {
            class_6880 enchantment;
            block3: {
                enchantment = condition.comp_1867();
                if (condition.comp_1868().isEmpty()) break block2;
                if (!chance.containsKey(enchantment)) break block3;
                chance.get(null).get(0).multiply(((Float)condition.comp_1868().get(0)).floatValue());
                if (condition.comp_1868().size() <= 1) break block2;
                for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                    Integer level = entry.getKey();
                    if (level >= condition.comp_1868().size()) continue;
                    entry.getValue().multiply(((Float)condition.comp_1868().get(level)).floatValue());
                }
                break block2;
            }
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(((Float)condition.comp_1868().get(0)).floatValue());
            chance.put((class_6880<class_1887>)enchantment, levelMap);
            for (int level = 1; level <= ((class_1887)enchantment.comp_349()).method_8183() && level < condition.comp_1868().size(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(((Float)condition.comp_1868().get(level)).floatValue()));
            }
        }
    }

    public static void applySetCount(IClientUtils utils, class_141 function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        if (function.field_1047.isEmpty()) {
            for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> chanceMap : count.entrySet()) {
                for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                    if (function.field_27909) {
                        levelEntry.getValue().add(utils.convertNumber(utils, function.field_1114));
                        continue;
                    }
                    levelEntry.getValue().set(utils.convertNumber(utils, function.field_1114));
                }
            }
        }
    }

    public static void applyBonus(IClientUtils utils, class_94 function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        block4: {
            if (!function.field_1047.isEmpty()) break block4;
            class_6880 enchantment = function.field_1011;
            if (count.containsKey(enchantment)) {
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    TooltipUtils.calculateCount(function, entry.getValue(), entry.getKey());
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                count.put((class_6880<class_1887>)enchantment, levelMap);
                for (int level = 1; level <= ((class_1887)enchantment.comp_349()).method_8183(); ++level) {
                    RangeValue value = new RangeValue(baseCount);
                    TooltipUtils.calculateCount(function, value, level);
                    levelMap.put(level, value);
                }
            }
        }
    }

    public static void applyLimitCount(IClientUtils utils, class_114 function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> bonusCount) {
        if (function.field_1047.isEmpty()) {
            for (Map.Entry<class_6880<class_1887>, Map<Integer, RangeValue>> entry : bonusCount.entrySet()) {
                for (Map.Entry<Integer, RangeValue> mapEntry : entry.getValue().entrySet()) {
                    RangeValue value = mapEntry.getValue();
                    value.clamp(utils.convertNumber(utils, function.field_1044.field_921), utils.convertNumber(utils, function.field_1044.field_920));
                }
            }
        }
    }

    public static void applyLootingEnchant(IClientUtils utils, class_125 function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        block5: {
            if (!function.field_1047.isEmpty()) break block5;
            class_6880 enchantment = class_6880.method_40223((Object)class_1893.field_9110);
            if (count.containsKey(enchantment)) {
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    RangeValue value = entry.getValue();
                    value.add(utils.convertNumber(utils, function.field_1082).multiply(entry.getKey().intValue()));
                    if (function.field_1083 <= 0) continue;
                    value.clamp(new RangeValue(false, true), new RangeValue(function.field_1083));
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                count.put((class_6880<class_1887>)enchantment, levelMap);
                for (int level = 1; level <= ((class_1887)enchantment.comp_349()).method_8183(); ++level) {
                    RangeValue value = new RangeValue(baseCount).add(utils.convertNumber(utils, function.field_1082).multiply(level));
                    if (function.field_1083 > 0) {
                        value.clamp(new RangeValue(false, true), new RangeValue(function.field_1083));
                    }
                    levelMap.put(level, value);
                }
            }
        }
    }

    @NotNull
    public static class_1799 applyEnchantRandomlyItemStackModifier(IClientUtils utils, class_109 function, class_1799 itemStack) {
        if (itemStack.method_7923() && function.field_1047.isEmpty()) {
            List<class_6880.class_6883> list;
            boolean isBook = itemStack.method_31574(class_1802.field_8529);
            class_1799 finalItemStack = itemStack;
            Optional<class_6885.class_6886> enchantments = function.field_1030;
            if (enchantments.isEmpty() && (list = class_7923.field_41176.method_40270().filter(ref -> ((class_1887)ref.comp_349()).method_25950()).filter(ref -> isBook || ((class_1887)ref.comp_349()).method_8192(finalItemStack)).toList()).size() == 1) {
                enchantments = Optional.of(class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)list.get(0)}));
            }
            if (enchantments.isPresent() && ((class_6885)enchantments.get()).method_40247() == 1 && ((class_1887)((class_6885)enchantments.get()).method_40240(0).comp_349()).method_8187() == ((class_1887)((class_6885)enchantments.get()).method_40240(0).comp_349()).method_8183()) {
                itemStack.method_7978((class_1887)((class_6885)enchantments.get()).method_40240(0).comp_349(), ((class_1887)((class_6885)enchantments.get()).method_40240(0).comp_349()).method_8183());
            } else if (isBook) {
                itemStack = class_1802.field_8598.method_7854();
            }
        }
        return itemStack;
    }

    @NotNull
    public static class_1799 applyEnchantWithLevelsItemStackModifier(IClientUtils utils, class_106 function, class_1799 itemStack) {
        if (itemStack.method_7923() && function.field_1047.isEmpty() && itemStack.method_31574(class_1802.field_8529)) {
            itemStack = class_1802.field_8598.method_7854();
        }
        return itemStack;
    }

    public static class_1799 applySetAttributesItemStackModifier(IClientUtils utils, class_137 function, class_1799 itemStack) {
        if (function.field_1047.isEmpty()) {
            for (class_137.class_138 modifier : function.field_1105) {
                UUID id = modifier.comp_1864().orElse(UUID.randomUUID());
                if (modifier.comp_1863().size() != 1 || modifier.comp_1862().method_365() != class_5659.field_27921) continue;
                class_1304 equipmentSlot = (class_1304)class_156.method_32309((List)modifier.comp_1863(), (class_5819)class_5819.method_43047());
                class_44 value = (class_44)modifier.comp_1862();
                itemStack.method_7916((class_1320)modifier.comp_1860().comp_349(), new class_1322(id, modifier.comp_1859(), (double)value.method_32454(null), modifier.comp_1861()), equipmentSlot);
            }
        }
        return itemStack;
    }

    public static class_1799 applySetNameItemStackModifier(IClientUtils utils, class_3670 function, class_1799 itemStack) {
        if (function.field_1047.isEmpty() && function.field_16228.isPresent()) {
            itemStack.method_7977((class_2561)function.field_16228.get());
        }
        return itemStack;
    }

    public static class_1799 applyItemStackModifier(IClientUtils utils, class_117 function, class_1799 itemStack) {
        if (function instanceof class_120) {
            class_120 conditional = (class_120)function;
            if (!conditional.field_1047.isEmpty()) {
                return itemStack;
            }
        }
        itemStack = (class_1799)function.apply((Object)itemStack, null);
        return itemStack;
    }

    private static void calculateCount(class_94 function, RangeValue value, int level) {
        if (function.field_1009 instanceof class_94.class_98) {
            if (level > 0) {
                value.multiplyMax(level + 1);
            }
        } else {
            class_94.class_96 class_962 = function.field_1009;
            if (class_962 instanceof class_94.class_95) {
                class_94.class_95 binomialWithBonusCount = (class_94.class_95)class_962;
                value.addMax(binomialWithBonusCount.comp_1848() + level);
            } else {
                class_962 = function.field_1009;
                if (class_962 instanceof class_94.class_100) {
                    class_94.class_100 uniformBonusCount = (class_94.class_100)class_962;
                    if (level > 0) {
                        value.addMax(uniformBonusCount.comp_1852() * level);
                    }
                }
            }
        }
    }
}

