/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget;

import com.mojang.datafixers.util.Pair;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IEntryWidget;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.client.WidgetUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_117;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5341;
import net.minecraft.class_69;
import net.minecraft.class_79;
import org.jetbrains.annotations.NotNull;

public class CompositeWidget
implements IEntryWidget {
    private final Rect bounds;
    protected final List<IWidget> widgets;
    private final class_79 entry;
    private final IClientUtils utils;

    public CompositeWidget(IWidgetUtils utils, class_79 entry, int x, int y, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        class_69 compositeEntry = (class_69)entry;
        LinkedList<class_5341> allConditions = new LinkedList<class_5341>(conditions);
        allConditions.addAll(compositeEntry.field_988);
        Pair<List<IEntryWidget>, Rect> pair = utils.createWidgets(utils, compositeEntry.field_982, x, y, List.copyOf(functions), allConditions);
        this.widgets = new LinkedList<IWidget>((Collection)pair.getFirst());
        this.bounds = (Rect)pair.getSecond();
        this.entry = entry;
        this.utils = utils;
    }

    @Override
    public Rect getRect() {
        return this.bounds;
    }

    @Override
    public class_79 getLootEntry() {
        return this.entry;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY) {
        int lastY = 0;
        WidgetDirection lastDirection = null;
        for (IWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY);
            if (!(widget instanceof IEntryWidget)) continue;
            IEntryWidget entryWidget = (IEntryWidget)widget;
            WidgetDirection direction = this.utils.getWidgetDirection(entryWidget.getLootEntry());
            if (direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) {
                lastY = Math.max(lastY, widget.getRect().y());
            }
            lastDirection = direction;
        }
        int top = this.bounds.y() + 18;
        int height = lastY - this.bounds.y() - 9;
        WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 3, top, 2, height, 0, 0, 2, 18);
        lastDirection = null;
        for (IWidget widget : this.widgets) {
            if (!(widget instanceof IEntryWidget)) continue;
            IEntryWidget entryWidget = (IEntryWidget)widget;
            WidgetDirection direction = this.utils.getWidgetDirection(entryWidget.getLootEntry());
            if ((direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) && widget.getRect().y() > this.bounds.y() + 18) {
                WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 4, widget.getRect().y() + 8, 3, 2, 2, 0, 18, 2);
            }
            lastDirection = direction;
        }
    }

    @Override
    public List<class_2561> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            components.addAll(widget.getTooltipComponents(mouseX, mouseY));
        }
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = false;
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            clicked |= widget.mouseClicked(mouseX, mouseY, button);
        }
        return clicked;
    }

    @NotNull
    public static Rect getBounds(IClientUtils utils, class_79 entry, int x, int y) {
        return utils.getBounds(utils, ((class_69)entry).field_982, x, y);
    }
}

