/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget;

import com.mojang.datafixers.util.Pair;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IEntryWidget;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.client.WidgetUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_117;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import org.jetbrains.annotations.NotNull;

public class LootPoolWidget
implements IWidget {
    private final List<IWidget> widgets;
    private final Rect bounds;
    private final IClientUtils utils;

    public LootPoolWidget(IWidgetUtils utils, class_55 entry, int x, int y, List<class_117> functions, List<class_5341> conditions) {
        LinkedList<class_117> allFunctions = new LinkedList<class_117>(functions);
        LinkedList<class_5341> allConditions = new LinkedList<class_5341>(conditions);
        allFunctions.addAll(entry.field_956);
        allConditions.addAll(entry.field_954);
        Pair<List<IEntryWidget>, Rect> info = utils.createWidgets(utils, entry.field_953, x, y, List.copyOf(allFunctions), List.copyOf(allConditions));
        this.widgets = new LinkedList<IWidget>((Collection)info.getFirst());
        this.widgets.add(WidgetUtils.getLootPoolTypeWidget(x, y, utils.convertNumber(utils, entry.field_957), utils.convertNumber(utils, entry.field_958)));
        this.bounds = (Rect)info.getSecond();
        this.utils = utils;
    }

    @Override
    public Rect getRect() {
        return this.bounds;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY) {
        int lastY = 0;
        WidgetDirection lastDirection = null;
        for (IWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY);
            if (!(widget instanceof IEntryWidget)) continue;
            IEntryWidget entryWidget = (IEntryWidget)widget;
            WidgetDirection direction = this.utils.getWidgetDirection(entryWidget.getLootEntry());
            if (direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) {
                lastY = Math.max(lastY, widget.getRect().y());
            }
            lastDirection = direction;
        }
        int top = this.bounds.y() + 18;
        int height = lastY - this.bounds.y() - 9;
        WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 3, top, 2, height, 0, 0, 2, 18);
        lastDirection = null;
        for (IWidget widget : this.widgets) {
            if (!(widget instanceof IEntryWidget)) continue;
            IEntryWidget entryWidget = (IEntryWidget)widget;
            WidgetDirection direction = this.utils.getWidgetDirection(entryWidget.getLootEntry());
            if ((direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) && widget.getRect().y() > this.bounds.y() + 18) {
                WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 4, widget.getRect().y() + 8, 3, 2, 2, 0, 18, 2);
            }
            lastDirection = direction;
        }
    }

    @Override
    public List<class_2561> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<class_2561> components = new LinkedList<class_2561>();
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            components.addAll(widget.getTooltipComponents(mouseX, mouseY));
        }
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = false;
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            clicked |= widget.mouseClicked(mouseX, mouseY, button);
        }
        return clicked;
    }

    @NotNull
    public static Rect getBounds(IClientUtils registry, class_55 entry, int x, int y) {
        return registry.getBounds(registry, entry.field_953, x, y);
    }
}

