/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.ICommonRegistry;
import com.yanny.ali.api.ICommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class AliCommonRegistry
implements ICommonRegistry,
ICommonUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<EntityType<?>, Function<Level, List<Entity>>> entityVariantsMap = new HashMap();

    @Override
    public <T extends Entity> void registerEntityVariants(EntityType<T> type, Function<Level, List<Entity>> factory) {
        this.entityVariantsMap.put(type, factory);
    }

    @Override
    public List<Entity> createEntities(EntityType<?> type, Level level) {
        Function<Level, List<Entity>> factory = this.entityVariantsMap.get(type);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (factory == null) {
            factory = l -> {
                Entity entity = type.m_20615_(l);
                if (entity != null) {
                    return Collections.singletonList(entity);
                }
                LOGGER.warn("Failed to create entity: {} (NULL)", (Object)type);
                return Collections.emptyList();
            };
        }
        try {
            entities.addAll((Collection)factory.apply(level));
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to create entity: {}", (Object)e.getMessage());
        }
        return entities;
    }

    public void printRegistrationInfo() {
        LOGGER.info("Registered {} entity variants", (Object)this.entityVariantsMap.size());
    }
}

