/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.IType;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.client.EntryTooltipUtils;
import com.yanny.ali.plugin.client.TooltipUtils;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import com.yanny.ali.registries.LootCategory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public abstract class JeiBaseLoot<T extends IType, V>
implements IRecipeCategory<T> {
    private static final Map<IType, Pair<IWidget, List<ISlotParams>>> widgets = new HashMap<IType, Pair<IWidget, List<ISlotParams>>>();
    private final RecipeType<T> recipeType;
    private final LootCategory<V> lootCategory;
    private final Component title;
    private final IDrawable icon;
    protected final IGuiHelper guiHelper;

    public JeiBaseLoot(IGuiHelper guiHelper, RecipeType<T> recipeType, LootCategory<V> lootCategory, Component title, IDrawable icon) {
        this.guiHelper = guiHelper;
        this.recipeType = recipeType;
        this.lootCategory = lootCategory;
        this.title = title;
        this.icon = icon;
    }

    @NotNull
    public final RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public final Component getTitle() {
        return this.title;
    }

    @NotNull
    public final IDrawable getIcon() {
        return this.icon;
    }

    public LootCategory<V> getLootCategory() {
        return this.lootCategory;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup iFocusGroup) {
        LinkedList<ISlotParams> slotParams = new LinkedList<ISlotParams>();
        IWidgetUtils utils = this.getJeiUtils(slotParams);
        widgets.put((IType)recipe, (Pair<IWidget, List<ISlotParams>>)new Pair((Object)new LootTableWidget(utils, recipe.entry(), 0, this.getYOffset(recipe)), slotParams));
        for (int i = 0; i < slotParams.size(); ++i) {
            ISlotParams p = (ISlotParams)slotParams.get(i);
            if (p instanceof ItemSlotParams) {
                ItemSlotParams itemSlotParams = (ItemSlotParams)p;
                builder.addSlot(RecipeIngredientRole.OUTPUT, itemSlotParams.x + 1, itemSlotParams.y + 1).setSlotName(String.valueOf(i)).addRichTooltipCallback((iRecipeSlotView, components) -> components.addAll(EntryTooltipUtils.getTooltip(utils, p.entry(), p.chance(), p.count(), p.allFunctions(), p.allConditions()))).addItemStack(itemSlotParams.item);
                continue;
            }
            if (!(p instanceof TagSlotParams)) continue;
            TagSlotParams tagSlotParams = (TagSlotParams)p;
            builder.addSlot(RecipeIngredientRole.OUTPUT, tagSlotParams.x + 1, tagSlotParams.y + 1).setSlotName(String.valueOf(i)).addRichTooltipCallback((iRecipeSlotView, components) -> components.addAll(EntryTooltipUtils.getTooltip(utils, p.entry(), p.chance(), p.count(), p.allFunctions(), p.allConditions()))).addIngredients(Ingredient.m_204132_(tagSlotParams.item));
        }
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Pair<IWidget, List<ISlotParams>> pair = widgets.get(recipe);
        if (pair == null) {
            return;
        }
        IWidget widget = (IWidget)pair.getA();
        List slotParams = (List)pair.getB();
        widget.render(guiGraphics, (int)mouseX, (int)mouseY);
        guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, widget.getTooltipComponents((int)mouseX, (int)mouseY), Optional.empty(), (int)mouseX, (int)mouseY);
        for (int i = 0; i < slotParams.size(); ++i) {
            ISlotParams p = (ISlotParams)slotParams.get(i);
            this.guiHelper.getSlotDrawable().draw(guiGraphics, p.x(), p.y());
            recipeSlotsView.findSlotByName(String.valueOf(i)).ifPresent(slotView -> {
                RangeValue value = p.count().get(null).get(0);
                if (value.isRange() || value.min() > 1.0f) {
                    MutableComponent count = Component.m_237113_((String)value.toIntString());
                    boolean isRange = value.isRange();
                    Font font = Minecraft.m_91087_().f_91062_;
                    PoseStack stack = guiGraphics.m_280168_();
                    stack.m_85836_();
                    stack.m_252880_((float)p.x(), (float)p.y(), 0.0f);
                    if (isRange) {
                        stack.m_252880_(17.0f, 13.0f, 200.0f);
                        stack.m_85836_();
                        stack.m_85841_(0.5f, 0.5f, 0.5f);
                        guiGraphics.m_280614_(font, (Component)count, -font.m_92852_((FormattedText)count), 0, 0xFFFFFF, false);
                        stack.m_85849_();
                    } else {
                        stack.m_252880_(18.0f, 10.0f, 200.0f);
                        guiGraphics.m_280614_(font, (Component)count, -font.m_92852_((FormattedText)count), 0, 0xFFFFFF, true);
                    }
                    stack.m_85849_();
                }
            });
        }
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 1024;
    }

    abstract int getYOffset(T var1);

    @NotNull
    private IWidgetUtils getJeiUtils(final List<ISlotParams> slotParams) {
        return new ClientUtils(this){

            @Override
            public Rect addSlotWidget(Item item, LootPoolEntryContainer entry, int x, int y, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> allFunctions, List<LootItemCondition> allConditions) {
                ItemStack itemStack = TooltipUtils.getItemStack(this, entry, item);
                slotParams.add(new ItemSlotParams(itemStack, entry, x, y, chance, count, allFunctions, allConditions));
                return new Rect(x, y, 18, 18);
            }

            @Override
            public Rect addSlotWidget(TagKey<Item> item, LootPoolEntryContainer entry, int x, int y, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> allFunctions, List<LootItemCondition> allConditions) {
                slotParams.add(new TagSlotParams(item, entry, x, y, chance, count, allFunctions, allConditions));
                return new Rect(x, y, 18, 18);
            }
        };
    }

    private static interface ISlotParams {
        public LootPoolEntryContainer entry();

        public int x();

        public int y();

        public Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance();

        public Map<Holder<Enchantment>, Map<Integer, RangeValue>> count();

        public List<LootItemFunction> allFunctions();

        public List<LootItemCondition> allConditions();
    }

    private record ItemSlotParams(ItemStack item, LootPoolEntryContainer entry, int x, int y, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> allFunctions, List<LootItemCondition> allConditions) implements ISlotParams
    {
    }

    private record TagSlotParams(TagKey<Item> item, LootPoolEntryContainer entry, int x, int y, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count, List<LootItemFunction> allFunctions, List<LootItemCondition> allConditions) implements ISlotParams
    {
    }
}

