/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.InfoSyncLootTableMessage;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootTable;
import org.slf4j.Logger;

public abstract class AbstractServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<InfoSyncLootTableMessage> messages = new LinkedList<InfoSyncLootTableMessage>();

    public final void readLootTables(ReloadableServerRegistries.Holder manager, ServerLevel level) {
        this.messages.clear();
        manager.m_323327_().m_254861_(Registries.f_314309_).ifPresent(lookup -> {
            lookup.m_214062_().forEach(reference -> PluginManager.SERVER_REGISTRY.addLootTable((ResourceKey<LootTable>)reference.m_205785_(), (LootTable)reference.m_203334_()));
            lookup.m_214062_().forEach(reference -> {
                ResourceKey location = reference.m_205785_();
                LootTable table = (LootTable)reference.m_203334_();
                if (table != LootTable.f_79105_) {
                    List<Item> items = ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, table);
                    if (!items.isEmpty()) {
                        this.messages.add(new InfoSyncLootTableMessage((ResourceKey<LootTable>)location, table, items));
                    } else {
                        LOGGER.info("LootTable {} has no items", (Object)location);
                    }
                } else {
                    LOGGER.warn("Ignoring {} LootTable, because it's empty or null", (Object)location);
                }
            });
        });
        LOGGER.info("Prepared {} loot tables", (Object)this.messages.size());
    }

    public final void syncLootTables(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.sendClearMessage(serverPlayer, new ClearMessage());
            for (InfoSyncLootTableMessage message : this.messages) {
                this.sendSyncMessage(serverPlayer, message);
            }
        }
    }

    protected abstract void sendClearMessage(ServerPlayer var1, ClearMessage var2);

    protected abstract void sendSyncMessage(ServerPlayer var1, InfoSyncLootTableMessage var2);
}

