/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.GameTypePredicate;
import net.minecraft.advancements.critereon.ItemAttributeModifiersPredicate;
import net.minecraft.advancements.critereon.ItemFireworkExplosionPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemWritableBookPredicate;
import net.minecraft.advancements.critereon.ItemWrittenBookPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulator;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GenericTooltipUtils {
    private static final ChatFormatting TEXT_STYLE = ChatFormatting.GOLD;
    private static final ChatFormatting PARAM_STYLE = ChatFormatting.AQUA;

    @NotNull
    public static List<Component> getConditionsTooltip(IClientUtils utils, int pad, List<LootItemCondition> conditions) {
        return conditions.stream().map(condition -> utils.getConditionTooltip(utils, pad, condition)).flatMap(Collection::stream).toList();
    }

    @NotNull
    public static List<Component> getFunctionsTooltip(IClientUtils utils, int pad, List<LootItemFunction> functions) {
        return functions.stream().map(function -> {
            LinkedList<Component> components = new LinkedList<Component>(utils.getFunctionTooltip(utils, pad, function));
            if (function instanceof LootItemConditionalFunction) {
                LootItemConditionalFunction conditionalFunction = (LootItemConditionalFunction)function;
                if (!conditionalFunction.f_80676_.isEmpty()) {
                    components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.conditions", new Object[0])));
                    components.addAll(GenericTooltipUtils.getConditionsTooltip(utils, pad + 2, conditionalFunction.f_80676_));
                }
            }
            return components;
        }).flatMap(Collection::stream).toList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<Component> getFormulaTooltip(IClientUtils utils, int pad, ApplyBonusCount.Formula formula) {
        LinkedList<Component> components = new LinkedList<Component>(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.formula", formula.m_5713_().f_291058_()));
        if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
            float probability;
            ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
            try {
                float f;
                int n;
                int extraRounds = n = binomialWithBonusCount.f_79948_();
                probability = f = binomialWithBonusCount.f_79949_();
                components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.extra_rounds", extraRounds));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 1, "ali.property.value.probability", Float.valueOf(probability)));
            return components;
        }
        if (!(formula instanceof ApplyBonusCount.UniformBonusCount)) return components;
        ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
        {
            int n;
            int bonusMultiplier = n = uniformBonusCount.f_80013_();
            components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.bonus_multiplier", bonusMultiplier));
        }
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getBlockTooltip(IClientUtils ignoredUtils, int pad, Block block) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.block", GenericTooltipUtils.value(GenericTooltipUtils.translatable(block.m_7705_(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getPropertyTooltip(IClientUtils ignoredUtils, int pad, Property<?> property) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.pair(property.m_61708_(), property.m_6908_().toString()))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnchantmentTooltip(IClientUtils utils, int pad, Enchantment enchantment) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.enchantment", GenericTooltipUtils.value(enchantment.f_337607_()))));
    }

    @NotNull
    public static List<Component> getModifierTooltip(IClientUtils utils, int pad, SetAttributesFunction.Modifier modifier) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.modifier", new Object[0])));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, modifier.f_80848_(), GenericTooltipUtils::getAttributeTooltip));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.operation", modifier.f_80849_()));
        components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 1, "ali.property.value.amount", modifier.f_80850_()));
        components.addAll(GenericTooltipUtils.getResourceLocationTooltip(utils, pad + 1, "ali.property.value.id", modifier.f_80851_()));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.equipment_slots", modifier.f_80852_(), GenericTooltipUtils::getEnumTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getAttributeTooltip(IClientUtils ignoredUtils, int pad, Attribute attribute) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.attribute", GenericTooltipUtils.value(GenericTooltipUtils.translatable(attribute.m_22087_(), new Object[0])))));
    }

    @NotNull
    public static List<Component> getBannerPatternLayersTooltip(IClientUtils utils, int pad, BannerPatternLayers bannerPatternLayers) {
        return GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.banner_patterns", bannerPatternLayers.f_315710_(), GenericTooltipUtils::getBannerPatternLayerTooltip);
    }

    @NotNull
    public static List<Component> getBannerPatternLayerTooltip(IClientUtils utils, int pad, BannerPatternLayers.Layer layer) {
        return GenericTooltipUtils.getHolderTooltip(utils, pad, layer.f_316420_(), (u, p, b) -> GenericTooltipUtils.getBannerPatternTooltip(u, p, b, layer.f_316009_()));
    }

    public static @Unmodifiable @NotNull List<Component> getBannerPatternTooltip(IClientUtils ignoredUtils, int pad, BannerPattern bannerPattern, DyeColor color) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.banner_pattern", GenericTooltipUtils.value(GenericTooltipUtils.translatable(bannerPattern.f_315615_() + "." + color.m_41065_(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getBlockEntityTypeTooltip(IClientUtils ignoredUtils, int pad, BlockEntityType<?> blockEntityType) {
        ResourceLocation location = ((ResourceKey)Objects.requireNonNull(blockEntityType.m_294149_()).m_203543_().orElseThrow()).m_135782_();
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.block_entity_type", GenericTooltipUtils.value(location))));
    }

    @NotNull
    public static List<Component> getPotionTooltip(IClientUtils utils, int pad, Potion potion) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.potion", Objects.requireNonNull(BuiltInRegistries.f_256980_.m_7981_((Object)potion)));
    }

    public static @Unmodifiable @NotNull List<Component> getMobEffectTooltip(IClientUtils utils, int pad, MobEffect mobEffect) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.mob_effect", GenericTooltipUtils.value(Objects.requireNonNull(BuiltInRegistries.f_256974_.m_7981_((Object)mobEffect))))));
    }

    @NotNull
    public static List<Component> getStatePropertiesPredicateTooltip(IClientUtils utils, int pad, StatePropertiesPredicate propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.state_properties_predicate", propertiesPredicate.f_67659_(), GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static List<Component> getPropertyMatcherTooltip(IClientUtils utils, int pad, StatePropertiesPredicate.PropertyMatcher propertyMatcher) {
        Optional maxValue;
        String name;
        LinkedList<Component> components;
        block7: {
            Optional minValue;
            block8: {
                Optional optional;
                Object object;
                StatePropertiesPredicate.ExactMatcher exactMatcher;
                components = new LinkedList<Component>();
                name = propertyMatcher.f_67715_();
                StatePropertiesPredicate.ValueMatcher valueMatcher = propertyMatcher.f_291902_();
                if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
                    exactMatcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
                    Object value = object = exactMatcher.f_290506_();
                    components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.keyValue(name, value)));
                }
                if (!((object = propertyMatcher.f_291902_()) instanceof StatePropertiesPredicate.RangedMatcher)) return components;
                exactMatcher = (StatePropertiesPredicate.RangedMatcher)object;
                try {
                    minValue = optional = exactMatcher.f_291542_();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                maxValue = optional = exactMatcher.f_291806_();
                if (!minValue.isPresent()) break block7;
                if (!maxValue.isPresent()) break block8;
                components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_both", name, minValue.get(), maxValue.get()))));
                return components;
            }
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_gte", name, minValue.get()))));
            return components;
        }
        if (maxValue.isPresent()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_lte", name, maxValue.get()))));
            return components;
        } else {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_any", name))));
        }
        return components;
    }

    @NotNull
    public static List<Component> getDamageSourcePredicateTooltip(IClientUtils utils, int pad, DamageSourcePredicate damagePredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.damage_source_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.tag_predicates", damagePredicate.f_268608_(), GenericTooltipUtils::getTagPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.direct_entity", damagePredicate.f_25429_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.source_entity", damagePredicate.f_25430_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_direct", damagePredicate.f_337324_(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    public static <T> @Unmodifiable @NotNull List<Component> getTagPredicateTooltip(IClientUtils utils, int pad, TagPredicate<T> tagPredicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.keyValue(tagPredicate.f_268479_().f_203868_(), tagPredicate.f_268414_())));
    }

    @NotNull
    public static List<Component> getEntityPredicateTooltip(IClientUtils utils, int pad, EntityPredicate entityPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36551_(), GenericTooltipUtils::getEntityTypePredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.distance_to_player", entityPredicate.f_36552_(), GenericTooltipUtils::getDistancePredicateTooltip));
        components.addAll(GenericTooltipUtils.getLocationWrapperTooltip(utils, pad, "ali.property.branch.location", entityPredicate.f_36553_()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_336844_(), GenericTooltipUtils::getMovementPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.periodic_tick", entityPredicate.f_337247_(), GenericTooltipUtils::getIntegerTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36554_(), GenericTooltipUtils::getMobEffectPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36555_(), GenericTooltipUtils::getNbtPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36556_(), GenericTooltipUtils::getEntityFlagsPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, entityPredicate.f_36557_(), GenericTooltipUtils::getEntityEquipmentPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.entity_sub_predicate", entityPredicate.f_218773_(), utils::getEntitySubPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.vehicle", entityPredicate.f_36560_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.passenger", entityPredicate.f_150287_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad, "ali.property.branch.targeted_entity", entityPredicate.f_36561_(), GenericTooltipUtils::getEntityPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.team", entityPredicate.f_36562_(), GenericTooltipUtils::getStringTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityTypePredicateTooltip(IClientUtils utils, int pad, EntityTypePredicate entityTypePredicate) {
        return GenericTooltipUtils.getHolderSetTooltip(utils, pad, "ali.property.branch.entity_types", entityTypePredicate.f_290696_(), GenericTooltipUtils::getEntityTypeTooltip);
    }

    public static @Unmodifiable @NotNull List<Component> getEntityTypeTooltip(IClientUtils utils, int pad, EntityType<?> entityType) {
        return GenericTooltipUtils.getComponentTooltip(utils, pad, "ali.property.value.entity_type", GenericTooltipUtils.value(GenericTooltipUtils.translatable(entityType.m_20675_(), new Object[0])));
    }

    @NotNull
    public static List<Component> getDistancePredicateTooltip(IClientUtils utils, int pad, DistancePredicate distancePredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.x", distancePredicate.f_26242_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.y", distancePredicate.f_26243_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.z", distancePredicate.f_26244_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.horizontal", distancePredicate.f_26245_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.absolute", distancePredicate.f_26246_()));
        return components;
    }

    @NotNull
    public static List<Component> getLocationPredicateTooltip(IClientUtils utils, int pad, String key, LocationPredicate locationPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, locationPredicate.f_290578_(), GenericTooltipUtils::getPositionPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.biomes", locationPredicate.f_314588_(), (u, p, s, h) -> GenericTooltipUtils.getHolderSetTooltip(u, (int)p, s, h, "ali.property.value.biome")));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.structures", locationPredicate.f_316568_(), (u, p, s, h) -> GenericTooltipUtils.getHolderSetTooltip(u, (int)p, s, h, "ali.property.value.structure")));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.dimension", locationPredicate.f_52599_(), GenericTooltipUtils::getResourceKeyTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.smokey", locationPredicate.f_52600_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, locationPredicate.f_52601_(), GenericTooltipUtils::getLightPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, locationPredicate.f_52602_(), GenericTooltipUtils::getBlockPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, locationPredicate.f_52603_(), GenericTooltipUtils::getFluidPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.can_see_sky", locationPredicate.f_336725_(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getPositionPredicateTooltip(IClientUtils utils, int pad, LocationPredicate.PositionPredicate positionPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.position", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.x", positionPredicate.f_291501_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.y", positionPredicate.f_291292_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.z", positionPredicate.f_290699_()));
        return components;
    }

    @NotNull
    public static List<Component> getLightPredicateTooltip(IClientUtils utils, int pad, LightPredicate lightPredicate) {
        return GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.light", lightPredicate.f_51336_());
    }

    @NotNull
    public static List<Component> getBlockPredicateTooltip(IClientUtils utils, int pad, BlockPredicate blockPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.block_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad + 1, "ali.property.branch.blocks", blockPredicate.f_146710_(), GenericTooltipUtils::getBlockTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, blockPredicate.f_17905_(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, blockPredicate.f_17906_(), GenericTooltipUtils::getNbtPredicateTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getNbtPredicateTooltip(IClientUtils utils, int pad, NbtPredicate nbtPredicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.nbt", GenericTooltipUtils.value(nbtPredicate.f_57472_()))));
    }

    @NotNull
    public static List<Component> getFluidPredicateTooltip(IClientUtils utils, int pad, FluidPredicate fluidPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.fluid_predicate", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad + 1, "ali.property.branch.fluids", fluidPredicate.f_315771_(), GenericTooltipUtils::getFluidTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, fluidPredicate.f_41097_(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getFluidTooltip(IClientUtils utils, int pad, Fluid fluid) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.fluid", BuiltInRegistries.f_257020_.m_7981_((Object)fluid));
    }

    @NotNull
    public static List<Component> getMobEffectPredicateTooltip(IClientUtils utils, int pad, MobEffectsPredicate mobEffectsPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.mob_effects", new Object[0])));
        mobEffectsPredicate.f_290320_().forEach((effect, instancePredicate) -> {
            components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, effect, GenericTooltipUtils::getMobEffectTooltip));
            components.addAll(GenericTooltipUtils.getMobEffectInstancePredicateTooltip(utils, pad + 2, instancePredicate));
        });
        return components;
    }

    @NotNull
    public static List<Component> getMobEffectInstancePredicateTooltip(IClientUtils utils, int pad, MobEffectsPredicate.MobEffectInstancePredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.amplifier", predicate.f_56566_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.duration", predicate.f_56567_()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.is_ambient", predicate.f_56568_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.is_visible", predicate.f_56569_(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityFlagsPredicateTooltip(IClientUtils utils, int pad, EntityFlagsPredicate entityFlagsPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.entity_flags", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_on_ground", entityFlagsPredicate.f_337406_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_on_fire", entityFlagsPredicate.f_33683_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_baby", entityFlagsPredicate.f_33687_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_crouching", entityFlagsPredicate.f_33684_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_sprinting", entityFlagsPredicate.f_33685_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_swimming", entityFlagsPredicate.f_33686_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.is_flying", entityFlagsPredicate.f_336930_(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEntityEquipmentPredicateTooltip(IClientUtils utils, int pad, EntityEquipmentPredicate entityEquipmentPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.entity_equipment", new Object[0])));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.head", entityEquipmentPredicate.f_32178_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.chest", entityEquipmentPredicate.f_32179_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.legs", entityEquipmentPredicate.f_32180_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.feet", entityEquipmentPredicate.f_32181_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.mainhand", entityEquipmentPredicate.f_32182_(), GenericTooltipUtils::getItemPredicateTooltip));
        components.addAll(GenericTooltipUtils.getComponentsTooltip(utils, pad + 1, "ali.property.branch.offhand", entityEquipmentPredicate.f_32183_(), GenericTooltipUtils::getItemPredicateTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getItemPredicateTooltip(IClientUtils utils, int pad, ItemPredicate itemPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad, "ali.property.branch.items", itemPredicate.f_151427_(), GenericTooltipUtils::getItemTooltip));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.count", itemPredicate.f_45031_()));
        components.addAll(GenericTooltipUtils.getDataComponentPredicateTooltip(utils, pad, itemPredicate.f_316810_()));
        if (!itemPredicate.f_315090_().isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.item_predicates", new Object[0])));
            itemPredicate.f_315090_().forEach((type, predicate) -> components.addAll(utils.getItemSubPredicateTooltip(utils, pad + 1, (ItemSubPredicate.Type<?>)type, predicate)));
        }
        return components;
    }

    @NotNull
    public static List<Component> getEnchantmentPredicateTooltip(IClientUtils utils, int pad, EnchantmentPredicate enchantmentPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad, "ali.property.branch.enchantments", enchantmentPredicate.f_337714_(), GenericTooltipUtils::getEnchantmentTooltip));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.level", enchantmentPredicate.f_30467_()));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getItemTooltip(IClientUtils utils, int pad, Item item) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.item", GenericTooltipUtils.value(GenericTooltipUtils.translatable(item.m_5524_(), new Object[0])))));
    }

    public static @Unmodifiable @NotNull List<Component> getGameTypeTooltip(IClientUtils utils, int pad, GameTypePredicate gameType) {
        return GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.game_types", gameType.f_337709_(), GenericTooltipUtils::getEnumTooltip);
    }

    @NotNull
    public static List<Component> getStatMatcherTooltip(IClientUtils utils, int pad, PlayerPredicate.StatMatcher<?> stat) {
        LinkedList<Component> components = new LinkedList<Component>();
        Holder value = stat.f_291891_();
        Object object = value.m_203334_();
        if (object instanceof Item) {
            Item item = (Item)object;
            components.addAll(GenericTooltipUtils.getItemTooltip(utils, pad, item));
        } else {
            object = value.m_203334_();
            if (object instanceof Block) {
                Block block = (Block)object;
                components.addAll(GenericTooltipUtils.getBlockTooltip(utils, pad, block));
            } else {
                components.add(GenericTooltipUtils.pad(pad, value.m_203334_().toString()));
            }
        }
        components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.keyValue(stat.f_290937_().m_12905_(), GenericTooltipUtils.toString(stat.f_291204_()))));
        return components;
    }

    @NotNull
    public static List<Component> getRecipesTooltip(IClientUtils ignoredUtils, int pad, Object2BooleanMap<ResourceLocation> recipes) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!recipes.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.recipes", new Object[0])));
            recipes.forEach((recipe, required) -> components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.keyValue(recipe.toString(), required))));
        }
        return components;
    }

    @NotNull
    public static List<Component> getAdvancementsTooltip(IClientUtils ignoredUtils, int pad, Map<ResourceLocation, PlayerPredicate.AdvancementPredicate> predicateMap) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!predicateMap.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.advancements", new Object[0])));
            predicateMap.forEach((advancement, predicate) -> {
                Object2BooleanMap criterions;
                components.add(GenericTooltipUtils.pad(pad + 1, advancement.toString()));
                if (predicate instanceof PlayerPredicate.AdvancementDonePredicate) {
                    boolean state2;
                    PlayerPredicate.AdvancementDonePredicate $b$0 = (PlayerPredicate.AdvancementDonePredicate)predicate;
                    try {
                        boolean patt1$temp;
                        state2 = patt1$temp = $b$0.f_62299_();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    components.add(GenericTooltipUtils.pad(pad + 2, GenericTooltipUtils.translatable("ali.property.value.done", state2)));
                    return;
                }
                if (!(predicate instanceof PlayerPredicate.AdvancementCriterionsPredicate)) return;
                PlayerPredicate.AdvancementCriterionsPredicate $b$2 = (PlayerPredicate.AdvancementCriterionsPredicate)predicate;
                {
                    Object2BooleanMap patt3$temp;
                    criterions = patt3$temp = $b$2.f_62291_();
                }
                criterions.forEach((criterion, state) -> components.add(GenericTooltipUtils.pad(pad + 2, GenericTooltipUtils.keyValue(criterion, state))));
            });
        }
        return components;
    }

    @NotNull
    public static List<Component> getBlockPosTooltip(IClientUtils utils, int pad, BlockPos pos) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.x", pos.m_123341_()));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.y", pos.m_123342_()));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.z", pos.m_123343_()));
        return components;
    }

    @NotNull
    public static List<Component> getMapDecorationTypeTooltip(IClientUtils utils, int pad, MapDecorationType decorationType) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.asset_id", decorationType.f_315068_()));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad, "ali.property.value.color", decorationType.f_315023_()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad, "ali.property.value.show_on_item_frame", decorationType.f_315585_()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad, "ali.property.value.exploration_map_element", decorationType.f_314518_()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad, "ali.property.value.track_count", decorationType.f_314463_()));
        return components;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<Component> getListOperationTooltip(IClientUtils utils, int pad, ListOperation operation) {
        Optional size;
        LinkedList<Component> components = new LinkedList<Component>(GenericTooltipUtils.getEnumTooltip(utils, pad, "ali.property.value.list_operation", operation.m_320900_()));
        if (operation instanceof ListOperation.Insert) {
            ListOperation.Insert insert = (ListOperation.Insert)operation;
            try {
                int n;
                int offset = n = insert.f_315739_();
                components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.offset", offset));
                return components;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!(operation instanceof ListOperation.ReplaceSection)) return components;
        ListOperation.ReplaceSection replaceSection = (ListOperation.ReplaceSection)operation;
        {
            Optional optional;
            int n;
            int offset = n = replaceSection.f_316975_();
            size = optional = replaceSection.f_317088_();
            components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.offset", offset));
        }
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.size", size, GenericTooltipUtils::getIntegerTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getContainerComponentManipulatorTooltip(IClientUtils utils, int pad, ContainerComponentManipulator<?> component) {
        return GenericTooltipUtils.getDataComponentTypeTooltip(utils, pad, component.m_319799_());
    }

    @NotNull
    public static List<Component> getCopyOperationTooltip(IClientUtils utils, int pad, CopyCustomDataFunction.CopyOperation copyOperation) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getNbtPathTooltip(utils, pad, "ali.property.value.source_path", copyOperation.f_316253_()));
        components.addAll(GenericTooltipUtils.getNbtPathTooltip(utils, pad, "ali.property.value.target_path", copyOperation.f_315689_()));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad, "ali.property.value.merge_strategy", copyOperation.f_314952_()));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getNbtPathTooltip(IClientUtils utils, int pad, String key, NbtPathArgument.NbtPath provider) {
        return GenericTooltipUtils.getStringTooltip(utils, pad, key, provider.m_306879_());
    }

    @NotNull
    public static List<Component> getDataComponentPredicateTooltip(IClientUtils utils, int pad, DataComponentPredicate dataComponentPredicate) {
        if (dataComponentPredicate != DataComponentPredicate.f_314891_) {
            return GenericTooltipUtils.getCollectionTooltip(utils, pad, "ali.property.branch.component_predicates", dataComponentPredicate.f_316555_, GenericTooltipUtils::getTypedDataComponentTooltip);
        }
        return List.of();
    }

    public static @Unmodifiable @NotNull List<Component> getTypedDataComponentTooltip(IClientUtils utils, int pad, TypedDataComponent<?> typedDataComponent) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.component", GenericTooltipUtils.keyValue(typedDataComponent.f_316611_().toString(), typedDataComponent.f_314804_()))));
    }

    @NotNull
    public static <A, B extends Predicate<A>> List<Component> getCollectionPredicateTooltip(IClientUtils utils, int pad, String key, CollectionPredicate<A, B> predicate, TriFunction<IClientUtils, Integer, B, List<Component>> subPredicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.contains", predicate.f_315792_(), (u, i, s, c) -> GenericTooltipUtils.getCollectionTooltip(u, (int)i, s, c.m_319415_(), subPredicate)));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.counts", predicate.f_314648_(), (u, i, s, c) -> GenericTooltipUtils.getCollectionTooltip(u, (int)i, s, c.m_319753_(), (u1, i1, s1) -> {
            LinkedList<Component> comps = new LinkedList<Component>();
            comps.addAll((Collection)subPredicate.apply(u1, i1, (Object)s1.f_313895_()));
            comps.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(u1, (int)i1, "ali.property.value.count", s1.f_315065_()));
            return comps;
        })));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.size", predicate.f_316667_(), GenericTooltipUtils::getMinMaxBoundsTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getFireworkPredicateTooltip(IClientUtils utils, int pad, ItemFireworkExplosionPredicate.FireworkPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.shape", predicate.f_315216_(), GenericTooltipUtils::getEnumTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.trail", predicate.f_316972_(), GenericTooltipUtils::getBooleanTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.twinkle", predicate.f_315735_(), GenericTooltipUtils::getBooleanTooltip));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getPagePredicateTooltip(IClientUtils ignoredUtils, int pad, ItemWritableBookPredicate.PagePredicate predicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.page", GenericTooltipUtils.value(predicate.f_316074_()))));
    }

    public static @Unmodifiable @NotNull List<Component> getPagePredicateTooltip(IClientUtils ignoredUtils, int pad, ItemWrittenBookPredicate.PagePredicate predicate) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.value.page", GenericTooltipUtils.value(predicate.f_316602_()))));
    }

    @NotNull
    public static List<Component> getEntryPredicateTooltip(IClientUtils utils, int pad, ItemAttributeModifiersPredicate.EntryPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad, "ali.property.branch.attributes", predicate.f_315176_(), GenericTooltipUtils::getAttributeTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.id", predicate.f_315360_(), GenericTooltipUtils::getResourceLocationTooltip));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad, "ali.property.value.amount", predicate.f_316857_()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.operation", predicate.f_315016_(), GenericTooltipUtils::getEnumTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad, "ali.property.value.slot", predicate.f_314217_(), GenericTooltipUtils::getEnumTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getTrimMaterialTooltip(IClientUtils utils, int pad, TrimMaterial material) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad, "ali.property.value.asset_name", material.f_265854_()));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad, material.f_265970_(), GenericTooltipUtils::getItemTooltip));
        components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad, "ali.property.value.model_index", Float.valueOf(material.f_265933_())));
        components.addAll(GenericTooltipUtils.getComponentTooltip(utils, pad, "ali.property.value.description", material.f_266021_()));
        return components;
    }

    @NotNull
    public static List<Component> getTrimPatternTooltip(IClientUtils utils, int pad, TrimPattern material) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.addAll(GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.asset_id", material.f_266052_()));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad, material.f_265847_(), GenericTooltipUtils::getItemTooltip));
        components.addAll(GenericTooltipUtils.getComponentTooltip(utils, pad, "ali.property.value.description", material.f_265850_()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad, "ali.property.value.decal", material.f_290976_()));
        return components;
    }

    @NotNull
    public static List<Component> getDataComponentPatchTooltip(IClientUtils utils, int pad, DataComponentPatch data) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!data.f_314958_.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.components", new Object[0])));
            data.f_314958_.forEach((type, value) -> components.addAll(GenericTooltipUtils.getDataComponentTypeTooltip(utils, pad + 1, type)));
        }
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getDataComponentTypeTooltip(IClientUtils utils, int pad, DataComponentType<?> data) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, "ali.property.value.type", Objects.requireNonNull(BuiltInRegistries.f_315333_.m_7981_(data)));
    }

    @NotNull
    public static List<Component> getFireworkExplosionTooltip(IClientUtils utils, int pad, FireworkExplosion data) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.explosion", new Object[0])));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.shape", data.f_316547_()));
        components.addAll(GenericTooltipUtils.getIntListTooltip(utils, pad + 1, "ali.property.value.colors", data.f_316201_()));
        components.addAll(GenericTooltipUtils.getIntListTooltip(utils, pad + 1, "ali.property.value.fade_colors", data.f_314743_()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.has_trail", data.f_316522_()));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.has_twinkle", data.f_316285_()));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getIntListTooltip(IClientUtils utils, int pad, String key, IntList data) {
        return GenericTooltipUtils.getStringTooltip(utils, pad, key, data.toString());
    }

    @NotNull
    public static <T> List<Component> getFilterableTooltip(IClientUtils utils, int pad, String key, Filterable<T> data, QuadFunction<IClientUtils, Integer, String, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        components.addAll((Collection)mapper.apply(utils, pad + 1, "ali.property.value.raw", data.f_315590_()));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.filtered", data.f_316433_(), mapper));
        return components;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<Component> getLevelBasedValueTooltip(IClientUtils utils, int pad, String key, LevelBasedValue levelBasedValue) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        LevelBasedValue levelBasedValue2 = levelBasedValue;
        Objects.requireNonNull(levelBasedValue2);
        LevelBasedValue levelBasedValue3 = levelBasedValue2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LevelBasedValue.Constant.class, LevelBasedValue.Clamped.class, LevelBasedValue.Fraction.class, LevelBasedValue.Linear.class, LevelBasedValue.LevelsSquared.class, LevelBasedValue.Lookup.class}, (Object)levelBasedValue3, n)) {
            case 0: {
                LevelBasedValue.Constant constant = (LevelBasedValue.Constant)levelBasedValue3;
                try {
                    float f;
                    float value = f = constant.f_336981_();
                    components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 1, "ali.property.value.constant", Float.valueOf(value)));
                    return components;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                float max;
                float min;
                LevelBasedValue value;
                LevelBasedValue.Clamped clamped = (LevelBasedValue.Clamped)levelBasedValue3;
                {
                    float f;
                    LevelBasedValue levelBasedValue4;
                    value = levelBasedValue4 = clamped.f_336702_();
                    min = f = clamped.f_336751_();
                    max = f = clamped.f_337031_();
                    components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.clamped", new Object[0])));
                }
                components.addAll(GenericTooltipUtils.getLevelBasedValueTooltip(utils, pad + 2, "ali.property.branch.value", value));
                components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 2, "ali.property.value.min", Float.valueOf(min)));
                components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 2, "ali.property.value.max", Float.valueOf(max)));
                return components;
            }
            case 2: {
                LevelBasedValue denominator;
                LevelBasedValue numerator;
                LevelBasedValue.Fraction fraction = (LevelBasedValue.Fraction)levelBasedValue3;
                {
                    LevelBasedValue levelBasedValue5;
                    numerator = levelBasedValue5 = fraction.f_337089_();
                    denominator = levelBasedValue5 = fraction.f_337310_();
                    components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.fraction", new Object[0])));
                }
                components.addAll(GenericTooltipUtils.getLevelBasedValueTooltip(utils, pad + 2, "ali.property.branch.numerator", numerator));
                components.addAll(GenericTooltipUtils.getLevelBasedValueTooltip(utils, pad + 2, "ali.property.branch.denominator", denominator));
                return components;
            }
            case 3: {
                float perLevelAboveFirst;
                float base;
                LevelBasedValue.Linear linear = (LevelBasedValue.Linear)levelBasedValue3;
                {
                    float f;
                    base = f = linear.f_337076_();
                    perLevelAboveFirst = f = linear.f_336969_();
                    components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.linear", new Object[0])));
                }
                components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 2, "ali.property.value.base", Float.valueOf(base)));
                components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 2, "ali.property.value.per_level", Float.valueOf(perLevelAboveFirst)));
                return components;
            }
            case 4: {
                float added;
                LevelBasedValue.LevelsSquared levelsSquared = (LevelBasedValue.LevelsSquared)levelBasedValue3;
                {
                    float f;
                    added = f = levelsSquared.f_337001_();
                    components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.level_squared", new Object[0])));
                }
                components.addAll(GenericTooltipUtils.getFloatTooltip(utils, pad + 2, "ali.property.value.added", Float.valueOf(added)));
                return components;
            }
            case 5: {
                List fallback;
                List values;
                LevelBasedValue.Lookup lookup = (LevelBasedValue.Lookup)levelBasedValue3;
                {
                    List list;
                    values = list = lookup.f_337520_();
                    fallback = list = lookup.f_337128_();
                    components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.lookup", new Object[0])));
                }
                components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad + 2, "ali.property.value.values", values.toString()));
                components.addAll(GenericTooltipUtils.getLevelBasedValueTooltip(utils, pad + 2, "ali.property.branch.fallback", (LevelBasedValue)fallback));
                return components;
            }
        }
        return components;
    }

    @NotNull
    public static List<Component> getLocationWrapperTooltip(IClientUtils utils, int pad, String key, EntityPredicate.LocationWrapper locationWrapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (locationWrapper.f_337136_().isPresent() || locationWrapper.f_337291_().isPresent() || locationWrapper.f_337432_().isPresent()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.located", locationWrapper.f_337136_(), GenericTooltipUtils::getLocationPredicateTooltip));
            components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.stepping_on_location", locationWrapper.f_337432_(), GenericTooltipUtils::getLocationPredicateTooltip));
            components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.branch.affects_movement", locationWrapper.f_337291_(), GenericTooltipUtils::getLocationPredicateTooltip));
        }
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getJukeboxSongTooltip(IClientUtils utils, int pad, JukeboxSong song) {
        Optional<Holder.Reference> first;
        Optional lookup;
        HolderLookup.Provider provider = utils.lookupProvider();
        if (provider != null && (lookup = provider.m_254861_(Registries.f_337466_)).isPresent() && (first = ((HolderLookup.RegistryLookup)lookup.get()).m_214062_().filter(l -> l.m_203334_() == song).findFirst()).isPresent()) {
            return GenericTooltipUtils.getResourceKeyTooltip(utils, pad, "ali.property.value.song", Objects.requireNonNull(first.get().m_205785_()));
        }
        return List.of();
    }

    @NotNull
    public static List<Component> getMovementPredicateTooltip(IClientUtils utils, int pad, MovementPredicate predicate) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.property.branch.movement", new Object[0])));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.x", predicate.f_337025_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.y", predicate.f_337404_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.z", predicate.f_337000_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.speed", predicate.f_336675_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.horizontal_speed", predicate.f_337632_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.vertical_speed", predicate.f_336606_()));
        components.addAll(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, pad + 1, "ali.property.value.fall_distance", predicate.f_336746_()));
        return components;
    }

    @NotNull
    public static Component translatable(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])Arrays.stream(args).map(GenericTooltipUtils::convertObject).toArray()).m_130940_(TEXT_STYLE);
    }

    @NotNull
    public static Component value(Object value) {
        return GenericTooltipUtils.convertObject(value).m_130944_(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component value(Object value, String unit) {
        return Component.m_237110_((String)"ali.util.advanced_loot_info.two_values", (Object[])new Object[]{GenericTooltipUtils.convertObject(value), unit}).m_130944_(new ChatFormatting[]{PARAM_STYLE, ChatFormatting.BOLD});
    }

    @NotNull
    public static Component pair(Object value1, Object value2) {
        return Component.m_237110_((String)"ali.util.advanced_loot_info.two_values_with_space", (Object[])new Object[]{GenericTooltipUtils.convertObject(value1), GenericTooltipUtils.convertObject(value2)});
    }

    @NotNull
    public static Component pad(int count, Object arg) {
        if (count > 0) {
            return GenericTooltipUtils.pair(Component.m_237115_((String)("ali.util.advanced_loot_info.pad." + count)), GenericTooltipUtils.convertObject(arg));
        }
        return GenericTooltipUtils.convertObject(arg);
    }

    @NotNull
    public static Component keyValue(Object key, Object value) {
        return GenericTooltipUtils.translatable("ali.util.advanced_loot_info.key_value", GenericTooltipUtils.convertObject(key), GenericTooltipUtils.value(value));
    }

    public static @Unmodifiable @NotNull List<Component> getNumberProviderTooltip(IClientUtils utils, int pad, String key, NumberProvider value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(utils.convertNumber(utils, value)))));
    }

    @NotNull
    public static List<Component> getIntRangeTooltip(IClientUtils utils, int pad, String key, IntRange range) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(RangeValue.rangeToString(utils.convertNumber(utils, range.f_165001_), utils.convertNumber(utils, range.f_165002_))))));
    }

    public static @Unmodifiable @NotNull List<Component> getBooleanTooltip(IClientUtils utils, int pad, String key, Boolean value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getIntegerTooltip(IClientUtils utils, int pad, String key, Integer value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getLongTooltip(IClientUtils ignoredUtils, int pad, String key, Long value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getStringTooltip(IClientUtils utils, int pad, String key, String value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getFloatTooltip(IClientUtils ignoredUtils, int pad, String key, Float value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnumTooltip(IClientUtils ignoredUtils, int pad, String key, Enum<?> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.name()))));
    }

    public static @Unmodifiable @NotNull List<Component> getEnumTooltip(IClientUtils utils, int pad, Enum<?> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.value(value.name())));
    }

    public static @Unmodifiable @NotNull List<Component> getResourceLocationTooltip(IClientUtils ignoredUtils, int pad, String key, ResourceLocation value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value))));
    }

    public static <T> @Unmodifiable @NotNull List<Component> getResourceKeyTooltip(IClientUtils utils, int pad, String key, ResourceKey<T> value) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.m_135782_()))));
    }

    public static <T> @Unmodifiable @NotNull List<Component> getTagKeyTooltip(IClientUtils utils, int pad, String key, TagKey<T> value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, pad, key, value.f_203868_());
    }

    public static @Unmodifiable @NotNull List<Component> getComponentTooltip(IClientUtils ignoredUtils, int pad, String key, Component component) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(component))));
    }

    @NotNull
    public static <T> List<Component> getComponentsTooltip(IClientUtils utils, int pad, String key, T value, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        List componentList = (List)mapper.apply((Object)utils, (Object)(pad + 1), value);
        if (!componentList.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            components.addAll(componentList);
        }
        return components;
    }

    @NotNull
    public static <T> List<Component> getComponentsTooltip(IClientUtils utils, int pad, String key, Optional<T> value, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        List<Component> componentList = GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, value, mapper);
        if (!componentList.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            components.addAll(componentList);
        }
        return components;
    }

    @NotNull
    public static List<Component> getMinMaxBoundsTooltip(IClientUtils utils, int pad, String key, MinMaxBounds.Ints ints) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (ints != MinMaxBounds.Ints.f_55364_) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(ints)))));
        }
        return components;
    }

    @NotNull
    public static List<Component> getMinMaxBoundsTooltip(IClientUtils ignoredUtils, int pad, String key, MinMaxBounds.Doubles doubles) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (doubles != MinMaxBounds.Doubles.f_154779_) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(doubles)))));
        }
        return components;
    }

    @NotNull
    public static <T> List<Component> getOptionalTooltip(IClientUtils utils, int pad, Optional<T> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(value -> (List)mapper.apply((Object)utils, (Object)pad, value)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalTooltip(IClientUtils utils, int pad, String key, Optional<T> optional, QuadFunction<IClientUtils, Integer, String, T, List<Component>> mapper) {
        return optional.map(value -> (List)mapper.apply(utils, pad, key, value)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalHolderTooltip(IClientUtils utils, int pad, Optional<Holder<T>> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(holder -> GenericTooltipUtils.getHolderTooltip(utils, pad, holder, mapper)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getOptionalHolderSetTooltip(IClientUtils utils, int pad, String key, Optional<HolderSet<T>> optional, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return optional.map(holderSet -> GenericTooltipUtils.getHolderSetTooltip(utils, pad, key, holderSet, mapper)).orElse(List.of());
    }

    @NotNull
    public static <T> List<Component> getHolderTooltip(IClientUtils utils, int pad, Holder<T> holder, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        return (List)mapper.apply((Object)utils, (Object)pad, holder.m_203334_());
    }

    @NotNull
    public static <T> List<Component> getHolderSetTooltip(IClientUtils utils, int pad, String key, HolderSet<T> holderSet, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        Either either = holderSet.m_203440_();
        Optional left = either.left();
        Optional right = either.right();
        if (left.isPresent() || !right.orElse(List.of()).isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        }
        left.ifPresent(tagKey -> components.addAll(GenericTooltipUtils.getTagKeyTooltip(utils, pad + 1, "ali.property.value.tag", tagKey)));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                holderSet.forEach(holder -> components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, holder, mapper)));
            }
        });
        return components;
    }

    @NotNull
    public static <T> List<Component> getHolderSetTooltip(IClientUtils utils, int pad, String key, HolderSet<T> holderSet, String value) {
        LinkedList<Component> components = new LinkedList<Component>();
        Either either = holderSet.m_203440_();
        Optional left = either.left();
        Optional right = either.right();
        if (left.isPresent() || !right.orElse(List.of()).isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
        }
        left.ifPresent(tagKey -> components.addAll(GenericTooltipUtils.getTagKeyTooltip(utils, pad + 1, "ali.property.value.tag", tagKey)));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                holderSet.forEach(holder -> components.addAll(GenericTooltipUtils.getResourceKeyTooltip(utils, pad + 1, value, (ResourceKey)holder.m_203543_().orElseThrow())));
            }
        });
        return components;
    }

    @NotNull
    public static <T> List<Component> getCollectionTooltip(IClientUtils utils, int pad, String key, Collection<T> values, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        if (!values.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
            values.forEach(value -> components.addAll((Collection)mapper.apply((Object)utils, (Object)(pad + 1), value)));
        }
        return components;
    }

    @NotNull
    public static <T, P extends Collection<T>> List<Component> getCollectionTooltip(IClientUtils utils, int pad, String key, Optional<P> values, TriFunction<IClientUtils, Integer, T, List<Component>> mapper) {
        LinkedList<Component> components = new LinkedList<Component>();
        values.ifPresent(v -> {
            if (!v.isEmpty()) {
                components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable(key, new Object[0])));
                v.forEach(value -> components.addAll((Collection)mapper.apply((Object)utils, (Object)(pad + 1), value)));
            }
        });
        return components;
    }

    @NotNull
    private static String toString(MinMaxBounds.Doubles doubles) {
        Optional min = doubles.m_293284_();
        Optional max = doubles.m_294019_();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    private static String toString(MinMaxBounds.Ints ints) {
        Optional min = ints.m_293284_();
        Optional max = ints.m_294019_();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static MutableComponent convertObject(@Nullable Object object) {
        if (object instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)object;
            return component;
        }
        if (object != null) {
            return Component.m_237113_((String)object.toString());
        }
        return Component.m_237113_((String)"null");
    }

    @FunctionalInterface
    public static interface QuadFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

