/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client.widget;

import com.mojang.datafixers.util.Pair;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IEntryWidget;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.client.WidgetUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class LootPoolWidget
implements IWidget {
    private final List<IWidget> widgets;
    private final Rect bounds;
    private final IClientUtils utils;

    public LootPoolWidget(IWidgetUtils utils, LootPool entry, int x, int y, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        LinkedList<LootItemFunction> allFunctions = new LinkedList<LootItemFunction>(functions);
        LinkedList<LootItemCondition> allConditions = new LinkedList<LootItemCondition>(conditions);
        allFunctions.addAll(entry.f_79026_);
        allConditions.addAll(entry.f_79024_);
        Pair<List<IEntryWidget>, Rect> info = utils.createWidgets(utils, entry.f_79023_, x, y, List.copyOf(allFunctions), List.copyOf(allConditions));
        this.widgets = new LinkedList<IWidget>((Collection)info.getFirst());
        this.widgets.add(WidgetUtils.getLootPoolTypeWidget(x, y, utils.convertNumber(utils, entry.f_79028_), utils.convertNumber(utils, entry.f_79029_)));
        this.bounds = (Rect)info.getSecond();
        this.utils = utils;
    }

    @Override
    public Rect getRect() {
        return this.bounds;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int lastY = 0;
        WidgetDirection lastDirection = null;
        for (IWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY);
            if (!(widget instanceof IEntryWidget)) continue;
            IEntryWidget entryWidget = (IEntryWidget)widget;
            WidgetDirection direction = this.utils.getWidgetDirection(entryWidget.getLootEntry());
            if (direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) {
                lastY = Math.max(lastY, widget.getRect().y());
            }
            lastDirection = direction;
        }
        int top = this.bounds.y() + 18;
        int height = lastY - this.bounds.y() - 9;
        WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 3, top, 2, height, 0, 0, 2, 18);
        lastDirection = null;
        for (IWidget widget : this.widgets) {
            if (!(widget instanceof IEntryWidget)) continue;
            IEntryWidget entryWidget = (IEntryWidget)widget;
            WidgetDirection direction = this.utils.getWidgetDirection(entryWidget.getLootEntry());
            if ((direction == WidgetDirection.VERTICAL || lastDirection != null && direction != lastDirection) && widget.getRect().y() > this.bounds.y() + 18) {
                WidgetUtils.blitRepeating(guiGraphics, WidgetUtils.TEXTURE_LOC, this.bounds.x() + 4, widget.getRect().y() + 8, 3, 2, 2, 0, 18, 2);
            }
            lastDirection = direction;
        }
    }

    @Override
    public List<Component> getTooltipComponents(int mouseX, int mouseY) {
        LinkedList<Component> components = new LinkedList<Component>();
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            components.addAll(widget.getTooltipComponents(mouseX, mouseY));
        }
        return components;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = false;
        for (IWidget widget : this.widgets) {
            Rect b = widget.getRect();
            if (!b.contains(mouseX, mouseY)) continue;
            clicked |= widget.mouseClicked(mouseX, mouseY, button);
        }
        return clicked;
    }

    @NotNull
    public static Rect getBounds(IClientUtils registry, LootPool entry, int x, int y) {
        return registry.getBounds(registry, entry.f_79023_, x, y);
    }
}

