/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IEntryWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.WidgetDirection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_5657;
import net.minecraft.class_5658;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_79;
import net.minecraft.class_85;
import net.minecraft.class_8567;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AliClientRegistry
implements IClientRegistry,
IClientUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_47 LOOT_CONTEXT = new class_47(new class_8567(null, Map.of(), Map.of(), 0.0f), class_5819.method_43047(), null);
    private final Map<class_5338, IClientRegistry.IWidgetFactory> widgetMap = new HashMap<class_5338, IClientRegistry.IWidgetFactory>();
    private final Map<class_5657, BiFunction<IClientUtils, class_5658, RangeValue>> numberConverterMap = new HashMap<class_5657, BiFunction<IClientUtils, class_5658, RangeValue>>();
    private final Map<class_5342, TriFunction<IClientUtils, Integer, class_5341, List<class_2561>>> conditionTooltipMap = new HashMap<class_5342, TriFunction<IClientUtils, Integer, class_5341, List<class_2561>>>();
    private final Map<class_5339, TriFunction<IClientUtils, Integer, class_117, List<class_2561>>> functionTooltipMap = new HashMap<class_5339, TriFunction<IClientUtils, Integer, class_117, List<class_2561>>>();
    private final Map<class_5342, TriConsumer<IClientUtils, class_5341, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>> chanceModifierMap = new HashMap<class_5342, TriConsumer<IClientUtils, class_5341, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>>();
    private final Map<class_5339, TriConsumer<IClientUtils, class_117, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>> countModifierMap = new HashMap<class_5339, TriConsumer<IClientUtils, class_117, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>>();
    private final Map<class_5339, TriFunction<IClientUtils, class_117, class_1799, class_1799>> itemStackModifierMap = new HashMap<class_5339, TriFunction<IClientUtils, class_117, class_1799, class_1799>>();
    private final Map<class_5338, WidgetDirection> widgetDirectionMap = new HashMap<class_5338, WidgetDirection>();
    private final Map<class_5338, IClientRegistry.IBoundsGetter> widgetBoundsMap = new HashMap<class_5338, IClientRegistry.IBoundsGetter>();
    private final Map<class_2960, class_52> lootTableMap = new HashMap<class_2960, class_52>();
    private final Map<class_2960, List<class_1792>> lootItemMap = new HashMap<class_2960, List<class_1792>>();

    public void addLootTable(class_2960 resourceLocation, class_52 lootTable, List<class_1792> items) {
        this.lootTableMap.put(resourceLocation, lootTable);
        this.lootItemMap.put(resourceLocation, items);
    }

    public Map<class_2960, class_52> getLootTables() {
        return this.lootTableMap;
    }

    public void clearLootTables() {
        this.lootTableMap.clear();
    }

    @Override
    public void registerWidget(class_5338 type, WidgetDirection direction, IClientRegistry.IWidgetFactory factory, IClientRegistry.IBoundsGetter boundsGetter) {
        this.widgetMap.put(type, factory);
        this.widgetDirectionMap.put(type, direction);
        this.widgetBoundsMap.put(type, boundsGetter);
    }

    @Override
    public <T extends class_5658> void registerNumberProvider(class_5657 type, BiFunction<IClientUtils, T, RangeValue> converter) {
        this.numberConverterMap.put(type, (u, t) -> (RangeValue)converter.apply((IClientUtils)u, (Object)t));
    }

    @Override
    public <T extends class_5341> void registerConditionTooltip(class_5342 type, TriFunction<IClientUtils, Integer, T, List<class_2561>> getter) {
        this.conditionTooltipMap.put(type, (TriFunction<IClientUtils, Integer, class_5341, List<class_2561>>)((TriFunction)(u, i, c) -> (List)getter.apply(u, i, c)));
    }

    @Override
    public <T extends class_117> void registerFunctionTooltip(class_5339 type, TriFunction<IClientUtils, Integer, T, List<class_2561>> getter) {
        this.functionTooltipMap.put(type, (TriFunction<IClientUtils, Integer, class_117, List<class_2561>>)((TriFunction)(u, i, f) -> (List)getter.apply(u, i, f)));
    }

    @Override
    public <T extends class_117> void registerCountModifier(class_5339 type, TriConsumer<IClientUtils, T, Map<class_6880<class_1887>, Map<Integer, RangeValue>>> consumer) {
        this.countModifierMap.put(type, (TriConsumer<IClientUtils, class_117, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>)((TriConsumer)(u, f, v) -> consumer.accept(u, f, v)));
    }

    @Override
    public <T extends class_5341> void registerChanceModifier(class_5342 type, TriConsumer<IClientUtils, T, Map<class_6880<class_1887>, Map<Integer, RangeValue>>> consumer) {
        this.chanceModifierMap.put(type, (TriConsumer<IClientUtils, class_5341, Map<class_6880<class_1887>, Map<Integer, RangeValue>>>)((TriConsumer)(u, f, v) -> consumer.accept(u, f, v)));
    }

    @Override
    public <T extends class_117> void registerItemStackModifier(class_5339 type, TriFunction<IClientUtils, T, class_1799, class_1799> consumer) {
        this.itemStackModifierMap.put(type, (TriFunction<IClientUtils, class_117, class_1799, class_1799>)((TriFunction)(u, f, i) -> (class_1799)consumer.apply(u, f, i)));
    }

    @Override
    public Pair<List<IEntryWidget>, Rect> createWidgets(IWidgetUtils utils, List<class_79> entries, int x, int y, List<class_117> functions, List<class_5341> conditions) {
        int posX = x + 7;
        int posY = y;
        int width = 0;
        int height = 0;
        int sumWeight = 0;
        LinkedList<IEntryWidget> widgets = new LinkedList<IEntryWidget>();
        WidgetDirection lastDirection = null;
        for (class_79 entry : entries) {
            if (!(entry instanceof class_85)) continue;
            class_85 singletonEntry = (class_85)entry;
            sumWeight += singletonEntry.field_995;
        }
        for (class_79 entry : entries) {
            Rect bound;
            WidgetDirection direction = this.widgetDirectionMap.get(entry.method_29318());
            IClientRegistry.IWidgetFactory widgetFactory = this.widgetMap.get(entry.method_29318());
            IClientRegistry.IBoundsGetter bounds = this.widgetBoundsMap.get(entry.method_29318());
            if (direction == null || widgetFactory == null || bounds == null) continue;
            if (lastDirection != null && direction != lastDirection && direction == WidgetDirection.VERTICAL) {
                posX = x + 7;
                posY = y + height + 2;
            }
            if ((bound = bounds.apply(utils, entry, posX, posY)).right() > 162) {
                posX = x + 7;
                posY += bound.height();
                bound = bounds.apply(utils, entry, posX, posY);
            }
            IEntryWidget widget = widgetFactory.create(utils, entry, posX, posY, sumWeight, List.copyOf(functions), List.copyOf(conditions));
            width = Math.max(width, bound.right() - x);
            height = Math.max(height, bound.bottom() - y);
            if (lastDirection != null) {
                if (lastDirection != direction) {
                    posX = x + 7;
                    posY += bound.height() + 2;
                } else if (direction == WidgetDirection.HORIZONTAL) {
                    posX += bound.width();
                } else if (direction == WidgetDirection.VERTICAL) {
                    posY += bound.height() + 2;
                }
            } else {
                switch (direction) {
                    case HORIZONTAL: {
                        posX += bound.width();
                        break;
                    }
                    case VERTICAL: {
                        posY += bound.height() + 2;
                    }
                }
            }
            widgets.add(widget);
            lastDirection = direction;
        }
        return new Pair(widgets, (Object)new Rect(x, y, width, height));
    }

    @Override
    public <T extends class_5341> List<class_2561> getConditionTooltip(IClientUtils utils, int pad, T condition) {
        TriFunction<IClientUtils, Integer, class_5341, List<class_2561>> entryTooltipGetter = this.conditionTooltipMap.get(condition.method_29325());
        if (entryTooltipGetter != null) {
            return (List)entryTooltipGetter.apply((Object)utils, (Object)pad, condition);
        }
        LOGGER.warn("Condition tooltip for {} was not registered", (Object)condition.getClass().getCanonicalName());
        return List.of();
    }

    @Override
    public <T extends class_117> List<class_2561> getFunctionTooltip(IClientUtils utils, int pad, T function) {
        TriFunction<IClientUtils, Integer, class_117, List<class_2561>> entryTooltipGetter = this.functionTooltipMap.get(function.method_29321());
        if (entryTooltipGetter != null) {
            return (List)entryTooltipGetter.apply((Object)utils, (Object)pad, function);
        }
        LOGGER.warn("Function tooltip for {} was not registered", (Object)function.getClass().getCanonicalName());
        return List.of();
    }

    @Override
    public <T extends class_117> void applyCountModifier(IClientUtils utils, T function, Map<class_6880<class_1887>, Map<Integer, RangeValue>> count) {
        TriConsumer<IClientUtils, class_117, Map<class_6880<class_1887>, Map<Integer, RangeValue>>> bonusCountConsumer = this.countModifierMap.get(function.method_29321());
        if (bonusCountConsumer != null) {
            bonusCountConsumer.accept((Object)utils, function, count);
        }
    }

    @Override
    public <T extends class_5341> void applyChanceModifier(IClientUtils utils, T condition, Map<class_6880<class_1887>, Map<Integer, RangeValue>> chance) {
        TriConsumer<IClientUtils, class_5341, Map<class_6880<class_1887>, Map<Integer, RangeValue>>> bonusChanceConsumer = this.chanceModifierMap.get(condition.method_29325());
        if (bonusChanceConsumer != null) {
            bonusChanceConsumer.accept((Object)utils, condition, chance);
        }
    }

    @Override
    public <T extends class_117> class_1799 applyItemStackModifier(IClientUtils utils, T function, class_1799 itemStack) {
        TriFunction<IClientUtils, class_117, class_1799, class_1799> bonusChanceConsumer = this.itemStackModifierMap.get(function.method_29321());
        if (bonusChanceConsumer != null) {
            itemStack = (class_1799)bonusChanceConsumer.apply((Object)utils, function, (Object)itemStack);
        }
        return itemStack;
    }

    @Override
    public Rect getBounds(IClientUtils utils, List<class_79> entries, int x, int y) {
        int posX = x + 7;
        int posY = y;
        int width = 0;
        int height = 0;
        WidgetDirection lastDirection = null;
        for (class_79 entry : entries) {
            Rect bound;
            WidgetDirection direction = this.widgetDirectionMap.get(entry.method_29318());
            IClientRegistry.IWidgetFactory widgetFactory = this.widgetMap.get(entry.method_29318());
            IClientRegistry.IBoundsGetter bounds = this.widgetBoundsMap.get(entry.method_29318());
            if (direction == null || widgetFactory == null || bounds == null) continue;
            if (lastDirection != null && direction != lastDirection && direction == WidgetDirection.VERTICAL) {
                posX = x + 7;
                posY = y + height + 2;
            }
            if ((bound = bounds.apply(utils, entry, posX, posY)).right() > 162) {
                posX = x + 7;
                posY += bound.height();
                bound = bounds.apply(utils, entry, posX, posY);
            }
            width = Math.max(width, bound.right() - x);
            height = Math.max(height, bound.bottom() - y);
            if (lastDirection != null) {
                if (lastDirection != direction) {
                    posX = x + 7;
                    posY += bound.height() + 2;
                } else if (direction == WidgetDirection.HORIZONTAL) {
                    posX += bound.width();
                } else if (direction == WidgetDirection.VERTICAL) {
                    posY += bound.height() + 2;
                }
            } else {
                switch (direction) {
                    case HORIZONTAL: {
                        posX += bound.width();
                        break;
                    }
                    case VERTICAL: {
                        posY += bound.height() + 2;
                    }
                }
            }
            lastDirection = direction;
        }
        return new Rect(x, y, width, height);
    }

    @Override
    @Nullable
    public WidgetDirection getWidgetDirection(class_79 entry) {
        return this.widgetDirectionMap.get(entry.method_29318());
    }

    @Override
    public class_47 getLootContext() {
        return LOOT_CONTEXT;
    }

    @Override
    public List<class_1792> getItems(class_2960 location) {
        return this.lootItemMap.getOrDefault(location, List.of());
    }

    @Override
    @Nullable
    public class_52 getLootTable(class_2960 resourceLocation) {
        return this.lootTableMap.get(resourceLocation);
    }

    @Override
    public RangeValue convertNumber(IClientUtils utils, @Nullable class_5658 numberProvider) {
        if (numberProvider != null) {
            BiFunction<IClientUtils, class_5658, RangeValue> function = this.numberConverterMap.get(numberProvider.method_365());
            if (function != null) {
                try {
                    return function.apply(utils, numberProvider);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Failed to convert number with error {}", (Object)throwable.getMessage());
                }
            } else {
                LOGGER.warn("Number converter for {} was not registered", (Object)numberProvider.getClass().getCanonicalName());
            }
        }
        return new RangeValue(false, true);
    }

    public void printClientInfo() {
        LOGGER.info("Registered {} widgets", (Object)this.widgetMap.size());
        LOGGER.info("Registered {} number converters", (Object)this.numberConverterMap.size());
        LOGGER.info("Registered {} condition tooltips", (Object)this.conditionTooltipMap.size());
        LOGGER.info("Registered {} function tooltips", (Object)this.functionTooltipMap.size());
    }
}

