/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.InfoSyncLootTableMessage;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_60;
import net.minecraft.class_8490;
import org.slf4j.Logger;

public abstract class AbstractServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<InfoSyncLootTableMessage> messages = new LinkedList<InfoSyncLootTableMessage>();

    public final void readLootTables(class_60 manager, class_3218 level) {
        this.messages.clear();
        PluginManager.SERVER_REGISTRY.setServerLevel(level);
        manager.method_51193(class_8490.field_44498).forEach(table -> PluginManager.SERVER_REGISTRY.addLootTable((class_2960)table, manager.getLootTable(table)));
        manager.method_51193(class_8490.field_44498).forEach(location -> {
            class_52 table = manager.getLootTable(location);
            if (table != class_52.field_948) {
                List<class_1792> items = ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, table);
                if (!items.isEmpty()) {
                    this.messages.add(new InfoSyncLootTableMessage((class_2960)location, table, items));
                } else {
                    LOGGER.info("LootTable {} has no items", location);
                }
            } else {
                LOGGER.warn("Ignoring {} LootTable, because it's empty or null", location);
            }
        });
        LOGGER.info("Prepared {} loot tables", (Object)this.messages.size());
    }

    public final void syncLootTables(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.sendClearMessage(serverPlayer, new ClearMessage());
            for (InfoSyncLootTableMessage message : this.messages) {
                this.sendSyncMessage(serverPlayer, message);
            }
        }
    }

    protected abstract void sendClearMessage(class_3222 var1, ClearMessage var2);

    protected abstract void sendSyncMessage(class_3222 var1, InfoSyncLootTableMessage var2);
}

