/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.ICommonRegistry;
import com.yanny.ali.api.ICommonUtils;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.configuration.ConfigUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_3730;
import org.slf4j.Logger;

public class AliCommonRegistry
implements ICommonRegistry,
ICommonUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<class_1299<?>, Function<class_1937, List<class_1297>>> entityVariantsMap = new HashMap();
    private AliConfig configuration;

    @Override
    public <T extends class_1297> void registerEntityVariants(class_1299<T> type, Function<class_1937, List<class_1297>> factory) {
        this.entityVariantsMap.put(type, factory);
    }

    @Override
    public List<class_1297> createEntities(class_1299<?> type, class_1937 level) {
        Function<class_1937, List<class_1297>> factory = this.entityVariantsMap.get(type);
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        if (factory == null) {
            factory = l -> {
                class_1297 entity = type.method_5883(l, class_3730.field_52444);
                if (entity != null) {
                    return Collections.singletonList(entity);
                }
                LOGGER.warn("Failed to create entity: {} (NULL)", (Object)type);
                return Collections.emptyList();
            };
        }
        try {
            entities.addAll((Collection)factory.apply(level));
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to create entity: {}", (Object)e.getMessage());
        }
        return entities;
    }

    public void loadConfiguration() {
        this.configuration = ConfigUtils.readConfiguration();
    }

    public AliConfig getConfiguration() {
        return this.configuration;
    }

    public void printRegistrationInfo() {
        LOGGER.info("Registered {} entity variants", (Object)this.entityVariantsMap.size());
    }
}

