/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.IChanceModifier;
import com.yanny.ali.plugin.mods.IConditionTooltip;
import com.yanny.ali.plugin.mods.IConsumeEffectTooltip;
import com.yanny.ali.plugin.mods.ICountModifier;
import com.yanny.ali.plugin.mods.IDataComponentPredicateTooltip;
import com.yanny.ali.plugin.mods.IDataComponentTypeTooltip;
import com.yanny.ali.plugin.mods.IEntitySubPredicateTooltip;
import com.yanny.ali.plugin.mods.IEntry;
import com.yanny.ali.plugin.mods.IEntryItemCollector;
import com.yanny.ali.plugin.mods.IFunctionItemCollector;
import com.yanny.ali.plugin.mods.IFunctionTooltip;
import com.yanny.ali.plugin.mods.IIngredientTooltip;
import com.yanny.ali.plugin.mods.IItemListing;
import com.yanny.ali.plugin.mods.IItemStackModifier;
import com.yanny.ali.plugin.mods.INumberProvider;
import com.yanny.ali.plugin.mods.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PluginUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends BaseAccessor<?>> void registerEntryItemCollector(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> itemCollectorClass = Class.forName(classAnnotation.value());
                registry.registerItemCollector(itemCollectorClass, (u, c) -> ((IEntryItemCollector)ReflectionUtils.copyClassData(clazz, c)).collectItems((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register entry item collector for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for entry item collector " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerFunctionItemCollector(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> itemCollectorClass = Class.forName(classAnnotation.value());
                registry.registerItemCollector(itemCollectorClass, (u, i, c) -> ((IFunctionItemCollector)ReflectionUtils.copyClassData(clazz, c)).collectItems((IServerUtils)u, (List<class_1792>)i));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register function item collector for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for function item collector " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerEntry(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> entryClass = Class.forName(classAnnotation.value());
                registry.registerEntry(entryClass, (u, e, r, w, f, c) -> ((IEntry)ReflectionUtils.copyClassData(clazz, e)).create(u, r, w, f, c));
            }
            catch (Throwable e2) {
                LOGGER.warn("Failed to register entry for {} with error {}", (Object)classAnnotation.value(), (Object)e2.getMessage());
                e2.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for entry " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerFunctionTooltip(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> functionClass = Class.forName(classAnnotation.value());
                registry.registerFunctionTooltip(functionClass, (u, c) -> ((IFunctionTooltip)ReflectionUtils.copyClassData(clazz, c)).getTooltip((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register function tooltip for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for function tooltip " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerConditionTooltip(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> conditionClass = Class.forName(classAnnotation.value());
                registry.registerConditionTooltip(conditionClass, (u, c) -> ((IConditionTooltip)ReflectionUtils.copyClassData(clazz, c)).getTooltip((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register condition tooltip for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for condition tooltip " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerIngredientTooltip(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> ingredientClass = Class.forName(classAnnotation.value());
                registry.registerIngredientTooltip(ingredientClass, (u, c) -> ((IIngredientTooltip)ReflectionUtils.copyClassData(clazz, c)).getTooltip((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register ingredient tooltip for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for ingredient tooltip " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerDataComponentPredicateTooltip(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> predicateClass = Class.forName(classAnnotation.value());
                registry.registerDataComponentPredicateTooltip(predicateClass, (u, c) -> ((IDataComponentPredicateTooltip)ReflectionUtils.copyClassData(clazz, c)).getTooltip((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register data component predicate tooltip for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for data component predicate tooltip " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerEntitySubPredicateTooltip(IServerRegistry registry, Class<T> clazz, MapCodec<T> codec) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                registry.registerEntitySubPredicateTooltip(codec, (u, c) -> ((IEntitySubPredicateTooltip)ReflectionUtils.copyClassData(clazz, c)).getTooltip((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register entity sub predicate tooltip for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for entity sub predicate " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerDataComponentTypeTooltip(IServerRegistry registry, Class<T> clazz, class_9331<T> type) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                registry.registerDataComponentTypeTooltip(type, (u, c) -> ((IDataComponentTypeTooltip)ReflectionUtils.copyClassData(clazz, c)).getTooltip((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register data component type tooltip for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for data component type tooltip " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerConsumeEffectTooltip(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> ingredientClass = Class.forName(classAnnotation.value());
                registry.registerConsumeEffectTooltip(ingredientClass, (u, c) -> ((IConsumeEffectTooltip)ReflectionUtils.copyClassData(clazz, c)).getTooltip((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register consume effect tooltip for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for consume effect tooltip " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerNumberProvider(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> numberProviderClass = Class.forName(classAnnotation.value());
                registry.registerNumberProvider(numberProviderClass, (u, c) -> ((INumberProvider)ReflectionUtils.copyClassData(clazz, c)).convertNumber((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register number provider for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for number provider " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerCountModifier(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> functionClass = Class.forName(classAnnotation.value());
                registry.registerCountModifier(functionClass, (u, c, m) -> ((ICountModifier)ReflectionUtils.copyClassData(clazz, c)).applyCountModifier((IServerUtils)u, (Map<class_6880<class_1887>, Map<Integer, RangeValue>>)m));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register count modifier for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for count modifier " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerChanceModifier(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> conditionClass = Class.forName(classAnnotation.value());
                registry.registerChanceModifier(conditionClass, (u, c, m) -> ((IChanceModifier)ReflectionUtils.copyClassData(clazz, c)).applyChanceModifier((IServerUtils)u, (Map<class_6880<class_1887>, Map<Integer, RangeValue>>)m));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register chance modifier for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for chance modifier " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerItemStackModifier(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> functionClass = Class.forName(classAnnotation.value());
                registry.registerItemStackModifier(functionClass, (u, c, m) -> ((IItemStackModifier)ReflectionUtils.copyClassData(clazz, c)).applyItemStackModifier((IServerUtils)u, (class_1799)m));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register item stack modifier for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for item stack modifier " + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerItemListing(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> conditionClass = Class.forName(classAnnotation.value());
                registry.registerItemListing(conditionClass, (u, c, t) -> ((IItemListing)ReflectionUtils.copyClassData(clazz, c)).getNode((IServerUtils)u, (List<ITooltipNode>)t));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register item listing for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Missing ClassAccessor annotation for item listing {}" + clazz.getName());
        }
    }

    public static <T extends BaseAccessor<?>> void registerItemListingCollector(IServerRegistry registry, Class<T> clazz) {
        ClassAccessor classAnnotation = clazz.getAnnotation(ClassAccessor.class);
        if (classAnnotation != null) {
            try {
                Class<?> conditionClass = Class.forName(classAnnotation.value());
                registry.registerItemListingCollector(conditionClass, (u, c) -> ((IItemListing)ReflectionUtils.copyClassData(clazz, c)).collectItems((IServerUtils)u));
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to register item listing collector for {} with error {}", (Object)classAnnotation.value(), (Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            LOGGER.warn("Missing ClassAccessor annotation for item listing collector {}", (Object)clazz.getName());
        }
    }

    public static <T extends class_1935> List<class_1792> getItems(IServerUtils utils, class_6862<T> tag) {
        class_3218 level = utils.getServerLevel();
        if (level != null) {
            class_2378 registry = level.method_30349().method_30530(tag.comp_326());
            return StreamSupport.stream(registry.method_40286(tag).spliterator(), false).map(class_6880::comp_349).map(class_1935::method_8389).toList();
        }
        return Collections.emptyList();
    }

    public static <T extends class_1935> List<class_1792> getItems(IServerUtils utils, Either<class_1799, class_6862<T>> either) {
        class_3218 level = utils.getServerLevel();
        if (level != null) {
            return (List)either.map(i -> List.of(i.method_7909()), t -> {
                class_2378 registry = level.method_30349().method_30530(t.comp_326());
                return StreamSupport.stream(registry.method_40286(t).spliterator(), false).map(class_6880::comp_349).map(class_1935::method_8389).toList();
            });
        }
        return Collections.emptyList();
    }

    @NotNull
    public static <T> List<T> getCapturedInstances(Object predicate, Class<T> requiredType) {
        ArrayList<T> instances = new ArrayList<T>();
        try {
            Field[] fields;
            for (Field field : fields = predicate.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object entry = field.get(predicate);
                if (!requiredType.isInstance(entry)) continue;
                instances.add(requiredType.cast(entry));
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Error while accessing field: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Security error while accessing field: " + e.getMessage());
        }
        return instances;
    }
}

