/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IEntryWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.WidgetDirection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AliClientRegistry
implements IClientRegistry,
IClientUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LootContext LOOT_CONTEXT = new LootContext(new LootParams(null, Map.of(), Map.of(), 0.0f), RandomSource.create(), null);
    private final Map<LootPoolEntryType, IClientRegistry.IWidgetFactory> widgetMap = new HashMap<LootPoolEntryType, IClientRegistry.IWidgetFactory>();
    private final Map<LootNumberProviderType, BiFunction<IClientUtils, NumberProvider, RangeValue>> numberConverterMap = new HashMap<LootNumberProviderType, BiFunction<IClientUtils, NumberProvider, RangeValue>>();
    private final Map<LootItemConditionType, TriFunction<IClientUtils, Integer, LootItemCondition, List<Component>>> conditionTooltipMap = new HashMap<LootItemConditionType, TriFunction<IClientUtils, Integer, LootItemCondition, List<Component>>>();
    private final Map<LootItemFunctionType, TriFunction<IClientUtils, Integer, LootItemFunction, List<Component>>> functionTooltipMap = new HashMap<LootItemFunctionType, TriFunction<IClientUtils, Integer, LootItemFunction, List<Component>>>();
    private final Map<LootItemConditionType, TriConsumer<IClientUtils, LootItemCondition, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>> chanceModifierMap = new HashMap<LootItemConditionType, TriConsumer<IClientUtils, LootItemCondition, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>>();
    private final Map<LootItemFunctionType, TriConsumer<IClientUtils, LootItemFunction, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>> countModifierMap = new HashMap<LootItemFunctionType, TriConsumer<IClientUtils, LootItemFunction, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>>();
    private final Map<LootItemFunctionType, TriFunction<IClientUtils, LootItemFunction, ItemStack, ItemStack>> itemStackModifierMap = new HashMap<LootItemFunctionType, TriFunction<IClientUtils, LootItemFunction, ItemStack, ItemStack>>();
    private final Map<LootPoolEntryType, WidgetDirection> widgetDirectionMap = new HashMap<LootPoolEntryType, WidgetDirection>();
    private final Map<LootPoolEntryType, IClientRegistry.IBoundsGetter> widgetBoundsMap = new HashMap<LootPoolEntryType, IClientRegistry.IBoundsGetter>();
    private final Map<ResourceLocation, LootTable> lootTableMap = new HashMap<ResourceLocation, LootTable>();
    private final Map<ResourceLocation, List<Item>> lootItemMap = new HashMap<ResourceLocation, List<Item>>();

    public void addLootTable(ResourceLocation resourceLocation, LootTable lootTable, List<Item> items) {
        this.lootTableMap.put(resourceLocation, lootTable);
        this.lootItemMap.put(resourceLocation, items);
    }

    public Map<ResourceLocation, LootTable> getLootTables() {
        return this.lootTableMap;
    }

    public void clearLootTables() {
        this.lootTableMap.clear();
    }

    @Override
    public void registerWidget(LootPoolEntryType type, WidgetDirection direction, IClientRegistry.IWidgetFactory factory, IClientRegistry.IBoundsGetter boundsGetter) {
        this.widgetMap.put(type, factory);
        this.widgetDirectionMap.put(type, direction);
        this.widgetBoundsMap.put(type, boundsGetter);
    }

    @Override
    public <T extends NumberProvider> void registerNumberProvider(LootNumberProviderType type, BiFunction<IClientUtils, T, RangeValue> converter) {
        this.numberConverterMap.put(type, (u, t) -> (RangeValue)converter.apply((IClientUtils)u, (Object)t));
    }

    @Override
    public <T extends LootItemCondition> void registerConditionTooltip(LootItemConditionType type, TriFunction<IClientUtils, Integer, T, List<Component>> getter) {
        this.conditionTooltipMap.put(type, (TriFunction<IClientUtils, Integer, LootItemCondition, List<Component>>)((TriFunction)(u, i, c) -> (List)getter.apply(u, i, c)));
    }

    @Override
    public <T extends LootItemFunction> void registerFunctionTooltip(LootItemFunctionType type, TriFunction<IClientUtils, Integer, T, List<Component>> getter) {
        this.functionTooltipMap.put(type, (TriFunction<IClientUtils, Integer, LootItemFunction, List<Component>>)((TriFunction)(u, i, f) -> (List)getter.apply(u, i, f)));
    }

    @Override
    public <T extends LootItemFunction> void registerCountModifier(LootItemFunctionType type, TriConsumer<IClientUtils, T, Map<Holder<Enchantment>, Map<Integer, RangeValue>>> consumer) {
        this.countModifierMap.put(type, (TriConsumer<IClientUtils, LootItemFunction, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>)((TriConsumer)(u, f, v) -> consumer.accept(u, f, v)));
    }

    @Override
    public <T extends LootItemCondition> void registerChanceModifier(LootItemConditionType type, TriConsumer<IClientUtils, T, Map<Holder<Enchantment>, Map<Integer, RangeValue>>> consumer) {
        this.chanceModifierMap.put(type, (TriConsumer<IClientUtils, LootItemCondition, Map<Holder<Enchantment>, Map<Integer, RangeValue>>>)((TriConsumer)(u, f, v) -> consumer.accept(u, f, v)));
    }

    @Override
    public <T extends LootItemFunction> void registerItemStackModifier(LootItemFunctionType type, TriFunction<IClientUtils, T, ItemStack, ItemStack> consumer) {
        this.itemStackModifierMap.put(type, (TriFunction<IClientUtils, LootItemFunction, ItemStack, ItemStack>)((TriFunction)(u, f, i) -> (ItemStack)consumer.apply(u, f, i)));
    }

    @Override
    public Pair<List<IEntryWidget>, Rect> createWidgets(IWidgetUtils utils, List<LootPoolEntryContainer> entries, int x, int y, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        int posX = x + 7;
        int posY = y;
        int width = 0;
        int height = 0;
        int sumWeight = 0;
        LinkedList<IEntryWidget> widgets = new LinkedList<IEntryWidget>();
        WidgetDirection lastDirection = null;
        for (LootPoolEntryContainer entry : entries) {
            if (!(entry instanceof LootPoolSingletonContainer)) continue;
            LootPoolSingletonContainer singletonEntry = (LootPoolSingletonContainer)entry;
            sumWeight += singletonEntry.weight;
        }
        for (LootPoolEntryContainer entry : entries) {
            Rect bound;
            WidgetDirection direction = this.widgetDirectionMap.get(entry.getType());
            IClientRegistry.IWidgetFactory widgetFactory = this.widgetMap.get(entry.getType());
            IClientRegistry.IBoundsGetter bounds = this.widgetBoundsMap.get(entry.getType());
            if (direction == null || widgetFactory == null || bounds == null) continue;
            if (lastDirection != null && direction != lastDirection && direction == WidgetDirection.VERTICAL) {
                posX = x + 7;
                posY = y + height + 2;
            }
            if ((bound = bounds.apply(utils, entry, posX, posY)).right() > 162) {
                posX = x + 7;
                posY += bound.height();
                bound = bounds.apply(utils, entry, posX, posY);
            }
            IEntryWidget widget = widgetFactory.create(utils, entry, posX, posY, sumWeight, List.copyOf(functions), List.copyOf(conditions));
            width = Math.max(width, bound.right() - x);
            height = Math.max(height, bound.bottom() - y);
            if (lastDirection != null) {
                if (lastDirection != direction) {
                    posX = x + 7;
                    posY += bound.height() + 2;
                } else if (direction == WidgetDirection.HORIZONTAL) {
                    posX += bound.width();
                } else if (direction == WidgetDirection.VERTICAL) {
                    posY += bound.height() + 2;
                }
            } else {
                switch (direction) {
                    case HORIZONTAL: {
                        posX += bound.width();
                        break;
                    }
                    case VERTICAL: {
                        posY += bound.height() + 2;
                    }
                }
            }
            widgets.add(widget);
            lastDirection = direction;
        }
        return new Pair(widgets, (Object)new Rect(x, y, width, height));
    }

    @Override
    public <T extends LootItemCondition> List<Component> getConditionTooltip(IClientUtils utils, int pad, T condition) {
        TriFunction<IClientUtils, Integer, LootItemCondition, List<Component>> entryTooltipGetter = this.conditionTooltipMap.get(condition.getType());
        if (entryTooltipGetter != null) {
            return (List)entryTooltipGetter.apply((Object)utils, (Object)pad, condition);
        }
        LOGGER.warn("Condition tooltip for {} was not registered", (Object)condition.getClass().getCanonicalName());
        return List.of();
    }

    @Override
    public <T extends LootItemFunction> List<Component> getFunctionTooltip(IClientUtils utils, int pad, T function) {
        TriFunction<IClientUtils, Integer, LootItemFunction, List<Component>> entryTooltipGetter = this.functionTooltipMap.get(function.getType());
        if (entryTooltipGetter != null) {
            return (List)entryTooltipGetter.apply((Object)utils, (Object)pad, function);
        }
        LOGGER.warn("Function tooltip for {} was not registered", (Object)function.getClass().getCanonicalName());
        return List.of();
    }

    @Override
    public <T extends LootItemFunction> void applyCountModifier(IClientUtils utils, T function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        TriConsumer<IClientUtils, LootItemFunction, Map<Holder<Enchantment>, Map<Integer, RangeValue>>> bonusCountConsumer = this.countModifierMap.get(function.getType());
        if (bonusCountConsumer != null) {
            bonusCountConsumer.accept((Object)utils, function, count);
        }
    }

    @Override
    public <T extends LootItemCondition> void applyChanceModifier(IClientUtils utils, T condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        TriConsumer<IClientUtils, LootItemCondition, Map<Holder<Enchantment>, Map<Integer, RangeValue>>> bonusChanceConsumer = this.chanceModifierMap.get(condition.getType());
        if (bonusChanceConsumer != null) {
            bonusChanceConsumer.accept((Object)utils, condition, chance);
        }
    }

    @Override
    public <T extends LootItemFunction> ItemStack applyItemStackModifier(IClientUtils utils, T function, ItemStack itemStack) {
        TriFunction<IClientUtils, LootItemFunction, ItemStack, ItemStack> bonusChanceConsumer = this.itemStackModifierMap.get(function.getType());
        if (bonusChanceConsumer != null) {
            itemStack = (ItemStack)bonusChanceConsumer.apply((Object)utils, function, (Object)itemStack);
        }
        return itemStack;
    }

    @Override
    public Rect getBounds(IClientUtils utils, List<LootPoolEntryContainer> entries, int x, int y) {
        int posX = x + 7;
        int posY = y;
        int width = 0;
        int height = 0;
        WidgetDirection lastDirection = null;
        for (LootPoolEntryContainer entry : entries) {
            Rect bound;
            WidgetDirection direction = this.widgetDirectionMap.get(entry.getType());
            IClientRegistry.IWidgetFactory widgetFactory = this.widgetMap.get(entry.getType());
            IClientRegistry.IBoundsGetter bounds = this.widgetBoundsMap.get(entry.getType());
            if (direction == null || widgetFactory == null || bounds == null) continue;
            if (lastDirection != null && direction != lastDirection && direction == WidgetDirection.VERTICAL) {
                posX = x + 7;
                posY = y + height + 2;
            }
            if ((bound = bounds.apply(utils, entry, posX, posY)).right() > 162) {
                posX = x + 7;
                posY += bound.height();
                bound = bounds.apply(utils, entry, posX, posY);
            }
            width = Math.max(width, bound.right() - x);
            height = Math.max(height, bound.bottom() - y);
            if (lastDirection != null) {
                if (lastDirection != direction) {
                    posX = x + 7;
                    posY += bound.height() + 2;
                } else if (direction == WidgetDirection.HORIZONTAL) {
                    posX += bound.width();
                } else if (direction == WidgetDirection.VERTICAL) {
                    posY += bound.height() + 2;
                }
            } else {
                switch (direction) {
                    case HORIZONTAL: {
                        posX += bound.width();
                        break;
                    }
                    case VERTICAL: {
                        posY += bound.height() + 2;
                    }
                }
            }
            lastDirection = direction;
        }
        return new Rect(x, y, width, height);
    }

    @Override
    @Nullable
    public WidgetDirection getWidgetDirection(LootPoolEntryContainer entry) {
        return this.widgetDirectionMap.get(entry.getType());
    }

    @Override
    public LootContext getLootContext() {
        return LOOT_CONTEXT;
    }

    @Override
    public List<Item> getItems(ResourceLocation location) {
        return this.lootItemMap.getOrDefault(location, List.of());
    }

    @Override
    @Nullable
    public LootTable getLootTable(ResourceLocation resourceLocation) {
        return this.lootTableMap.get(resourceLocation);
    }

    @Override
    public RangeValue convertNumber(IClientUtils utils, @Nullable NumberProvider numberProvider) {
        if (numberProvider != null) {
            BiFunction<IClientUtils, NumberProvider, RangeValue> function = this.numberConverterMap.get(numberProvider.getType());
            if (function != null) {
                try {
                    return function.apply(utils, numberProvider);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Failed to convert number with error {}", (Object)throwable.getMessage());
                }
            } else {
                LOGGER.warn("Number converter for {} was not registered", (Object)numberProvider.getClass().getCanonicalName());
            }
        }
        return new RangeValue(false, true);
    }

    public void printClientInfo() {
        LOGGER.info("Registered {} widgets", (Object)this.widgetMap.size());
        LOGGER.info("Registered {} number converters", (Object)this.numberConverterMap.size());
        LOGGER.info("Registered {} condition tooltips", (Object)this.conditionTooltipMap.size());
        LOGGER.info("Registered {} function tooltips", (Object)this.functionTooltipMap.size());
    }
}

