/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AliServerRegistry
implements IServerRegistry,
IServerUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<LootPoolEntryType, BiFunction<IServerUtils, LootPoolEntryContainer, List<Item>>> entryItemCollectorMap = new HashMap<LootPoolEntryType, BiFunction<IServerUtils, LootPoolEntryContainer, List<Item>>>();
    private final Map<LootItemFunctionType, TriFunction<IServerUtils, List<Item>, LootItemFunction, List<Item>>> functionItemCollectorMap = new HashMap<LootItemFunctionType, TriFunction<IServerUtils, List<Item>, LootItemFunction, List<Item>>>();
    private final Map<LootItemConditionType, TriFunction<IServerUtils, List<Item>, LootItemCondition, List<Item>>> conditionItemCollectorMap = new HashMap<LootItemConditionType, TriFunction<IServerUtils, List<Item>, LootItemCondition, List<Item>>>();
    private final Map<ResourceLocation, LootTable> lootTableMap = new HashMap<ResourceLocation, LootTable>();
    private ServerLevel serverLevel;

    public void addLootTable(ResourceLocation resourceLocation, LootTable lootTable) {
        this.lootTableMap.put(resourceLocation, lootTable);
    }

    public void setServerLevel(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    @Override
    public <T extends LootPoolEntryContainer> void registerItemCollector(LootPoolEntryType type, BiFunction<IServerUtils, T, List<Item>> itemSupplier) {
        this.entryItemCollectorMap.put(type, (u, e) -> (List)itemSupplier.apply((IServerUtils)u, (Object)e));
    }

    @Override
    public <T extends LootItemCondition> void registerItemCollector(LootItemConditionType type, TriFunction<IServerUtils, List<Item>, T, List<Item>> itemSupplier) {
        this.conditionItemCollectorMap.put(type, (TriFunction<IServerUtils, List<Item>, LootItemCondition, List<Item>>)((TriFunction)(u, l, f) -> (List)itemSupplier.apply(u, l, f)));
    }

    @Override
    public <T extends LootItemFunction> void registerItemCollector(LootItemFunctionType type, TriFunction<IServerUtils, List<Item>, T, List<Item>> itemSupplier) {
        this.functionItemCollectorMap.put(type, (TriFunction<IServerUtils, List<Item>, LootItemFunction, List<Item>>)((TriFunction)(u, l, f) -> (List)itemSupplier.apply(u, l, f)));
    }

    @Override
    public <T extends LootPoolEntryContainer> List<Item> collectItems(IServerUtils utils, T entry) {
        BiFunction<IServerUtils, LootPoolEntryContainer, List<Item>> itemSupplier = this.entryItemCollectorMap.get(entry.getType());
        if (itemSupplier != null) {
            return itemSupplier.apply(utils, entry);
        }
        return List.of();
    }

    @Override
    public <T extends LootItemCondition> List<Item> collectItems(IServerUtils utils, List<Item> items, T condition) {
        TriFunction<IServerUtils, List<Item>, LootItemCondition, List<Item>> itemSupplier = this.conditionItemCollectorMap.get(condition.getType());
        if (itemSupplier != null) {
            return (List)itemSupplier.apply((Object)utils, items, condition);
        }
        return List.of();
    }

    @Override
    public <T extends LootItemFunction> List<Item> collectItems(IServerUtils utils, List<Item> items, T function) {
        TriFunction<IServerUtils, List<Item>, LootItemFunction, List<Item>> itemSupplier = this.functionItemCollectorMap.get(function.getType());
        if (itemSupplier != null) {
            return (List)itemSupplier.apply((Object)utils, items, function);
        }
        return List.of();
    }

    @Override
    @Nullable
    public ServerLevel getServerLevel() {
        return this.serverLevel;
    }

    @Override
    @Nullable
    public LootTable getLootTable(ResourceLocation resourceLocation) {
        return this.lootTableMap.get(resourceLocation);
    }

    public void printServerInfo() {
        LOGGER.info("Registered {} entry item collectors", (Object)this.entryItemCollectorMap.size());
        LOGGER.info("Registered {} condition item collectors", (Object)this.conditionItemCollectorMap.size());
        LOGGER.info("Registered {} function item collectors", (Object)this.functionItemCollectorMap.size());
    }
}

