/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;

public class InfoSyncLootTableMessage {
    public final ResourceLocation location;
    public final LootTable lootTable;
    public final List<Item> items;

    public InfoSyncLootTableMessage(ResourceLocation location, LootTable lootTable, List<Item> items) {
        this.location = location;
        this.lootTable = lootTable;
        this.items = items;
    }

    public InfoSyncLootTableMessage(FriendlyByteBuf buf) {
        this.location = buf.readResourceLocation();
        this.lootTable = (LootTable)LootDataType.TABLE.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)buf.readJsonWithCodec(ExtraCodecs.JSON))).get().orThrow();
        this.items = buf.readList(b -> (Item)BuiltInRegistries.ITEM.get(b.readResourceLocation()));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.location);
        buf.writeJsonWithCodec(ExtraCodecs.JSON, (Object)((JsonElement)LootDataType.TABLE.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.lootTable).get().orThrow()));
        buf.writeCollection(this.items, (b, item) -> buf.writeResourceLocation(BuiltInRegistries.ITEM.getKey(item)));
    }
}

