/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.plugin.client.GenericTooltipUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.FillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.FunctionReference;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SequenceFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetContainerLootTable;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetInstrumentFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetLoreFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class FunctionTooltipUtils {
    @NotNull
    public static List<Component> getApplyBonusTooltip(IClientUtils utils, int pad, ApplyBonusCount fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.apply_bonus", new Object[0])));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, fun.enchantment, GenericTooltipUtils::getEnchantmentTooltip));
        components.addAll(GenericTooltipUtils.getFormulaTooltip(utils, pad + 1, fun.formula));
        return components;
    }

    @NotNull
    public static List<Component> getCopyNameTooltip(IClientUtils utils, int pad, CopyNameFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.copy_name", new Object[0])));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.source", fun.source));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getCopyNbtTooltip(IClientUtils utils, int pad, CopyNbtFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.copy_nbt", new Object[0])));
        components.addAll(GenericTooltipUtils.getBuiltInRegistryTooltip(utils, pad + 1, "ali.property.value.nbt_provider", BuiltInRegistries.LOOT_NBT_PROVIDER_TYPE, fun.source.getType()));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.operations", fun.operations, GenericTooltipUtils::getCopyOperationTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getCopyStateTooltip(IClientUtils utils, int pad, CopyBlockState fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.copy_state", new Object[0])));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, fun.block, GenericTooltipUtils::getBlockTooltip));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.properties", fun.properties, GenericTooltipUtils::getPropertyTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEnchantRandomlyTooltip(IClientUtils utils, int pad, EnchantRandomlyFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.enchant_randomly", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, pad + 1, "ali.property.branch.enchantments", fun.enchantments, GenericTooltipUtils::getEnchantmentTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getEnchantWithLevelsTooltip(IClientUtils utils, int pad, EnchantWithLevelsFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.enchant_with_levels", new Object[0])));
        components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 1, "ali.property.value.levels", fun.levels));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.treasure", fun.treasure));
        return components;
    }

    @NotNull
    public static List<Component> getExplorationMapTooltip(IClientUtils utils, int pad, ExplorationMapFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.exploration_map", new Object[0])));
        components.addAll(GenericTooltipUtils.getTagKeyTooltip(utils, pad + 1, "ali.property.value.destination", fun.destination));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.map_decoration", fun.mapDecoration));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.zoom", fun.zoom));
        components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.search_radius", fun.searchRadius));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.skip_known_structures", fun.skipKnownStructures));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getExplosionDecayTooltip(IClientUtils ignoredUtils, int pad, ApplyExplosionDecay ignoredFun) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.explosion_decay", new Object[0])));
    }

    @NotNull
    public static List<Component> getFillPlayerHeadTooltip(IClientUtils utils, int pad, FillPlayerHead fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.fill_player_head", new Object[0])));
        components.addAll(GenericTooltipUtils.getEnumTooltip(utils, pad + 1, "ali.property.value.target", fun.entityTarget));
        return components;
    }

    public static @Unmodifiable @NotNull List<Component> getFurnaceSmeltTooltip(IClientUtils ignoredUtils, int pad, SmeltItemFunction ignoredFun) {
        return List.of(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.furnace_smelt", new Object[0])));
    }

    @NotNull
    public static List<Component> getLimitCountTooltip(IClientUtils utils, int pad, LimitCount fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.limit_count", new Object[0])));
        components.addAll(GenericTooltipUtils.getIntRangeTooltip(utils, pad + 1, "ali.property.value.limit", fun.limiter));
        return components;
    }

    @NotNull
    public static List<Component> getLootingEnchantTooltip(IClientUtils utils, int pad, LootingEnchantFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.looting_enchant", new Object[0])));
        components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 1, "ali.property.value.value", fun.value));
        if (fun.limit > 0) {
            components.addAll(GenericTooltipUtils.getIntegerTooltip(utils, pad + 1, "ali.property.value.limit", fun.limit));
        }
        return components;
    }

    @NotNull
    public static List<Component> getReferenceTooltip(IClientUtils utils, int pad, FunctionReference fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.reference", new Object[0])));
        components.addAll(GenericTooltipUtils.getResourceLocationTooltip(utils, pad + 1, "ali.property.value.name", fun.name));
        return components;
    }

    @NotNull
    public static List<Component> getSequenceTooltip(IClientUtils utils, int pad, SequenceFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.sequence", new Object[0])));
        components.addAll(GenericTooltipUtils.getFunctionsTooltip(utils, pad + 1, fun.functions));
        return components;
    }

    @NotNull
    public static List<Component> getSetAttributesTooltip(IClientUtils utils, int pad, SetAttributesFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_attributes", new Object[0])));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.modifiers", fun.modifiers, GenericTooltipUtils::getModifierTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSetBannerPatternTooltip(IClientUtils utils, int pad, SetBannerPatternFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_banner_pattern", new Object[0])));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.append", fun.append));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.banner_patterns", fun.patterns, GenericTooltipUtils::getBannerPatternTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSetContentsTooltip(IClientUtils utils, int pad, SetContainerContents fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_contents", new Object[0])));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, fun.type, GenericTooltipUtils::getBlockEntityTypeTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSetCountTooltip(IClientUtils utils, int pad, SetItemCountFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_count", new Object[0])));
        components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 1, "ali.property.value.count", fun.value));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.add", fun.add));
        return components;
    }

    @NotNull
    public static List<Component> getSetDamageTooltip(IClientUtils utils, int pad, SetItemDamageFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_damage", new Object[0])));
        components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 1, "ali.property.value.damage", fun.damage));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.add", fun.add));
        return components;
    }

    @NotNull
    public static List<Component> getSetEnchantmentsTooltip(IClientUtils utils, int pad, SetEnchantmentsFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_enchantments", new Object[0])));
        if (!fun.enchantments.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.enchantments", new Object[0])));
            fun.enchantments.forEach((enchantment, value) -> {
                components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 2, enchantment, GenericTooltipUtils::getEnchantmentTooltip));
                components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 3, "ali.property.value.levels", value));
            });
        }
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.add", fun.add));
        return components;
    }

    @NotNull
    public static List<Component> getSetInstrumentTooltip(IClientUtils utils, int pad, SetInstrumentFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_instrument", new Object[0])));
        components.addAll(GenericTooltipUtils.getTagKeyTooltip(utils, pad + 1, "ali.property.value.options", fun.options));
        return components;
    }

    @NotNull
    public static List<Component> getSetLootTableTooltip(IClientUtils utils, int pad, SetContainerLootTable fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_loot_table", new Object[0])));
        components.addAll(GenericTooltipUtils.getResourceLocationTooltip(utils, pad + 1, "ali.property.value.name", fun.name));
        components.addAll(GenericTooltipUtils.getLongTooltip(utils, pad + 1, "ali.property.value.seed", fun.seed));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, fun.type, GenericTooltipUtils::getBlockEntityTypeTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSetLoreTooltip(IClientUtils utils, int pad, SetLoreFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_lore", new Object[0])));
        components.addAll(GenericTooltipUtils.getBooleanTooltip(utils, pad + 1, "ali.property.value.replace", fun.replace));
        components.addAll(GenericTooltipUtils.getCollectionTooltip(utils, pad + 1, "ali.property.branch.lore", fun.lore, (u, p, c) -> List.of(GenericTooltipUtils.pad(pad + 2, c))));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.resolution_context", fun.resolutionContext, GenericTooltipUtils::getEnumTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSetNameTooltip(IClientUtils utils, int pad, SetNameFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_name", new Object[0])));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.name", fun.name, GenericTooltipUtils::getComponentTooltip));
        components.addAll(GenericTooltipUtils.getOptionalTooltip(utils, pad + 1, "ali.property.value.resolution_context", fun.resolutionContext, GenericTooltipUtils::getEnumTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSetNbtTooltip(IClientUtils utils, int pad, SetNbtFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_nbt", new Object[0])));
        components.addAll(GenericTooltipUtils.getStringTooltip(utils, pad + 1, "ali.property.value.tag", fun.tag.getAsString()));
        return components;
    }

    @NotNull
    public static List<Component> getSetPotionTooltip(IClientUtils utils, int pad, SetPotionFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_potion", new Object[0])));
        components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 1, fun.potion, GenericTooltipUtils::getPotionTooltip));
        return components;
    }

    @NotNull
    public static List<Component> getSetStewEffectTooltip(IClientUtils utils, int pad, SetStewEffectFunction fun) {
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(GenericTooltipUtils.pad(pad, GenericTooltipUtils.translatable("ali.type.function.set_stew_effect", new Object[0])));
        if (!fun.effects.isEmpty()) {
            components.add(GenericTooltipUtils.pad(pad + 1, GenericTooltipUtils.translatable("ali.property.branch.mob_effects", new Object[0])));
            fun.effects.forEach(effect -> {
                components.addAll(GenericTooltipUtils.getHolderTooltip(utils, pad + 2, effect.effect(), GenericTooltipUtils::getMobEffectTooltip));
                components.addAll(GenericTooltipUtils.getNumberProviderTooltip(utils, pad + 3, "ali.property.value.duration", effect.duration()));
            });
        }
        return components;
    }
}

