/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.client;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.RangeValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    private TooltipUtils() {
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getChance(IClientUtils utils, List<LootItemCondition> conditions, float rawChance) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> chance = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        chance.put(null, Map.of(0, new RangeValue(rawChance * 100.0f)));
        for (LootItemCondition condition : conditions) {
            utils.applyChanceModifier(utils, condition, chance);
        }
        return chance;
    }

    @NotNull
    public static Map<Holder<Enchantment>, Map<Integer, RangeValue>> getCount(IClientUtils utils, List<LootItemFunction> functions) {
        LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>> count = new LinkedHashMap<Holder<Enchantment>, Map<Integer, RangeValue>>();
        count.put(null, Map.of(0, new RangeValue()));
        for (LootItemFunction function : functions) {
            utils.applyCountModifier(utils, function, count);
        }
        return count;
    }

    public static ItemStack getItemStack(IClientUtils utils, LootPoolEntryContainer entry, Item item) {
        ItemStack itemStack = item.getDefaultInstance();
        if (entry.conditions.isEmpty() && entry instanceof LootPoolSingletonContainer) {
            LootPoolSingletonContainer container = (LootPoolSingletonContainer)entry;
            for (LootItemFunction function : container.functions) {
                itemStack = utils.applyItemStackModifier(utils, function, itemStack);
            }
        }
        return itemStack;
    }

    public static void applyRandomChance(IClientUtils utils, LootItemRandomChanceCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap : chance.entrySet()) {
            for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                levelEntry.getValue().multiply(condition.probability());
            }
        }
    }

    public static void applyRandomChanceWithLooting(IClientUtils utils, LootItemRandomChanceWithLootingCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        Holder enchantment = Holder.direct((Object)Enchantments.MOB_LOOTING);
        if (chance.containsKey(enchantment)) {
            chance.get(null).get(0).multiply(condition.percent());
            for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                entry.getValue().multiply(condition.percent() + (float)entry.getKey().intValue() * condition.lootingMultiplier());
            }
        } else {
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(condition.percent());
            chance.put((Holder<Enchantment>)enchantment, levelMap);
            for (int level = 1; level <= ((Enchantment)enchantment.value()).getMaxLevel(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(condition.percent() + (float)level * condition.lootingMultiplier()));
            }
        }
    }

    public static void applyTableBonus(IClientUtils utils, BonusLevelTableCondition condition, Map<Holder<Enchantment>, Map<Integer, RangeValue>> chance) {
        block2: {
            Holder enchantment;
            block3: {
                enchantment = condition.enchantment();
                if (condition.values().isEmpty()) break block2;
                if (!chance.containsKey(enchantment)) break block3;
                chance.get(null).get(0).multiply(((Float)condition.values().get(0)).floatValue());
                if (condition.values().size() <= 1) break block2;
                for (Map.Entry<Integer, RangeValue> entry : chance.get(enchantment).entrySet()) {
                    Integer level = entry.getKey();
                    if (level >= condition.values().size()) continue;
                    entry.getValue().multiply(((Float)condition.values().get(level)).floatValue());
                }
                break block2;
            }
            RangeValue baseChance = new RangeValue(chance.get(null).get(0));
            LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
            chance.get(null).get(0).multiply(((Float)condition.values().get(0)).floatValue());
            chance.put((Holder<Enchantment>)enchantment, levelMap);
            for (int level = 1; level <= ((Enchantment)enchantment.value()).getMaxLevel() && level < condition.values().size(); ++level) {
                levelMap.put(level, new RangeValue(baseChance).multiply(((Float)condition.values().get(level)).floatValue()));
            }
        }
    }

    public static void applySetCount(IClientUtils utils, SetItemCountFunction function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        if (function.predicates.isEmpty()) {
            for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> chanceMap : count.entrySet()) {
                for (Map.Entry<Integer, RangeValue> levelEntry : chanceMap.getValue().entrySet()) {
                    if (function.add) {
                        levelEntry.getValue().add(utils.convertNumber(utils, function.value));
                        continue;
                    }
                    levelEntry.getValue().set(utils.convertNumber(utils, function.value));
                }
            }
        }
    }

    public static void applyBonus(IClientUtils utils, ApplyBonusCount function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        block4: {
            if (!function.predicates.isEmpty()) break block4;
            Holder enchantment = function.enchantment;
            if (count.containsKey(enchantment)) {
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    TooltipUtils.calculateCount(function, entry.getValue(), entry.getKey());
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                TooltipUtils.calculateCount(function, count.get(null).get(0), 0);
                count.put((Holder<Enchantment>)enchantment, levelMap);
                for (int level = 1; level <= ((Enchantment)enchantment.value()).getMaxLevel(); ++level) {
                    RangeValue value = new RangeValue(baseCount);
                    TooltipUtils.calculateCount(function, value, level);
                    levelMap.put(level, value);
                }
            }
        }
    }

    public static void applyLimitCount(IClientUtils utils, LimitCount function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> bonusCount) {
        if (function.predicates.isEmpty()) {
            for (Map.Entry<Holder<Enchantment>, Map<Integer, RangeValue>> entry : bonusCount.entrySet()) {
                for (Map.Entry<Integer, RangeValue> mapEntry : entry.getValue().entrySet()) {
                    RangeValue value = mapEntry.getValue();
                    value.clamp(utils.convertNumber(utils, function.limiter.min), utils.convertNumber(utils, function.limiter.max));
                }
            }
        }
    }

    public static void applyLootingEnchant(IClientUtils utils, LootingEnchantFunction function, Map<Holder<Enchantment>, Map<Integer, RangeValue>> count) {
        block5: {
            if (!function.predicates.isEmpty()) break block5;
            Holder enchantment = Holder.direct((Object)Enchantments.MOB_LOOTING);
            if (count.containsKey(enchantment)) {
                for (Map.Entry<Integer, RangeValue> entry : count.get(enchantment).entrySet()) {
                    RangeValue value = entry.getValue();
                    value.add(utils.convertNumber(utils, function.value).multiply(entry.getKey().intValue()));
                    if (function.limit <= 0) continue;
                    value.clamp(new RangeValue(false, true), new RangeValue(function.limit));
                }
            } else {
                RangeValue baseCount = new RangeValue(count.get(null).get(0));
                LinkedHashMap<Integer, RangeValue> levelMap = new LinkedHashMap<Integer, RangeValue>();
                count.put((Holder<Enchantment>)enchantment, levelMap);
                for (int level = 1; level <= ((Enchantment)enchantment.value()).getMaxLevel(); ++level) {
                    RangeValue value = new RangeValue(baseCount).add(utils.convertNumber(utils, function.value).multiply(level));
                    if (function.limit > 0) {
                        value.clamp(new RangeValue(false, true), new RangeValue(function.limit));
                    }
                    levelMap.put(level, value);
                }
            }
        }
    }

    @NotNull
    public static ItemStack applyEnchantRandomlyItemStackModifier(IClientUtils utils, EnchantRandomlyFunction function, ItemStack itemStack) {
        if (itemStack.isEnchantable() && function.predicates.isEmpty()) {
            List<Holder.Reference> list;
            boolean isBook = itemStack.is(Items.BOOK);
            ItemStack finalItemStack = itemStack;
            Optional<HolderSet.Direct> enchantments = function.enchantments;
            if (enchantments.isEmpty() && (list = BuiltInRegistries.ENCHANTMENT.holders().filter(ref -> ((Enchantment)ref.value()).isDiscoverable()).filter(ref -> isBook || ((Enchantment)ref.value()).canEnchant(finalItemStack)).toList()).size() == 1) {
                enchantments = Optional.of(HolderSet.direct((Holder[])new Holder[]{(Holder)list.get(0)}));
            }
            if (enchantments.isPresent() && ((HolderSet)enchantments.get()).size() == 1 && ((Enchantment)((HolderSet)enchantments.get()).get(0).value()).getMinLevel() == ((Enchantment)((HolderSet)enchantments.get()).get(0).value()).getMaxLevel()) {
                itemStack.enchant((Enchantment)((HolderSet)enchantments.get()).get(0).value(), ((Enchantment)((HolderSet)enchantments.get()).get(0).value()).getMaxLevel());
            } else if (isBook) {
                itemStack = Items.ENCHANTED_BOOK.getDefaultInstance();
            }
        }
        return itemStack;
    }

    @NotNull
    public static ItemStack applyEnchantWithLevelsItemStackModifier(IClientUtils utils, EnchantWithLevelsFunction function, ItemStack itemStack) {
        if (itemStack.isEnchantable() && function.predicates.isEmpty() && itemStack.is(Items.BOOK)) {
            itemStack = Items.ENCHANTED_BOOK.getDefaultInstance();
        }
        return itemStack;
    }

    public static ItemStack applySetAttributesItemStackModifier(IClientUtils utils, SetAttributesFunction function, ItemStack itemStack) {
        if (function.predicates.isEmpty()) {
            for (SetAttributesFunction.Modifier modifier : function.modifiers) {
                UUID id = modifier.id().orElse(UUID.randomUUID());
                if (modifier.slots().size() != 1 || modifier.amount().getType() != NumberProviders.CONSTANT) continue;
                EquipmentSlot equipmentSlot = (EquipmentSlot)Util.getRandom((List)modifier.slots(), (RandomSource)RandomSource.create());
                ConstantValue value = (ConstantValue)modifier.amount();
                itemStack.addAttributeModifier((Attribute)modifier.attribute().value(), new AttributeModifier(id, modifier.name(), (double)value.getFloat(null), modifier.operation()), equipmentSlot);
            }
        }
        return itemStack;
    }

    public static ItemStack applySetNameItemStackModifier(IClientUtils utils, SetNameFunction function, ItemStack itemStack) {
        if (function.predicates.isEmpty() && function.name.isPresent()) {
            itemStack.setHoverName((Component)function.name.get());
        }
        return itemStack;
    }

    public static ItemStack applyItemStackModifier(IClientUtils utils, LootItemFunction function, ItemStack itemStack) {
        if (function instanceof LootItemConditionalFunction) {
            LootItemConditionalFunction conditional = (LootItemConditionalFunction)function;
            if (!conditional.predicates.isEmpty()) {
                return itemStack;
            }
        }
        itemStack = (ItemStack)function.apply((Object)itemStack, null);
        return itemStack;
    }

    private static void calculateCount(ApplyBonusCount function, RangeValue value, int level) {
        if (function.formula instanceof ApplyBonusCount.OreDrops) {
            if (level > 0) {
                value.multiplyMax(level + 1);
            }
        } else {
            ApplyBonusCount.Formula formula = function.formula;
            if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
                ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
                value.addMax(binomialWithBonusCount.extraRounds() + level);
            } else {
                formula = function.formula;
                if (formula instanceof ApplyBonusCount.UniformBonusCount) {
                    ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
                    if (level > 0) {
                        value.addMax(uniformBonusCount.bonusMultiplier() * level);
                    }
                }
            }
        }
    }
}

