/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBlockLoot;
import com.yanny.ali.compatibility.emi.EmiEntityLoot;
import com.yanny.ali.compatibility.emi.EmiGameplayLoot;
import com.yanny.ali.compatibility.emi.EmiTradeLoot;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EmiEntrypoint
public class EmiCompatibility
implements EmiPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final CompletableFuture<Pair<Map<class_2960, IDataNode>, Map<class_2960, IDataNode>>> futureData = new CompletableFuture();

    public void register(EmiRegistry emiRegistry) {
        PluginManager.CLIENT_REGISTRY.setOnDoneListener((lootData, tradeData) -> this.futureData.complete((Pair<Map<class_2960, IDataNode>, Map<class_2960, IDataNode>>)Pair.of((Object)lootData, (Object)tradeData)));
        this.futureData.thenAccept(pair -> {
            try {
                this.registerData(emiRegistry, (Map)pair.getLeft(), (Map)pair.getRight());
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.error("Failed to register data with error {}", (Object)e.getMessage());
            }
        });
        if (!this.futureData.isDone()) {
            LOGGER.info("Blocking this thread until all data are received!");
        }
        try {
            this.futureData.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            LOGGER.error("Failed to finish registering data with error {}", (Object)e.getMessage());
        }
    }

    private void registerData(EmiRegistry registry, Map<class_2960, IDataNode> lootData, Map<class_2960, IDataNode> tradeData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        class_638 level = class_310.method_1551().field_1687;
        LOGGER.info("Adding loot information to EMI");
        if (level != null) {
            Map<LootCategory, EmiRecipeCategory> blockCategoryMap = LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((class_2960)r.getKey(), (EmiRenderable)EmiStack.of((class_1799)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> entityCategoryMap = LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((class_2960)r.getKey(), (EmiRenderable)EmiStack.of((class_1799)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> gameplayCategoryMap = LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((class_2960)r.getKey(), (EmiRenderable)EmiStack.of((class_1799)((LootCategory)r.getValue()).getIcon()))));
            Map<LootCategory, EmiRecipeCategory> tradeCategoryMap = LootCategories.TRADE_LOOT_CATEGORIES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, r -> new EmiRecipeCategory((class_2960)r.getKey(), (EmiRenderable)EmiStack.of((class_1799)((LootCategory)r.getValue()).getIcon()))));
            blockCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            entityCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            gameplayCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            tradeCategoryMap.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            EmiRecipeCategory blockCategory = EmiCompatibility.createCategory(LootCategories.BLOCK_LOOT);
            EmiRecipeCategory plantCategory = EmiCompatibility.createCategory(LootCategories.PLANT_LOOT);
            EmiRecipeCategory entityCategory = EmiCompatibility.createCategory(LootCategories.ENTITY_LOOT);
            EmiRecipeCategory gameplayCategory = EmiCompatibility.createCategory(LootCategories.GAMEPLAY_LOOT);
            EmiRecipeCategory tradeCategory = EmiCompatibility.createCategory(LootCategories.TRADE_LOOT);
            registry.addCategory(blockCategory);
            registry.addCategory(plantCategory);
            registry.addCategory(entityCategory);
            registry.addCategory(gameplayCategory);
            registry.addCategory(tradeCategory);
            GenericUtils.processData(level, clientRegistry, lootData, tradeData, (node, location, block, outputs) -> {
                EmiRecipeCategory category = null;
                if (LootCategories.PLANT_LOOT.validate((class_2248)block)) {
                    category = plantCategory;
                } else {
                    for (Map.Entry entry : blockCategoryMap.entrySet()) {
                        if (!((LootCategory)entry.getKey()).validate(block)) continue;
                        category = (EmiRecipeCategory)entry.getValue();
                    }
                    if (category == null) {
                        category = blockCategory;
                    }
                }
                registry.addRecipe((EmiRecipe)new EmiBlockLoot(category, (class_2960)location, (class_2248)block, (IDataNode)node, (List<class_1799>)outputs));
            }, (node, location, entity, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : entityCategoryMap.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(entity)) continue;
                    category = (EmiRecipeCategory)entry.getValue();
                }
                if (category == null) {
                    category = entityCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiEntityLoot(category, (class_2960)location, (class_1299<?>)entity, (IDataNode)node, (List<class_1799>)outputs));
            }, (node, location, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry gameplayEntry : gameplayCategoryMap.entrySet()) {
                    if (!((LootCategory)gameplayEntry.getKey()).validate(location.method_12832())) continue;
                    category = (EmiRecipeCategory)gameplayEntry.getValue();
                }
                if (category == null) {
                    category = gameplayCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiGameplayLoot(category, (class_2960)location, (IDataNode)node, (List<class_1799>)outputs));
            }, (tradeEntry, location, inputs, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry e : tradeCategoryMap.entrySet()) {
                    if (!((LootCategory)e.getKey()).validate(location.method_12832())) continue;
                    category = (EmiRecipeCategory)e.getValue();
                }
                if (category == null) {
                    category = tradeCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiTradeLoot(category, (class_2960)location, (IDataNode)tradeEntry, (List<class_1799>)inputs, (List<class_1799>)outputs));
            }, (tradeEntry, location, inputs, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry e : tradeCategoryMap.entrySet()) {
                    if (!((LootCategory)e.getKey()).validate(location.method_12832())) continue;
                    category = (EmiRecipeCategory)e.getValue();
                }
                if (category == null) {
                    category = tradeCategory;
                }
                registry.addRecipe((EmiRecipe)new EmiTradeLoot(category, (class_2960)location, (IDataNode)tradeEntry, (List<class_1799>)inputs, (List<class_1799>)outputs));
            });
        } else {
            LOGGER.warn("EMI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    private static EmiRecipeCategory createCategory(LootCategory<?> category) {
        return new EmiRecipeCategory(Utils.modLoc(category.getKey()), (EmiRenderable)EmiStack.of((class_1799)category.getIcon()));
    }
}

