/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ali.registries.GameplayLootCategory;
import com.yanny.ali.registries.LootCategory;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2405;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class LootCategoryProvider
implements class_2405 {
    private final class_7784 generator;
    private final Set<LootCategory<?>> categories = new HashSet();

    public LootCategoryProvider(class_7784 generator) {
        this.generator = generator;
    }

    public void generate() {
        this.addGameplayCategory("chest_loot", class_1802.field_8106, List.of(Pattern.compile("^chests/.*$")));
        this.addGameplayCategory("fishing_loot", class_1802.field_8378, List.of(Pattern.compile("^gameplay/fishing.*$")));
        this.addGameplayCategory("archaeology_loot", class_1802.field_42699, List.of(Pattern.compile("^archaeology/.*$")));
        this.addGameplayCategory("hero_loot", class_1802.field_8687, List.of(Pattern.compile("^gameplay/hero_of_the_village/.*$")));
    }

    protected void addGameplayCategory(String key, class_1792 icon, List<Pattern> prefix) {
        this.categories.add(new GameplayLootCategory(key, new class_1799((class_1935)icon), LootCategory.Type.GAMEPLAY, prefix));
    }

    @NotNull
    public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        this.generate();
        return CompletableFuture.allOf((CompletableFuture[])this.categories.stream().map(category -> {
            Path output = this.generator.method_45971().resolve("assets/ali/loot_categories/" + category.getKey() + ".json");
            return class_2405.method_10320((class_7403)cachedOutput, (JsonElement)LootCategoryProvider.toJson(category), (Path)output);
        }).toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String method_10321() {
        return "loot_categories";
    }

    @NotNull
    private static JsonElement toJson(LootCategory<?> category) {
        GameplayLootCategory lootCategory;
        JsonObject object = new JsonObject();
        object.addProperty("type", category.getType().name());
        object.addProperty("icon", class_7923.field_41178.method_10221((Object)category.getIcon().method_7909()).toString());
        object.addProperty("key", category.getKey());
        if (Objects.requireNonNull(category.getType()) == LootCategory.Type.GAMEPLAY && category instanceof GameplayLootCategory && (lootCategory = (GameplayLootCategory)category).getPrefix() != null) {
            JsonArray array = new JsonArray();
            lootCategory.getPrefix().forEach(p -> array.add(p.pattern()));
            object.add("prefix", (JsonElement)array);
        }
        return object;
    }
}

