/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.class_117;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_137;
import net.minecraft.class_152;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2022;
import net.minecraft.class_2025;
import net.minecraft.class_2035;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2105;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3735;
import net.minecraft.class_3837;
import net.minecraft.class_42;
import net.minecraft.class_4550;
import net.minecraft.class_4551;
import net.minecraft.class_4552;
import net.minecraft.class_4553;
import net.minecraft.class_4559;
import net.minecraft.class_4965;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_6404;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7376;
import net.minecraft.class_7383;
import net.minecraft.class_8129;
import net.minecraft.class_94;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GenericTooltipUtils {
    private static final class_124 TEXT_STYLE = class_124.field_1065;
    private static final class_124 PARAM_STYLE = class_124.field_1075;

    public static @Unmodifiable @NotNull ITooltipNode getMissingFunction(IServerUtils utils, class_117 function) {
        return RegistriesTooltipUtils.getFunctionTypeTooltip(utils, "ali.util.advanced_loot_info.missing", function.method_29321());
    }

    public static @Unmodifiable @NotNull ITooltipNode getMissingCondition(IServerUtils utils, class_5341 condition) {
        return RegistriesTooltipUtils.getConditionTypeTooltip(utils, "ali.util.advanced_loot_info.missing", condition.method_29325());
    }

    @NotNull
    public static List<ITooltipNode> getConditionListTooltip(IServerUtils utils, List<class_5341> conditions) {
        return conditions.stream().map(condition -> utils.getConditionTooltip(utils, condition)).toList();
    }

    @NotNull
    public static List<ITooltipNode> getConditionsTooltip(IServerUtils utils, List<class_5341> conditions) {
        if (!conditions.isEmpty()) {
            ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.conditions", new Object[0])));
            tooltip.addAll(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
            return tooltip;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static ITooltipNode getSubConditionsTooltip(IServerUtils utils, List<class_5341> conditions) {
        if (!conditions.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.conditions", new Object[0]));
            for (ITooltipNode node : GenericTooltipUtils.getConditionListTooltip(utils, conditions)) {
                tooltip.add(node);
            }
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static List<ITooltipNode> getFunctionListTooltip(IServerUtils utils, List<class_117> functions) {
        return functions.stream().map(function -> utils.getFunctionTooltip(utils, function)).toList();
    }

    @NotNull
    public static List<ITooltipNode> getFunctionsTooltip(IServerUtils utils, List<class_117> functions) {
        if (!functions.isEmpty()) {
            ArrayList<ITooltipNode> tooltip = new ArrayList<ITooltipNode>();
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.util.advanced_loot_info.delimiter.functions", new Object[0])));
            tooltip.addAll(GenericTooltipUtils.getFunctionListTooltip(utils, functions));
            return tooltip;
        }
        return Collections.emptyList();
    }

    public static @Unmodifiable @NotNull ITooltipNode getFormulaTooltip(IServerUtils utils, String key, class_94.class_96 formula) {
        ITooltipNode tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, key, formula.method_466().comp_1850());
        if (formula instanceof class_94.class_95) {
            class_94.class_95 binomialWithBonusCount = (class_94.class_95)formula;
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.extra_rounds", binomialWithBonusCount.comp_1848()));
            tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.probability", Float.valueOf(binomialWithBonusCount.comp_1849())));
        } else if (formula instanceof class_94.class_100) {
            class_94.class_100 uniformBonusCount = (class_94.class_100)formula;
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.bonus_multiplier", uniformBonusCount.comp_1852()));
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getPropertyTooltip(IServerUtils utils, String key, class_2769<?> property) {
        return GenericTooltipUtils.getStringTooltip(utils, key, property.method_11899());
    }

    @NotNull
    public static ITooltipNode getModifierTooltip(IServerUtils utils, String key, class_137.class_138 modifier) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.name", modifier.comp_1859()));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.attribute", modifier.comp_1860(), RegistriesTooltipUtils::getAttributeTooltip));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.operation", modifier.comp_1861()));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.amount", modifier.comp_1862()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.uuid", modifier.comp_1864(), GenericTooltipUtils::getUUIDTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.equipment_slots", "ali.property.value.null", modifier.comp_1863(), GenericTooltipUtils::getEnumTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getUUIDTooltip(IServerUtils utils, String key, UUID uuid) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.uuid", GenericTooltipUtils.value(uuid)));
    }

    @NotNull
    public static ITooltipNode getBannerPatternsTooltip(IServerUtils utils, String key, Pair<class_6880<class_2582>, class_1767> pair) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, (class_6880)pair.getFirst(), RegistriesTooltipUtils::getBannerPatternTooltip);
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.color", (Enum)pair.getSecond()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getStatePropertiesPredicateTooltip(IServerUtils utils, String key, class_4559 propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, key, propertiesPredicate.comp_1830(), GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, class_4559.class_4562 propertyMatcher) {
        String name = propertyMatcher.comp_1832();
        class_4559.class_8750 class_87502 = propertyMatcher.comp_1833();
        if (class_87502 instanceof class_4559.class_4561) {
            class_4559.class_4561 matcher = (class_4559.class_4561)class_87502;
            return new TooltipNode(GenericTooltipUtils.keyValue(name, matcher.comp_1831()));
        }
        class_87502 = propertyMatcher.comp_1833();
        if (class_87502 instanceof class_4559.class_4563) {
            class_4559.class_4563 matcher = (class_4559.class_4563)class_87502;
            Optional min = matcher.comp_1834();
            Optional max = matcher.comp_1835();
            return min.map(s -> max.map(string -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_both", name, s, string)))).orElseGet(() -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_gte", name, s))))).orElseGet(() -> max.map(string -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_lte", name, string)))).orElseGet(() -> new TooltipNode(GenericTooltipUtils.value(GenericTooltipUtils.translatable("ali.property.value.ranged_property_any", name)))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getDamageSourcePredicateTooltip(IServerUtils utils, String key, class_2022 damagePredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.tags", "ali.property.value.null", damagePredicate.comp_1740(), GenericTooltipUtils::getTagPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.direct_entity", damagePredicate.comp_1741(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.source_entity", damagePredicate.comp_1742(), GenericTooltipUtils::getEntityPredicateTooltip));
        return tooltip;
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getTagPredicateTooltip(IServerUtils utils, String key, class_8129<T> tagPredicate) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.keyValue(tagPredicate.comp_1836().comp_327().toString(), tagPredicate.comp_1837())));
    }

    @NotNull
    public static ITooltipNode getEntityPredicateTooltip(IServerUtils utils, String key, class_2048 entityPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_types", entityPredicate.comp_1761(), GenericTooltipUtils::getEntityTypePredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.distance_to_player", entityPredicate.comp_1762(), GenericTooltipUtils::getDistancePredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.location", entityPredicate.comp_1763(), GenericTooltipUtils::getLocationPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.stepping_on_location", entityPredicate.comp_1764(), GenericTooltipUtils::getLocationPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.mob_effects", entityPredicate.comp_1765(), GenericTooltipUtils::getMobEffectPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.nbt", entityPredicate.comp_1766(), GenericTooltipUtils::getNbtPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_flags", entityPredicate.comp_1767(), GenericTooltipUtils::getEntityFlagsPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_equipment", entityPredicate.comp_1768(), GenericTooltipUtils::getEntityEquipmentPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.entity_sub_predicate", entityPredicate.comp_1769(), GenericTooltipUtils::getEntitySubPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.vehicle", entityPredicate.comp_1770(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.passenger", entityPredicate.comp_1771(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.targeted_entity", entityPredicate.comp_1772(), GenericTooltipUtils::getEntityPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.team", entityPredicate.comp_1773(), GenericTooltipUtils::getStringTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityTypePredicateTooltip(IServerUtils utils, String key, class_2050 entityTypePredicate) {
        return GenericTooltipUtils.getHolderSetTooltip(utils, key, "ali.property.value.null", entityTypePredicate.comp_1775(), RegistriesTooltipUtils::getEntityTypeTooltip);
    }

    @NotNull
    public static ITooltipNode getDistancePredicateTooltip(IServerUtils utils, String key, class_2025 distancePredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", distancePredicate.comp_1743()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", distancePredicate.comp_1744()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", distancePredicate.comp_1745()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.horizontal", distancePredicate.comp_1746()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.absolute", distancePredicate.comp_1747()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLocationPredicateTooltip(IServerUtils utils, String key, class_2090 locationPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.position", locationPredicate.comp_1794(), GenericTooltipUtils::getPositionPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.biome", locationPredicate.comp_1795(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.structure", locationPredicate.comp_1796(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.dimension", locationPredicate.comp_1797(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.smokey", locationPredicate.comp_1798(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.light", locationPredicate.comp_1799(), GenericTooltipUtils::getLightPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.block_predicate", locationPredicate.comp_1800(), GenericTooltipUtils::getBlockPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.fluid_predicate", locationPredicate.comp_1801(), GenericTooltipUtils::getFluidPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getPositionPredicateTooltip(IServerUtils utils, String key, class_2090.class_8747 positionPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.x", positionPredicate.comp_1802()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.y", positionPredicate.comp_1803()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.z", positionPredicate.comp_1804()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLightPredicateTooltip(IServerUtils utils, String key, class_4552 lightPredicate) {
        return GenericTooltipUtils.getMinMaxBoundsTooltip(utils, key, lightPredicate.comp_1791());
    }

    @NotNull
    public static ITooltipNode getBlockPredicateTooltip(IServerUtils utils, String key, class_4550 blockPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", blockPredicate.comp_1731(), GenericTooltipUtils::getTagKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.blocks", "ali.property.value.null", blockPredicate.comp_1732(), RegistriesTooltipUtils::getBlockTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.properties", blockPredicate.comp_1733(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.nbt", blockPredicate.comp_1734(), GenericTooltipUtils::getNbtPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getNbtPredicateTooltip(IServerUtils utils, String key, class_2105 nbtPredicate) {
        return GenericTooltipUtils.getCompoundTagTooltip(utils, key, nbtPredicate.comp_1816());
    }

    @NotNull
    public static ITooltipNode getFluidPredicateTooltip(IServerUtils utils, String key, class_4551 fluidPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", fluidPredicate.comp_1780(), GenericTooltipUtils::getTagKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderTooltip(utils, "ali.property.value.fluid", fluidPredicate.comp_1781(), RegistriesTooltipUtils::getFluidTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.properties", fluidPredicate.comp_1782(), GenericTooltipUtils::getStatePropertiesPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateTooltip(IServerUtils utils, String key, class_2102 mobEffectsPredicate) {
        return GenericTooltipUtils.getMapTooltip(utils, key, mobEffectsPredicate.comp_1811(), GenericTooltipUtils::getMobEffectPredicateEntryTooltip);
    }

    @NotNull
    public static ITooltipNode getEntityFlagsPredicateTooltip(IServerUtils utils, String key, class_2040 predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_on_fire", predicate.comp_1756(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_baby", predicate.comp_1760(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_crouching", predicate.comp_1757(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_sprinting", predicate.comp_1758(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_swimming", predicate.comp_1759(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityEquipmentPredicateTooltip(IServerUtils utils, String key, class_3735 predicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.head", predicate.comp_1750(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.chest", predicate.comp_1751(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.legs", predicate.comp_1752(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.feet", predicate.comp_1753(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.mainhand", predicate.comp_1754(), GenericTooltipUtils::getItemPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.offhand", predicate.comp_1755(), GenericTooltipUtils::getItemPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getItemPredicateTooltip(IServerUtils utils, String key, class_2073 itemPredicate) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", itemPredicate.comp_1783(), GenericTooltipUtils::getTagKeyTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderSetTooltip(utils, "ali.property.branch.items", "ali.property.value.null", itemPredicate.comp_1784(), RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.count", itemPredicate.comp_1785()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.durability", itemPredicate.comp_1786()));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.enchantments", "ali.property.value.null", itemPredicate.comp_1787(), GenericTooltipUtils::getEnchantmentPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.stored_enchantments", "ali.property.value.null", itemPredicate.comp_1788(), GenericTooltipUtils::getEnchantmentPredicateTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalHolderTooltip(utils, "ali.property.value.potion", itemPredicate.comp_1789(), RegistriesTooltipUtils::getPotionTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.nbt", itemPredicate.comp_1790(), GenericTooltipUtils::getNbtPredicateTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantmentPredicateTooltip(IServerUtils utils, String key, class_2035 enchantmentPredicate) {
        ITooltipNode tooltip = enchantmentPredicate.comp_1748().isPresent() ? GenericTooltipUtils.getHolderTooltip(utils, key, (class_6880)enchantmentPredicate.comp_1748().get(), RegistriesTooltipUtils::getEnchantmentTooltip) : new TooltipNode();
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", enchantmentPredicate.comp_1749()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntitySubPredicateTooltip(IServerUtils utils, String key, class_7376 entitySubPredicate) {
        Optional<Map.Entry> optional = class_7376.class_7378.field_38731.entrySet().stream().filter(p -> p.getValue() == entitySubPredicate.comp_1776()).findFirst();
        return optional.map(entry -> {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, entry.getKey()));
            if (entitySubPredicate instanceof class_6404) {
                class_6404 predicate = (class_6404)entitySubPredicate;
                tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.blocks_on_fire", predicate.comp_1792()));
                tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.stuck_entity", predicate.comp_1793(), GenericTooltipUtils::getEntityPredicateTooltip));
            } else if (entitySubPredicate instanceof class_4965) {
                class_4965 predicate = (class_4965)entitySubPredicate;
                tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.in_open_water", predicate.comp_1779(), GenericTooltipUtils::getBooleanTooltip));
            } else if (entitySubPredicate instanceof class_4553) {
                class_4553 predicate = (class_4553)entitySubPredicate;
                tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.level", predicate.comp_1817()));
                tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.game_type", predicate.comp_1818(), GenericTooltipUtils::getEnumTooltip));
                tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.stats", predicate.comp_1819(), GenericTooltipUtils::getStatMatcherTooltip));
                tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.recipes", predicate.comp_1820(), GenericTooltipUtils::getRecipeEntryTooltip));
                tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.advancements", predicate.comp_1821(), GenericTooltipUtils::getAdvancementEntryTooltip));
                tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.branch.looking_at", predicate.comp_1822(), GenericTooltipUtils::getEntityPredicateTooltip));
            } else if (entitySubPredicate instanceof class_7383) {
                class_7383 predicate = (class_7383)entitySubPredicate;
                tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.size", predicate.comp_1829()));
            } else {
                class_7376.field_45747.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entitySubPredicate).result().ifPresent(element -> {
                    JsonObject jsonObject = element.getAsJsonObject();
                    if (jsonObject.has("variant")) {
                        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.variant", jsonObject.getAsJsonPrimitive("variant").getAsString())));
                    } else {
                        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.variant", jsonObject.toString())));
                    }
                });
            }
            return tooltip;
        }).orElse(new TooltipNode());
    }

    @NotNull
    public static ITooltipNode getStatMatcherTooltip(IServerUtils utils, class_4553.class_8749<?> stat) {
        ITooltipNode tooltip;
        class_6880 value = stat.comp_1826();
        Object object = value.comp_349();
        if (object instanceof class_1792) {
            class_1792 item = (class_1792)object;
            tooltip = RegistriesTooltipUtils.getItemTooltip(utils, "ali.property.value.item", item);
            tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.comp_1825().method_30739(), GenericTooltipUtils.toString(stat.comp_1827()))));
        } else {
            object = value.comp_349();
            if (object instanceof class_2248) {
                class_2248 block = (class_2248)object;
                tooltip = RegistriesTooltipUtils.getBlockTooltip(utils, "ali.property.value.block", block);
                tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.comp_1825().method_30739(), GenericTooltipUtils.toString(stat.comp_1827()))));
            } else {
                object = value.comp_349();
                if (object instanceof class_1299) {
                    class_1299 entityType = (class_1299)object;
                    tooltip = RegistriesTooltipUtils.getEntityTypeTooltip(utils, "ali.property.value.entity_type", entityType);
                    tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(stat.comp_1825().method_30739(), GenericTooltipUtils.toString(stat.comp_1827()))));
                } else {
                    object = value.comp_349();
                    if (object instanceof class_2960) {
                        class_2960 resourceLocation = (class_2960)object;
                        tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.id", resourceLocation);
                        tooltip.add(new TooltipNode(GenericTooltipUtils.keyValue(GenericTooltipUtils.translatable(GenericTooltipUtils.getTranslationKey(resourceLocation), new Object[0]), GenericTooltipUtils.toString(stat.comp_1827()))));
                    } else {
                        tooltip = new TooltipNode();
                    }
                }
            }
        }
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getBlockPosTooltip(IServerUtils ignoredUtils, String key, class_2338 pos) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(pos.method_10263()), GenericTooltipUtils.value(pos.method_10264()), GenericTooltipUtils.value(pos.method_10260())));
    }

    @NotNull
    public static ITooltipNode getCopyOperationTooltip(IServerUtils utils, String key, class_3837.class_3839 copyOperation) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.source", copyOperation.comp_1853().comp_1856()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.target", copyOperation.comp_1854().comp_1856()));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.merge_strategy", copyOperation.comp_1855()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEffectEntryTooltip(IServerUtils utils, String key, class_152.class_8754 entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, key, entry.comp_1865(), RegistriesTooltipUtils::getMobEffectTooltip);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.duration", entry.comp_1866()));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getCompoundTagTooltip(IServerUtils ignoredUtils, String key, class_2487 tag) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(tag.toString())));
    }

    @NotNull
    public static ITooltipNode getAdvancementPredicateTooltip(IServerUtils utils, String key, class_4553.class_4556 predicate) {
        if (predicate instanceof class_4553.class_4555) {
            class_4553.class_4555 donePredicate = (class_4553.class_4555)predicate;
            return new TooltipNode(GenericTooltipUtils.translatable(key, donePredicate.comp_1824()));
        }
        if (predicate instanceof class_4553.class_4554) {
            class_4553.class_4554 criterionsPredicate = (class_4553.class_4554)predicate;
            return GenericTooltipUtils.getMapTooltip(utils, criterionsPredicate.comp_1823(), GenericTooltipUtils::getCriterionEntryTooltip);
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getItemStackTooltip(IServerUtils utils, String key, class_1799 item) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
        tooltip.add(RegistriesTooltipUtils.getItemTooltip(utils, "ali.property.value.item", item.method_7909()));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.count", item.method_7947()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.tag", Optional.ofNullable(item.method_7969()), GenericTooltipUtils::getCompoundTagTooltip));
        return tooltip;
    }

    @NotNull
    public static class_2561 translatable(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])Arrays.stream(args).map(GenericTooltipUtils::convertObject).toArray()).method_27692(TEXT_STYLE);
    }

    @NotNull
    public static class_2561 value(Object value) {
        return GenericTooltipUtils.convertObject(value).method_27695(new class_124[]{PARAM_STYLE, class_124.field_1067});
    }

    @NotNull
    public static class_2561 value(Object value, String unit) {
        return class_2561.method_43469((String)"ali.util.advanced_loot_info.two_values", (Object[])new Object[]{GenericTooltipUtils.convertObject(value), unit}).method_27695(new class_124[]{PARAM_STYLE, class_124.field_1067});
    }

    @NotNull
    public static class_2561 pair(Object value1, Object value2) {
        return class_2561.method_43469((String)"ali.util.advanced_loot_info.two_values_with_space", (Object[])new Object[]{GenericTooltipUtils.convertObject(value1), GenericTooltipUtils.convertObject(value2)});
    }

    @NotNull
    public static class_2561 pad(int count, Object arg) {
        if (count > 0) {
            return GenericTooltipUtils.pair(class_2561.method_43471((String)("ali.util.advanced_loot_info.pad." + count)), GenericTooltipUtils.convertObject(arg));
        }
        return GenericTooltipUtils.convertObject(arg);
    }

    @NotNull
    public static class_2561 keyValue(Object key, Object value) {
        return GenericTooltipUtils.translatable("ali.util.advanced_loot_info.key_value", GenericTooltipUtils.convertObject(key), GenericTooltipUtils.value(value));
    }

    public static @Unmodifiable @NotNull ITooltipNode getNumberProviderTooltip(IServerUtils utils, String key, class_5658 value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(utils.convertNumber(utils, value))));
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntRangeTooltip(IServerUtils utils, String key, class_42 range) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(RangeValue.rangeToString(utils.convertNumber(utils, range.field_921), utils.convertNumber(utils, range.field_920)))));
    }

    public static @Unmodifiable @NotNull ITooltipNode getBooleanTooltip(IServerUtils utils, String key, Boolean value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getIntegerTooltip(IServerUtils ignoredUtils, String key, int value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getLongTooltip(IServerUtils ignoredUtils, String key, Long value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getStringTooltip(IServerUtils utils, String key, String value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getFloatTooltip(IServerUtils ignoredUtils, String key, Float value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getDoubleTooltip(IServerUtils ignoredUtils, String key, Double value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static @Unmodifiable @NotNull ITooltipNode getEnumTooltip(IServerUtils ignoredUtils, String key, Enum<?> value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.name())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getResourceLocationTooltip(IServerUtils ignoredUtils, String key, class_2960 value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value)));
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getBuiltInRegistryTooltip(IServerUtils utils, String key, class_2378<T> registry, T value) {
        return GenericTooltipUtils.getOptionalTooltip(utils, key, Optional.ofNullable(registry.method_10221(value)), GenericTooltipUtils::getResourceLocationTooltip);
    }

    public static <T> @Unmodifiable @NotNull ITooltipNode getResourceKeyTooltip(IServerUtils utils, String key, class_5321<T> value) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(value.method_29177())));
    }

    public static @Unmodifiable @NotNull ITooltipNode getTagKeyTooltip(IServerUtils utils, String key, class_6862<?> value) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, key, value.comp_327());
    }

    public static @Unmodifiable @NotNull ITooltipNode getComponentTooltip(IServerUtils ignoredUtils, String key, class_2561 component) {
        return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(component.method_27661())));
    }

    @NotNull
    public static ITooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, String key, class_2096.class_2100 ints) {
        if (ints != class_2096.class_2100.field_9708) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(ints))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, String key, class_2096.class_2099 doubles) {
        if (doubles != class_2096.class_2099.field_9705) {
            return new TooltipNode(GenericTooltipUtils.translatable(key, GenericTooltipUtils.value(GenericTooltipUtils.toString(doubles))));
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getOptionalTooltip(IServerUtils utils, String key, Optional<T> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(value -> (ITooltipNode)mapper.apply((Object)utils, (Object)key, value)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getOptionalHolderTooltip(IServerUtils utils, String key, Optional<class_6880<T>> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(holder -> GenericTooltipUtils.getHolderTooltip(utils, key, holder, mapper)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getOptionalHolderSetTooltip(IServerUtils utils, String key, String value, Optional<class_6885<T>> optional, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return optional.map(holderSet -> GenericTooltipUtils.getHolderSetTooltip(utils, key, value, holderSet, mapper)).orElse(new TooltipNode());
    }

    @NotNull
    public static <T> ITooltipNode getHolderTooltip(IServerUtils utils, String key, class_6880<T> holder, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        return (ITooltipNode)mapper.apply((Object)utils, (Object)key, holder.comp_349());
    }

    @NotNull
    public static <T> ITooltipNode getHolderSetTooltip(IServerUtils utils, String key, String value, class_6885<T> holderSet, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        Either either = holderSet.method_40248();
        Optional left = either.left();
        Optional right = either.right();
        TooltipNode tooltip = left.isPresent() || !right.orElse(List.of()).isEmpty() ? new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0])) : new TooltipNode();
        left.ifPresent(tagKey -> tooltip.add(GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.tag", tagKey)));
        right.ifPresent(list -> {
            if (!list.isEmpty()) {
                holderSet.forEach(holder -> tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, value, holder, mapper)));
            }
        });
        return tooltip;
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <T> ITooltipNode getCollectionTooltip(IServerUtils utils, String key, String value, Collection<T> values, TriFunction<IServerUtils, String, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.forEach(v -> tooltip.add((ITooltipNode)mapper.apply((Object)utils, (Object)value, v)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <K, V> ITooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static <K, V> ITooltipNode getMapTooltip(IServerUtils utils, String key, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable(key, new Object[0]));
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return new TooltipNode();
    }

    public static @Unmodifiable @NotNull ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<class_2960, Boolean> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    public static @Unmodifiable @NotNull ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return new TooltipNode(GenericTooltipUtils.keyValue(entry.getKey(), entry.getValue()));
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, class_42> entry) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.value(entry.getKey()));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.limit", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<class_6880<class_1291>, class_2102.class_2103> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.null", entry.getKey(), RegistriesTooltipUtils::getMobEffectTooltip);
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.amplifier", entry.getValue().comp_1812()));
        tooltip.add(GenericTooltipUtils.getMinMaxBoundsTooltip(utils, "ali.property.value.duration", entry.getValue().comp_1813()));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_ambient", entry.getValue().comp_1814(), GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_visible", entry.getValue().comp_1815(), GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<class_6880<class_1887>, class_5658> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.null", entry.getKey(), RegistriesTooltipUtils::getEnchantmentTooltip);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.levels", entry.getValue()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<class_2960, class_4553.class_4556> entry) {
        ITooltipNode tooltip = GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.property.value.null", entry.getKey());
        tooltip.add(GenericTooltipUtils.getAdvancementPredicateTooltip(utils, "ali.property.value.done", entry.getValue()));
        return tooltip;
    }

    @NotNull
    private static String toString(class_2096.class_2099 doubles) {
        Optional min = doubles.comp_1805();
        Optional max = doubles.comp_1806();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    private static String toString(class_2096.class_2100 ints) {
        Optional min = ints.comp_1805();
        Optional max = ints.comp_1806();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min, max)) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static class_5250 convertObject(@Nullable Object object) {
        if (object instanceof class_5250) {
            class_5250 component = (class_5250)object;
            return component;
        }
        if (object != null) {
            return class_2561.method_43470((String)object.toString());
        }
        return class_2561.method_43470((String)"null");
    }

    @NotNull
    private static String getTranslationKey(class_2960 location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

