/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.registries;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.yanny.ali.registries.GameplayLootCategory;
import com.yanny.ali.registries.LootCategory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LootCategories {
    public static final Map<class_2960, LootCategory<class_2248>> BLOCK_LOOT_CATEGORIES = new HashMap<class_2960, LootCategory<class_2248>>();
    public static final Map<class_2960, LootCategory<class_1299<?>>> ENTITY_LOOT_CATEGORIES = new HashMap();
    public static final Map<class_2960, LootCategory<String>> GAMEPLAY_LOOT_CATEGORIES = new HashMap<class_2960, LootCategory<String>>();
    public static final Map<class_2960, LootCategory<String>> TRADE_LOOT_CATEGORIES = new HashMap<class_2960, LootCategory<String>>();
    public static final LootCategory<class_2248> PLANT_LOOT = LootCategories.getBlockCategory("plant_loot", class_1802.field_8527, block -> block instanceof class_2261);
    public static final LootCategory<class_2248> BLOCK_LOOT = LootCategories.getBlockCategory("block_loot", class_1802.field_8377, block -> true);
    public static final LootCategory<class_1299<?>> ENTITY_LOOT = LootCategories.getEntityCategory("entity_loot", class_1802.field_8398, entity -> true);
    public static final LootCategory<String> TRADE_LOOT = LootCategories.getTradeCategory("trade_loot", class_1802.field_8733, entity -> true);
    public static final LootCategory<String> GAMEPLAY_LOOT = LootCategories.getGameplayCategory(path -> true);
    private static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    private static LootCategory<class_2248> getBlockCategory(String key, class_1792 icon, Predicate<class_2248> validator) {
        return new LootCategory<class_2248>(key, new class_1799((class_1935)icon), LootCategory.Type.BLOCK, validator);
    }

    @NotNull
    private static LootCategory<class_1299<?>> getEntityCategory(String key, class_1792 icon, Predicate<class_1299<?>> validator) {
        return new LootCategory(key, new class_1799((class_1935)icon), LootCategory.Type.ENTITY, validator);
    }

    @NotNull
    private static LootCategory<String> getTradeCategory(String key, class_1792 icon, Predicate<String> validator) {
        return new LootCategory<String>(key, new class_1799((class_1935)icon), LootCategory.Type.TRADE, validator);
    }

    @NotNull
    private static LootCategory<String> getGameplayCategory(Predicate<String> validator) {
        return new GameplayLootCategory("gameplay_loot", new class_1799((class_1935)class_1802.field_8251), LootCategory.Type.GAMEPLAY, validator);
    }

    @NotNull
    private static LootCategory<String> getGameplayCategory(String key, class_1792 icon, List<Pattern> prefix) {
        return new GameplayLootCategory(key, new class_1799((class_1935)icon), LootCategory.Type.GAMEPLAY, prefix);
    }

    @NotNull
    public static class_4309 getReloadListener(Gson gson, String id) {
        return new class_4309(gson, id){

            protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
                BLOCK_LOOT_CATEGORIES.clear();
                ENTITY_LOOT_CATEGORIES.clear();
                GAMEPLAY_LOOT_CATEGORIES.clear();
                TRADE_LOOT_CATEGORIES.clear();
                map.forEach((location, value) -> {
                    try {
                        JsonObject jsonObject = class_3518.method_15295((JsonElement)value, (String)location.toString());
                        LootCategory.Type type = LootCategory.Type.valueOf(class_3518.method_15265((JsonObject)jsonObject, (String)"type"));
                        String key = class_3518.method_15265((JsonObject)jsonObject, (String)"key");
                        class_1792 icon = (class_1792)class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"icon")));
                        switch (type) {
                            case BLOCK: {
                                BLOCK_LOOT_CATEGORIES.put((class_2960)location, LootCategories.getBlockCategory(key, icon, block -> true));
                                break;
                            }
                            case ENTITY: {
                                ENTITY_LOOT_CATEGORIES.put((class_2960)location, LootCategories.getEntityCategory(key, icon, entityType -> true));
                                break;
                            }
                            case TRADE: {
                                TRADE_LOOT_CATEGORIES.put((class_2960)location, LootCategories.getTradeCategory(key, icon, entity -> true));
                                break;
                            }
                            case GAMEPLAY: {
                                GAMEPLAY_LOOT_CATEGORIES.put((class_2960)location, LootCategories.getGameplayCategory(key, icon, class_3518.method_15261((JsonObject)jsonObject, (String)"prefix").asList().stream().map(JsonElement::getAsString).map(Pattern::compile).toList()));
                            }
                        }
                        LOGGER.info("Loaded LootCategory resource: {}", location);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load LootCategory resource: {}", location, (Object)e);
                    }
                });
            }
        };
    }
}

