/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.rei;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiWidgetWrapper;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import com.yanny.ali.plugin.common.NodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public abstract class ReiBaseCategory<T extends ReiBaseDisplay, U>
implements DisplayCategory<T> {
    static final int CATEGORY_WIDTH = 162;
    static final int CATEGORY_HEIGHT = 144;
    static final int PADDING = 4;
    static final int ITEM_SIZE = 16;
    static final int SLOT_SIZE = 18;
    static final int OUT_SLOT_SIZE = 26;
    static final int SLOT_OFFSET = 1;
    static final int OUT_SLOT_OFFSET = 5;
    private final LootCategory<U> lootCategory;

    public ReiBaseCategory(LootCategory<U> lootCategory) {
        this.lootCategory = lootCategory;
    }

    public abstract List<Widget> setupDisplay(T var1, Rectangle var2);

    public int getDisplayWidth(T display) {
        return 162;
    }

    public int getDisplayHeight() {
        return 144;
    }

    public LootCategory<U> getLootCategory() {
        return this.lootCategory;
    }

    protected WidgetHolder getBaseWidget(T display, Rectangle bounds, int y) {
        LinkedList<Holder> slotWidgets = new LinkedList<Holder>();
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        RelativeRect rect = new RelativeRect(0, y, 162, 0);
        LootTableWidget widget = new LootTableWidget(this.getUtils(slotWidgets), ((ReiBaseDisplay)((Object)display)).getLootData(), rect, 162);
        ReiWidgetWrapper widgetWrapper = new ReiWidgetWrapper(widget);
        widgets.add(Widgets.createTooltip(widgetWrapper::getTooltip));
        widgets.add((Widget)widgetWrapper);
        slotWidgets.forEach(h -> {
            Optional left = h.item.left();
            Optional right = h.item.right();
            if (left.isPresent()) {
                class_1799 itemStack = (class_1799)left.get();
                EntryStack stack2 = EntryStacks.of((class_1799)itemStack);
                stack2.tooltip(NodeUtils.toComponents(h.entry.getTooltip(), 0, class_310.method_1551().field_1690.field_1827));
                widgets.add((Widget)Widgets.createSlot((Point)new Point(h.rect.getX() + bounds.getX() + 1, h.rect.getY() + bounds.getY() + 1)).entry(stack2).markOutput());
            } else if (right.isPresent()) {
                class_6862 tagKey = (class_6862)right.get();
                EntryIngredient ingredient = EntryIngredients.ofItemTag((class_6862)tagKey);
                ingredient.map(stack -> stack.tooltip(NodeUtils.toComponents(h.entry.getTooltip(), 0, class_310.method_1551().field_1690.field_1827)));
                widgets.add((Widget)Widgets.createSlot((Point)new Point(h.rect.getX() + bounds.getX() + 1, h.rect.getY() + bounds.getY() + 1)).entries((Collection)ingredient).markOutput());
            }
            widgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(h.rect.getX() + bounds.getX(), h.rect.getY() + bounds.getY(), 18, 18), (Renderer)new SlotCountRenderer(((IItemNode)((Object)h.entry)).getCount())));
        });
        return new WidgetHolder(widgets, widget.getRect());
    }

    @NotNull
    private IWidgetUtils getUtils(final List<Holder> widgets) {
        return new ClientUtils(this){

            @Override
            public void addSlotWidget(Either<class_1799, class_6862<? extends class_1935>> item, IDataNode entry, RelativeRect rect) {
                widgets.add(new Holder(item, entry, rect));
            }
        };
    }

    protected record WidgetHolder(List<Widget> widgets, RelativeRect bounds) {
    }

    private record Holder(Either<class_1799, class_6862<? extends class_1935>> item, IDataNode entry, RelativeRect rect) {
    }

    private static class SlotCountRenderer
    implements Renderer {
        @Nullable
        private class_2561 count;
        private boolean isRange = false;

        public SlotCountRenderer(RangeValue count) {
            if (count.isRange() || count.min() > 1.0f) {
                this.count = class_2561.method_43470((String)count.toIntString());
                this.isRange = count.isRange();
            }
        }

        public void render(class_332 guiGraphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (this.count != null) {
                class_327 font = class_310.method_1551().field_1772;
                Matrix3x2fStack stack = guiGraphics.method_51448();
                stack.pushMatrix();
                stack.translate((float)bounds.getX(), (float)bounds.getY());
                if (this.isRange) {
                    stack.translate(17.0f, 13.0f);
                    stack.pushMatrix();
                    stack.scale(0.5f);
                    guiGraphics.method_51439(font, this.count, -font.method_27525((class_5348)this.count), 0, -1, false);
                    stack.popMatrix();
                } else {
                    stack.translate(18.0f, 10.0f);
                    guiGraphics.method_51439(font, this.count, -font.method_27525((class_5348)this.count), 0, -1, true);
                }
                stack.popMatrix();
            }
        }
    }
}

