/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.trades;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.server.DataComponentTooltipUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class TradeUtils {
    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, MerchantOffer offer, List<ITooltipNode> conditions) {
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)offer.getBaseCostA()), new RangeValue(offer.getBaseCostA().getCount()), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)offer.getCostB()), new RangeValue(offer.getCostB().getCount()), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)offer.getResult()), new RangeValue(offer.getResult().getCount()), offer.getMaxUses(), offer.getXp(), offer.getPriceMultiplier(), conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.DyedArmorForEmeralds listing, List<ITooltipNode> conditions) {
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(listing.value), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)ItemStack.EMPTY), new RangeValue(), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)listing.item.getDefaultInstance()), new RangeValue(), Collections.singletonList(new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.dyed_randomly", new Object[0]))), listing.maxUses, listing.villagerXp, 0.2f, conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.EmeraldForItems listing, List<ITooltipNode> conditions) {
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)listing.itemStack.itemStack()), new RangeValue(listing.itemStack.count()), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(), listing.maxUses, listing.villagerXp, listing.priceMultiplier, conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.EnchantBookForEmeralds listing, List<ITooltipNode> conditions) {
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(5.0f, 64.0f), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)ItemStack.EMPTY), new RangeValue(), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.ENCHANTED_BOOK.getDefaultInstance()), new RangeValue(), Collections.singletonList(new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.enchant_randomly", new Object[0]))), 12, listing.villagerXp, 0.2f, conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.EnchantedItemForEmeralds listing, List<ITooltipNode> conditions) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.enchant_with_levels", new Object[0]));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.levels", (NumberProvider)UniformGenerator.between((float)5.0f, (float)19.0f)));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.treasure", false));
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(listing.baseEmeraldCost + 5, listing.baseEmeraldCost + 19), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)ItemStack.EMPTY), new RangeValue(), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)listing.itemStack), new RangeValue(), Collections.singletonList(tooltip), listing.maxUses, listing.villagerXp, listing.priceMultiplier, conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.ItemsAndEmeraldsToItems listing, List<ITooltipNode> conditions) {
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)listing.fromItem.itemStack()), new RangeValue(listing.fromItem.count()), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(listing.emeraldCost), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)listing.toItem), new RangeValue(listing.toItem.getCount()), listing.maxUses, listing.villagerXp, listing.priceMultiplier, conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.ItemsForEmeralds listing, List<ITooltipNode> conditions) {
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(listing.emeraldCost), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)listing.itemStack), new RangeValue(listing.itemStack.getCount()), listing.maxUses, listing.villagerXp, listing.priceMultiplier, conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.SuspiciousStewForEmerald listing, List<ITooltipNode> conditions) {
        ItemStack stew = Items.SUSPICIOUS_STEW.getDefaultInstance();
        stew.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)listing.effects);
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)ItemStack.EMPTY), new RangeValue(), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)stew), new RangeValue(), List.of(DataComponentTooltipUtils.getSuspiciousStewEffectsTooltip(utils, listing.effects)), 12, listing.xp, listing.priceMultiplier, conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.TippedArrowForItemsAndEmeralds listing, List<ITooltipNode> conditions) {
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)listing.fromItem.getDefaultInstance()), new RangeValue(listing.fromCount), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(listing.emeraldCost), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)listing.toItem), new RangeValue(listing.toCount), listing.maxUses, listing.villagerXp, listing.priceMultiplier, conditions);
    }

    @NotNull
    public static ItemsToItemsNode getNode(IServerUtils utils, VillagerTrades.TreasureMapForEmeralds listing, List<ITooltipNode> conditions) {
        ItemStack map = Items.MAP.getDefaultInstance();
        map.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)listing.displayName));
        return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(listing.emeraldCost), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.COMPASS.getDefaultInstance()), new RangeValue(), Collections.emptyList(), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)map), new RangeValue(), List.of(GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.destination", listing.destination), GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.map_decoration", listing.destinationType, RegistriesTooltipUtils::getMapDecorationTypeTooltip)), listing.maxUses, listing.villagerXp, 0.2f, conditions);
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, MerchantOffer offer) {
        return new Pair(List.of(offer.getBaseCostA().getItem(), offer.getCostB().getItem()), List.of(offer.getResult().getItem()));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.DyedArmorForEmeralds listing) {
        return new Pair(List.of(Items.EMERALD), List.of(listing.item));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.EmeraldForItems listing) {
        return new Pair(List.of(listing.itemStack.itemStack().getItem()), List.of(Items.EMERALD));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.EnchantBookForEmeralds ignoredListing) {
        return new Pair(List.of(Items.EMERALD), List.of(Items.ENCHANTED_BOOK));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.EnchantedItemForEmeralds listing) {
        return new Pair(List.of(Items.EMERALD), List.of(listing.itemStack.getItem()));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.ItemsAndEmeraldsToItems listing) {
        return new Pair(List.of(Items.EMERALD, listing.fromItem.itemStack().getItem()), List.of(listing.toItem.getItem()));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.ItemsForEmeralds listing) {
        return new Pair(List.of(Items.EMERALD), List.of(listing.itemStack.getItem()));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.SuspiciousStewForEmerald ignoredListing) {
        return new Pair(List.of(Items.EMERALD), List.of(Items.SUSPICIOUS_STEW));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.TippedArrowForItemsAndEmeralds listing) {
        return new Pair(List.of(Items.EMERALD, listing.fromItem), List.of(Items.TIPPED_ARROW));
    }

    @NotNull
    public static Pair<List<Item>, List<Item>> collectItems(IServerUtils ignoredUtils, VillagerTrades.TreasureMapForEmeralds ignoredListing) {
        return new Pair(List.of(Items.EMERALD, Items.COMPASS), List.of(Items.MAP));
    }
}

