/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.tooltip;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

public class LiteralTooltipNode
implements ITooltipNode {
    public static final class_2960 ID = new class_2960("ali", "literal");
    private static final LoadingCache<String, LiteralTooltipNode> CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(data -> data != null ? new LiteralTooltipNode((String)data) : null));
    private final String text;

    private LiteralTooltipNode(String text) {
        this.text = text;
    }

    @Override
    public void encode(IServerUtils utils, class_9129 buf) {
        buf.method_10814(this.text);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public List<class_2561> getComponents(int pad, boolean showAdvancedTooltip) {
        return Collections.singletonList(ITooltipNode.pad(pad, class_2561.method_43471((String)this.text).method_27692(TEXT_STYLE)));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralTooltipNode that = (LiteralTooltipNode)o;
        return Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hashCode(this.text);
    }

    public String toString() {
        return "LiteralTooltipNode{text='" + this.text + "'}";
    }

    @NotNull
    public static LiteralTooltipNode translatable(String text) {
        try {
            return (LiteralTooltipNode)CACHE.get((Object)text);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static LiteralTooltipNode decode(IClientUtils ignoredUtils, class_9129 buf) {
        String text = buf.method_19772();
        try {
            return (LiteralTooltipNode)CACHE.get((Object)text);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

