/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.tooltip;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ListTooltipNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

public class ValueTooltipNode
extends ListTooltipNode
implements ITooltipNode {
    public static final class_2960 ID = new class_2960("ali", "value");
    private static final LoadingCache<CacheKey, ValueTooltipNode> CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(data -> data != null ? new ValueTooltipNode((CacheKey)data) : null));
    private final List<String> values;
    private final boolean isKeyValue;
    private final boolean translateKey;
    private final String key;

    private ValueTooltipNode(CacheKey cacheKey) {
        super(cacheKey.children);
        this.key = cacheKey.key;
        this.values = cacheKey.values;
        this.isKeyValue = cacheKey.isKeyValue;
        this.translateKey = cacheKey.translateKey;
    }

    @Override
    public void encodeNode(class_9129 buf) {
        buf.method_53002(this.values.size());
        for (String value : this.values) {
            buf.method_10814(value);
        }
        buf.method_52964(this.isKeyValue);
        buf.method_52964(this.translateKey);
        buf.method_10814(this.key);
    }

    @Override
    public List<class_2561> getComponents(int pad, boolean showAdvancedTooltip) {
        if (this.key == null) {
            throw new IllegalStateException("Key was not set! values:" + String.valueOf(this.values));
        }
        List<class_2561> children = super.getComponents(pad + 1, showAdvancedTooltip);
        ArrayList<class_2561> components = new ArrayList<class_2561>(children.size() + 1);
        if (this.isKeyValue) {
            class_2561 k = ValueTooltipNode.transform(this.values.get(0));
            class_2561 value = ValueTooltipNode.transform(this.values.get(1));
            class_5250 keyValue = class_2561.method_43469((String)"ali.util.advanced_loot_info.key_value", (Object[])new Object[]{k, value}).method_27692(PARAM_STYLE);
            components.add(ITooltipNode.pad(pad, class_2561.method_43469((String)this.key, (Object[])new Object[]{keyValue}).method_27692(TEXT_STYLE)));
        } else {
            Object[] val = this.values.stream().map(ValueTooltipNode::transform).toArray();
            if (this.translateKey) {
                components.add(ITooltipNode.pad(pad, class_2561.method_43469((String)this.key, (Object[])val).method_27692(TEXT_STYLE)));
            } else {
                components.add(ITooltipNode.pad(pad, class_2561.method_43469((String)"ali.util.advanced_loot_info.key_value", (Object[])new Object[]{this.key, val[0]}).method_27692(TEXT_STYLE)));
            }
        }
        components.addAll(children);
        return components;
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueTooltipNode that = (ValueTooltipNode)o;
        return this.isKeyValue == that.isKeyValue && this.translateKey == that.translateKey && Objects.equals(this.values, that.values) && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.values, this.isKeyValue, this.key, this.translateKey);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    public String toString() {
        return "ValueTooltipNode{key='" + this.key + "', values=" + String.valueOf(this.values) + ", isKeyValue=" + this.isKeyValue + ", translateKey=" + this.translateKey + ", children=" + String.valueOf(this.getChildren()) + "}";
    }

    @NotNull
    public static Builder value(Object ... objects) {
        List<String> values;
        if (objects.length == 1) {
            values = Collections.singletonList(objects[0].toString());
        } else {
            values = new ArrayList<String>(objects.length);
            for (Object value : objects) {
                values.add(value.toString());
            }
        }
        return new Builder(values);
    }

    @NotNull
    public static Builder keyValue(Object key, Object value) {
        return new Builder(key.toString(), value.toString());
    }

    @NotNull
    public static String translate(String key) {
        return "\ue000" + key;
    }

    @NotNull
    private static class_2561 transform(String v) {
        if (v.charAt(0) == '\ue000') {
            return class_2561.method_43471((String)v.substring(1)).method_27692(PARAM_STYLE);
        }
        return class_2561.method_43470((String)v).method_27692(PARAM_STYLE);
    }

    public static ValueTooltipNode decode(IClientUtils utils, class_9129 buf) {
        List<String> values;
        List<ITooltipNode> children = ListTooltipNode.decodeChildren(utils, buf);
        int size = buf.readInt();
        if (size == 1) {
            values = Collections.singletonList(buf.method_19772());
        } else {
            values = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                values.add(buf.method_19772());
            }
        }
        boolean isKeyValue = buf.readBoolean();
        boolean translateKey = buf.readBoolean();
        String key = buf.method_19772();
        CacheKey cacheKey = new CacheKey(children, key, values, isKeyValue, translateKey);
        try {
            return (ValueTooltipNode)CACHE.get((Object)cacheKey);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private record CacheKey(List<ITooltipNode> children, String key, List<String> values, boolean isKeyValue, boolean translateKey) {
        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.isKeyValue == cacheKey.isKeyValue && this.translateKey == cacheKey.translateKey && Objects.equals(this.key, cacheKey.key) && Objects.equals(this.values, cacheKey.values) && Objects.equals(this.children, cacheKey.children);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.children, this.key, this.values, this.isKeyValue, this.translateKey);
        }
    }

    public static class Builder
    extends ListTooltipNode.Builder {
        private final List<String> values;
        private final boolean isKeyValue;

        public Builder(List<String> values) {
            this.values = values;
            this.isKeyValue = false;
        }

        public Builder(String key, String value) {
            this.values = List.of(key, value);
            this.isKeyValue = true;
        }

        @Override
        public ValueTooltipNode build(String key) {
            return this.build(key, true);
        }

        public ValueTooltipNode build(String key, boolean translateKey) {
            String internKey = key.intern();
            CacheKey cacheKey = new CacheKey((List<ITooltipNode>)ImmutableList.copyOf((Collection)this.children), internKey, (List<String>)ImmutableList.copyOf(this.values), this.isKeyValue, translateKey);
            try {
                return (ValueTooltipNode)CACHE.get((Object)cacheKey);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

