/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.mojang.authlib.properties.Property;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ErrorTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_117;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2588;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_42;
import net.minecraft.class_4553;
import net.minecraft.class_4559;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9262;
import net.minecraft.class_9292;
import net.minecraft.class_9331;
import net.minecraft.class_9360;
import net.minecraft.class_9368;
import net.minecraft.class_9429;
import net.minecraft.class_9639;
import net.minecraft.class_9643;
import net.minecraft.class_9648;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericTooltipUtils {
    @NotNull
    public static ITooltipNode getMissingFunction(IServerUtils utils, class_117 function) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getFunctionTypeTooltip(utils, function.method_29321());
        Field[] fields = function.getClass().getDeclaredFields();
        List<Field> names = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t = utils.getValueTooltip(utils, f.get(function));
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "???").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getMissingCondition(IServerUtils utils, class_5341 condition) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getConditionTypeTooltip(utils, condition.method_29325());
        Field[] fields = condition.getClass().getDeclaredFields();
        List<Field> names = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers())).toList();
        names.forEach(f -> {
            f.setAccessible(true);
            try {
                IKeyTooltipNode t = utils.getValueTooltip(utils, f.get(condition));
                if (t instanceof ValueTooltipNode.Builder) {
                    ValueTooltipNode.Builder builder = (ValueTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof BranchTooltipNode.Builder) {
                    BranchTooltipNode.Builder builder = (BranchTooltipNode.Builder)t;
                    tooltip.add(builder.build(f.getName(), false));
                } else if (t instanceof ErrorTooltipNode.Builder) {
                    tooltip.add(ValueTooltipNode.keyValue(f.getName(), "???").build("ali.property.value.null"));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return tooltip.build("ali.util.advanced_loot_info.auto_detected");
    }

    @NotNull
    public static ITooltipNode getConditionListTooltip(IServerUtils utils, List<class_5341> conditions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (class_5341 condition : conditions) {
            array.add(utils.getConditionTooltip(utils, condition));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getConditionsTooltip(IServerUtils utils, List<class_5341> conditions) {
        if (!conditions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.conditions")).add(GenericTooltipUtils.getConditionListTooltip(utils, conditions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    @NotNull
    public static IKeyTooltipNode getSubConditionsTooltip(IServerUtils utils, List<class_5341> conditions) {
        if (!conditions.isEmpty()) {
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getConditionListTooltip(utils, conditions));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getFunctionListTooltip(IServerUtils utils, List<class_117> functions) {
        ArrayTooltipNode.Builder array = ArrayTooltipNode.array();
        for (class_117 function : functions) {
            array.add(utils.getFunctionTooltip(utils, function));
        }
        return array.build();
    }

    @NotNull
    public static ITooltipNode getFunctionsTooltip(IServerUtils utils, List<class_117> functions) {
        if (!functions.isEmpty()) {
            return ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.delimiter.functions")).add(GenericTooltipUtils.getFunctionListTooltip(utils, functions)).build();
        }
        return EmptyTooltipNode.EMPTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static ITooltipNode getPropertyMatcherTooltip(IServerUtils ignoredUtils, class_4559.class_4562 propertyMatcher) {
        Optional maxValue;
        String name;
        block5: {
            Optional minValue;
            Optional optional;
            class_4559.class_4561 class_45612;
            name = propertyMatcher.comp_1832();
            class_4559.class_8750 class_87502 = propertyMatcher.comp_1833();
            if (class_87502 instanceof class_4559.class_4561) {
                String string;
                class_45612 = (class_4559.class_4561)class_87502;
                String value = string = class_45612.comp_1831();
                return ValueTooltipNode.keyValue(name, value).build("ali.property.value.null");
            }
            class_4559.class_8750 class_87503 = propertyMatcher.comp_1833();
            if (!(class_87503 instanceof class_4559.class_4563)) return EmptyTooltipNode.EMPTY;
            class_45612 = (class_4559.class_4563)class_87503;
            try {
                minValue = optional = class_45612.comp_1834();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            maxValue = optional = class_45612.comp_1835();
            if (!minValue.isPresent()) break block5;
            if (!maxValue.isPresent()) return ValueTooltipNode.value(name, minValue.get()).build("ali.property.value.ranged_property_gte");
            return ValueTooltipNode.value(name, minValue.get(), maxValue.get()).build("ali.property.value.ranged_property_both");
        }
        if (!maxValue.isPresent()) return ValueTooltipNode.value(name).build("ali.property.value.ranged_property_any");
        return ValueTooltipNode.value(name, maxValue.get()).build("ali.property.value.ranged_property_lte");
    }

    @NotNull
    public static ITooltipNode getStatMatcherTooltip(IServerUtils utils, class_4553.class_8749<?> stat) {
        ITooltipNode tooltip;
        String key = ValueTooltipNode.translate(((class_2588)stat.comp_1825().method_30739().method_10851()).method_11022());
        class_6880 value = stat.comp_1826();
        Object object = value.comp_349();
        if (object instanceof class_1792) {
            class_1792 item = (class_1792)object;
            tooltip = utils.getValueTooltip(utils, item).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.comp_1827())).build("ali.property.value.null")).build("ali.property.value.item");
        } else {
            object = value.comp_349();
            if (object instanceof class_2248) {
                class_2248 block = (class_2248)object;
                tooltip = utils.getValueTooltip(utils, block).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.comp_1827())).build("ali.property.value.null")).build("ali.property.value.block");
            } else {
                object = value.comp_349();
                if (object instanceof class_1299) {
                    class_1299 entityType = (class_1299)object;
                    tooltip = utils.getValueTooltip(utils, entityType).add(ValueTooltipNode.keyValue(key, GenericTooltipUtils.toString(stat.comp_1827())).build("ali.property.value.null")).build("ali.property.value.entity_type");
                } else {
                    object = value.comp_349();
                    if (object instanceof class_2960) {
                        class_2960 resourceLocation = (class_2960)object;
                        tooltip = utils.getValueTooltip(utils, resourceLocation).add(ValueTooltipNode.keyValue(ValueTooltipNode.translate(GenericTooltipUtils.getTranslationKey(resourceLocation)), GenericTooltipUtils.toString(stat.comp_1827())).build("ali.property.value.null")).build("ali.property.value.id");
                    } else {
                        tooltip = EmptyTooltipNode.EMPTY;
                    }
                }
            }
        }
        return tooltip;
    }

    @NotNull
    public static <T> IKeyTooltipNode getStandaloneTooltip(IServerUtils utils, String value, Optional<class_9368.class_9677<T>> standalone) {
        if (standalone.isPresent()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            class_9368.class_9677<T> s = standalone.get();
            tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, value, s.comp_2651()).build("ali.property.branch.values"));
            tooltip.add(utils.getValueTooltip(utils, s.comp_2652()).build("ali.property.value.list_operation"));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <T> IKeyTooltipNode getFilterableTooltip(IServerUtils utils, String value, Collection<class_9262<T>> data) {
        BranchTooltipNode.Builder tooltips = BranchTooltipNode.branch();
        for (class_9262<T> d : data) {
            tooltips.add(BranchTooltipNode.branch().add(utils.getValueTooltip(utils, d.comp_2369()).build("ali.property.value.raw")).add(utils.getValueTooltip(utils, d.comp_2370()).build("ali.property.value.filtered")).build(value));
        }
        return tooltips;
    }

    @NotNull
    public static <T> IKeyTooltipNode getCollectionTooltip(IServerUtils utils, Collection<T> values, BiFunction<IServerUtils, T, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.forEach(value -> tooltip.add((ITooltipNode)mapper.apply(utils, value)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, String value, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build(value));
        }
        return tooltip;
    }

    @NotNull
    public static <K, V> IKeyTooltipNode getMapTooltip(IServerUtils utils, Map<K, V> values, BiFunction<IServerUtils, Map.Entry<K, V>, ITooltipNode> mapper) {
        if (!values.isEmpty()) {
            BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
            values.entrySet().forEach(e -> tooltip.add((ITooltipNode)mapper.apply(utils, (Map.Entry)e)));
            return tooltip;
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static ITooltipNode getRecipeEntryTooltip(IServerUtils ignoredUtils, Map.Entry<class_2960, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getCriterionEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, Boolean> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getStringEntryTooltip(IServerUtils ignoredUtils, Map.Entry<String, String> entry) {
        return ValueTooltipNode.keyValue(entry.getKey(), entry.getValue()).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getIntRangeEntryTooltip(IServerUtils utils, Map.Entry<String, class_42> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.limit")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMobEffectPredicateEntryTooltip(IServerUtils utils, Map.Entry<class_6880<class_1291>, class_2102.class_2103> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue().comp_1812()).build("ali.property.value.amplifier")).add(utils.getValueTooltip(utils, entry.getValue().comp_1813()).build("ali.property.value.duration")).add(utils.getValueTooltip(utils, entry.getValue().comp_1814()).build("ali.property.value.is_ambient")).add(utils.getValueTooltip(utils, entry.getValue().comp_1815()).build("ali.property.value.is_visible")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelsEntryTooltip(IServerUtils utils, Map.Entry<class_6880<class_1887>, class_5658> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.levels")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getAdvancementEntryTooltip(IServerUtils utils, Map.Entry<class_2960, class_4553.class_4556> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(GenericTooltipUtils.getAdvancementPredicateTooltip(utils, entry.getValue())).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getMapDecorationEntryTooltip(IServerUtils utils, Map.Entry<String, class_9292.class_9293> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.null")).build("ali.property.value.decoration");
    }

    @NotNull
    public static ITooltipNode getBlockPropertyEntryTooltip(IServerUtils utils, Map.Entry<class_6880<class_2248>, class_2769<?>> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.property")).build("ali.property.value.block");
    }

    @NotNull
    public static ITooltipNode getPropertiesEntryTooltip(IServerUtils utils, Map.Entry<String, Collection<Property>> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.property", entry.getValue()).build("ali.property.branch.properties")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getEnchantmentLevelEntryTooltip(IServerUtils utils, Map.Entry<class_6880<class_1887>, Integer> entry) {
        return utils.getValueTooltip(utils, entry.getKey()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.level")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getToggleEntryTooltip(IServerUtils utils, Map.Entry<class_9429.class_9430<?>, Boolean> entry) {
        return RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, entry.getKey().comp_2523()).add(utils.getValueTooltip(utils, entry.getValue()).build("ali.property.value.value")).build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getDataComponentPatchEntryTooltip(IServerUtils utils, Map.Entry<class_9331<?>, Optional<?>> entry) {
        IKeyTooltipNode tooltip = RegistriesTooltipUtils.getDataComponentTypeTooltip(utils, entry.getKey());
        entry.getValue().ifPresent(v -> tooltip.add(utils.getDataComponentTypeTooltip(utils, (class_9331)entry.getKey(), v)));
        if (entry.getValue().isEmpty()) {
            tooltip.add(LiteralTooltipNode.translatable("ali.util.advanced_loot_info.removed"));
        }
        return tooltip.build("ali.property.value.null");
    }

    @NotNull
    public static ITooltipNode getItemSubPredicateEntryTooltip(IServerUtils utils, Map.Entry<class_9360.class_8745<?>, class_9360> entry) {
        return utils.getItemSubPredicateTooltip(utils, entry.getValue());
    }

    @NotNull
    public static <V, T extends class_2378<V>> IKeyTooltipNode getRegistryTooltip(IServerUtils utils, class_5321<T> registry, V value) {
        Optional<class_6880.class_6883> first;
        Optional lookup;
        class_7225.class_7874 provider = utils.lookupProvider();
        if (provider != null && (lookup = provider.method_46759(registry)).isPresent() && (first = ((class_7225.class_7226)lookup.get()).method_42017().filter(l -> l.comp_349() == value).findFirst()).isPresent()) {
            return utils.getValueTooltip(utils, Objects.requireNonNull(first.get().method_40237()));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <A, B extends Predicate<A>> IKeyTooltipNode getCollectionPredicateTooltip(IServerUtils utils, String value, Optional<class_9648<A, B>> optional) {
        if (optional.isPresent()) {
            class_9648<A, B> predicate = optional.get();
            return BranchTooltipNode.branch().add(GenericTooltipUtils.getCollectionContentsPredicateTooltip(utils, value, predicate.comp_2617()).build("ali.property.branch.contains")).add(GenericTooltipUtils.getCollectionCountsPredicateTooltip(utils, value, predicate.comp_2618()).build("ali.property.branch.counts")).add(utils.getValueTooltip(utils, predicate.comp_2619()).build("ali.property.value.size"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <A, B extends Predicate<A>> IKeyTooltipNode getCollectionContentsPredicateTooltip(IServerUtils utils, String value, Optional<class_9639<A, B>> predicate) {
        return predicate.map(p -> GenericTooltipUtils.getCollectionTooltip(utils, value, p.method_59605())).orElse(EmptyTooltipNode.empty());
    }

    @NotNull
    public static <A, B extends Predicate<A>> IKeyTooltipNode getCollectionCountsPredicateTooltip(IServerUtils utils, String value, Optional<class_9643<A, B>> predicate) {
        return predicate.map(p -> GenericTooltipUtils.getCollectionTooltip(utils, value, p.method_59613())).orElse(EmptyTooltipNode.empty());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static ITooltipNode getAdvancementPredicateTooltip(IServerUtils utils, class_4553.class_4556 predicate) {
        if (predicate instanceof class_4553.class_4555) {
            boolean bl;
            class_4553.class_4555 class_45552 = (class_4553.class_4555)predicate;
            boolean state = bl = class_45552.comp_1824();
            return utils.getValueTooltip(utils, state).build("ali.property.value.done");
        }
        if (!(predicate instanceof class_4553.class_4554)) return EmptyTooltipNode.EMPTY;
        class_4553.class_4554 class_45542 = (class_4553.class_4554)predicate;
        try {
            Object2BooleanMap object2BooleanMap;
            Object2BooleanMap criterions = object2BooleanMap = class_45542.comp_1823();
            return GenericTooltipUtils.getMapTooltip(utils, criterions, GenericTooltipUtils::getCriterionEntryTooltip).build("ali.property.branch.criterions");
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @NotNull
    public static String toString(class_2096.class_2099 doubles) {
        Optional min = doubles.comp_1805();
        Optional max = doubles.comp_1806();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min.get(), max.get())) {
                    return String.format("%.1f-%.1f", min.get(), max.get());
                }
                return String.format("=%.1f", min.get());
            }
            return String.format("\u2265%.1f", min.get());
        }
        return max.map(aDouble -> String.format("\u2264%.1f", aDouble)).orElse("???");
    }

    @NotNull
    public static String toString(class_2096.class_2100 ints) {
        Optional min = ints.comp_1805();
        Optional max = ints.comp_1806();
        if (min.isPresent()) {
            if (max.isPresent()) {
                if (!Objects.equals(min.get(), max.get())) {
                    return String.format("%d-%d", min.get(), max.get());
                }
                return String.format("=%d", min.get());
            }
            return String.format("\u2265%d", min.get());
        }
        return max.map(integer -> String.format("\u2264%d", integer)).orElse("???");
    }

    @NotNull
    private static String getTranslationKey(class_2960 location) {
        return "stat." + location.toString().replace(':', '.');
    }
}

