/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.IType;
import com.yanny.ali.compatibility.jei.JeiLootSlotWidget;
import com.yanny.ali.compatibility.jei.JeiScrollWidget;
import com.yanny.ali.compatibility.jei.JeiWidgetWrapper;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.common.NodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8029;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public abstract class JeiBaseLoot<T extends IType, V>
implements IRecipeCategory<RecipeHolder<T>> {
    static final int CATEGORY_WIDTH = 162;
    static final int CATEGORY_HEIGHT = 126;
    protected final IGuiHelper guiHelper;
    private final IRecipeType<RecipeHolder<T>> recipeType;
    private final LootCategory<V> lootCategory;
    private final class_2561 title;
    private final IDrawable icon;

    public JeiBaseLoot(IGuiHelper guiHelper, IRecipeType<RecipeHolder<T>> recipeType, LootCategory<V> lootCategory, class_2561 title, IDrawable icon) {
        this.guiHelper = guiHelper;
        this.recipeType = recipeType;
        this.lootCategory = lootCategory;
        this.title = title;
        this.icon = icon;
    }

    @NotNull
    public final IRecipeType<RecipeHolder<T>> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public final class_2561 getTitle() {
        return this.title;
    }

    public final IDrawable getIcon() {
        return this.icon;
    }

    public LootCategory<V> getLootCategory() {
        return this.lootCategory;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<T> recipe, IFocusGroup iFocusGroup) {
        LinkedList<Holder> slotParams = new LinkedList<Holder>();
        IWidgetUtils utils = this.getJeiUtils(slotParams);
        RelativeRect rect = new RelativeRect(0, this.getYOffset(recipe.type()), 162, 0);
        recipe.setWidgetWrapper(new JeiWidgetWrapper(this.getRootWidget(utils, recipe.type().entry(), rect, 162)));
        recipe.setHolders(slotParams);
        recipe.type().inputs().forEach(i -> builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).add(i));
        recipe.type().outputs().forEach(i -> builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).add(i));
        for (int i2 = 0; i2 < slotParams.size(); ++i2) {
            Holder h = (Holder)slotParams.get(i2);
            IRecipeSlotBuilder slotBuilder = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY).setStandardSlotBackground().setSlotName(String.valueOf(i2)).setPosition(h.rect.getX(), h.rect.getY())).addRichTooltipCallback((iRecipeSlotView, tooltipBuilder) -> tooltipBuilder.addAll(NodeUtils.toComponents(h.entry().getTooltip(), 0, class_310.method_1551().field_1690.field_1827)));
            Optional left = h.item.left();
            Optional right = h.item.right();
            left.ifPresent(arg_0 -> ((IRecipeSlotBuilder)slotBuilder).add(arg_0));
            right.ifPresent(t -> slotBuilder.add(class_1856.method_26964(class_7923.field_41178.method_46733(t).map(f -> f.method_40239().map(class_6880::comp_349)).orElse(Stream.of(new class_1792[0])))));
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<T> recipe, IFocusGroup focuses) {
        JeiWidgetWrapper widgetWrapper = recipe.getWidgetWrapper();
        List<Holder> slotParams = recipe.getHolders();
        if (widgetWrapper == null || slotParams == null) {
            return;
        }
        Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> additionalWidgets = this.getWidgets(builder, recipe.type());
        LinkedList<IRecipeWidget> scrollWidgets = new LinkedList<IRecipeWidget>((Collection)additionalWidgets.getA());
        LinkedList slotDrawables = new LinkedList((Collection)additionalWidgets.getB());
        scrollWidgets.add(widgetWrapper);
        for (int i = 0; i < slotParams.size(); ++i) {
            Holder h = slotParams.get(i);
            builder.getRecipeSlots().findSlotByName(String.valueOf(i)).ifPresent(slotDrawable -> {
                scrollWidgets.add((IRecipeWidget)new JeiLootSlotWidget((IRecipeSlotDrawable)slotDrawable, h.rect.getX(), h.rect.getY(), ((IItemNode)((Object)h.entry)).getCount()));
                slotDrawables.add(slotDrawable);
            });
        }
        Rect renderRect = new Rect(0, 0, 162 + JeiScrollWidget.getScrollBoxScrollbarExtraWidth(), 126);
        JeiScrollWidget scrollWidget = new JeiScrollWidget(renderRect, widgetWrapper.getRect().height() + this.getYOffset(recipe.type()), scrollWidgets);
        builder.addSlottedWidget((ISlottedRecipeWidget)scrollWidget, slotDrawables);
        builder.addInputHandler((IJeiInputHandler)scrollWidget);
    }

    public int getWidth() {
        return 162 + JeiScrollWidget.getScrollBoxScrollbarExtraWidth();
    }

    public int getHeight() {
        return 126;
    }

    abstract Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> getWidgets(IRecipeExtrasBuilder var1, T var2);

    abstract int getYOffset(T var1);

    abstract IWidget getRootWidget(IWidgetUtils var1, IDataNode var2, RelativeRect var3, int var4);

    @NotNull
    protected IRecipeWidget createTextWidget(final class_2561 component, final int x, final int y, final boolean centered) {
        return new IRecipeWidget(){
            private final class_8029 position;
            {
                this.position = new class_8029(x, y);
            }

            @NotNull
            public class_8029 getPosition() {
                return this.position;
            }

            public void drawWidget(class_332 guiGraphics, double mouseX, double mouseY) {
                if (centered) {
                    int width = class_310.method_1551().field_1772.method_27525((class_5348)component);
                    guiGraphics.method_51439(class_310.method_1551().field_1772, component, x - width / 2, y, -16777216, false);
                } else {
                    guiGraphics.method_51439(class_310.method_1551().field_1772, component, x, y, -16777216, false);
                }
            }
        };
    }

    @NotNull
    private IWidgetUtils getJeiUtils(final List<Holder> slotParams) {
        return new ClientUtils(this){

            @Override
            public void addSlotWidget(Either<class_1799, class_6862<? extends class_1935>> item, IDataNode entry, RelativeRect rect) {
                slotParams.add(new Holder(item, entry, rect));
            }
        };
    }

    public record Holder(Either<class_1799, class_6862<? extends class_1935>> item, IDataNode entry, RelativeRect rect) {
    }
}

