/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record SyncLootTableMessage(ResourceLocation location, List<ItemStack> items, IDataNode node) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<SyncLootTableMessage> TYPE = new CustomPacketPayload.Type(Utils.modLoc("loot_table_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncLootTableMessage> CODEC = StreamCodec.m_321516_((StreamCodec)ResourceLocation.f_314488_, l -> l.location, (StreamCodec)ItemStack.f_315592_, l -> l.items, (StreamCodec)StreamCodec.m_320617_((b, l) -> {
        int fallbackIndex = b.writerIndex();
        try {
            AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
            l.encode(utils, (RegistryFriendlyByteBuf)b);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to encode loot table with error: {}", (Object)e.getMessage());
            b.writerIndex(fallbackIndex);
            ByteBufCodecs.m_319284_((Codec)LootDataType.f_278413_.f_290795_()).m_318638_(b, (Object)LootTable.f_79105_);
        }
    }, b -> {
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            return new LootTableNode(utils, (RegistryFriendlyByteBuf)b);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to decode loot table with error: {}", (Object)e.getMessage());
            return new MissingNode();
        }
    }), l -> l.node, SyncLootTableMessage::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }
}

