/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.immersive_engineering.trades;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import com.yanny.ali.plugin.mods.IItemListing;
import com.yanny.ali.plugin.mods.PluginUtils;
import com.yanny.ali.plugin.mods.immersive_engineering.trades.LazyItemStack;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@ClassAccessor(value="blusunrize.immersiveengineering.common.world.Villages$TradeListing")
public class TradeListing
extends BaseAccessor<VillagerTrades.ItemListing>
implements IItemListing {
    private static final Logger LOGGER;
    private static final Object SELL_FOR_ONE_EMERALD;
    private static final Object SELL_FOR_MANY_EMERALDS;
    private static final Object BUY_FOR_ONE_EMERALD;
    private static final Object BUY_FOR_MANY_EMERALDS;
    @FieldAccessor
    private int price;
    @FieldAccessor
    private Object outline;
    @FieldAccessor(clazz=LazyItemStack.class)
    private LazyItemStack lazyItem;
    @FieldAccessor
    private int maxUses;
    @FieldAccessor
    private int xp;
    @FieldAccessor
    private float priceMultiplier;

    public TradeListing(VillagerTrades.ItemListing parent) {
        super(parent);
    }

    @Override
    @NotNull
    public IDataNode getNode(IServerUtils utils, List<ITooltipNode> conditions) {
        Either<ItemStack, TagKey<? extends ItemLike>> item = this.lazyItem.getItem();
        if (this.outline == SELL_FOR_ONE_EMERALD) {
            return new ItemsToItemsNode(utils, item, new RangeValue(this.price), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(1.0f), this.maxUses, this.xp, this.priceMultiplier, conditions);
        }
        if (this.outline == SELL_FOR_MANY_EMERALDS) {
            return new ItemsToItemsNode(utils, item, new RangeValue(1.0f), (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(this.price), this.maxUses, this.xp, this.priceMultiplier, conditions);
        }
        if (this.outline == BUY_FOR_ONE_EMERALD) {
            return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(1.0f), item, new RangeValue(this.price), this.maxUses, this.xp, this.priceMultiplier, conditions);
        }
        if (this.outline == BUY_FOR_MANY_EMERALDS) {
            return new ItemsToItemsNode(utils, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)Items.EMERALD.getDefaultInstance()), new RangeValue(this.price), item, new RangeValue(1.0f), this.maxUses, this.xp, this.priceMultiplier, conditions);
        }
        return new MissingNode();
    }

    @Override
    public Pair<List<Item>, List<Item>> collectItems(IServerUtils utils) {
        List<Item> items = PluginUtils.getItems(utils, this.lazyItem.getItem());
        if (this.outline == SELL_FOR_ONE_EMERALD || this.outline == SELL_FOR_MANY_EMERALDS) {
            return new Pair(items, List.of(Items.EMERALD));
        }
        if (this.outline == BUY_FOR_ONE_EMERALD || this.outline == BUY_FOR_MANY_EMERALDS) {
            return new Pair(List.of(Items.EMERALD), items);
        }
        return new Pair(List.of(), List.of());
    }

    static {
        Field typeMapField;
        Class<?> tradesClass;
        LOGGER = LogUtils.getLogger();
        Object sellForOneEmerald = null;
        Object sellForManyEmeralds = null;
        Object buyForOneEmerald = null;
        Object buyForManyEmeralds = null;
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("SELL_FOR_ONE_EMERALD");
            typeMapField.setAccessible(true);
            sellForOneEmerald = typeMapField.get(null);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to obtain trade outline SELL_FOR_ONE_EMERALD: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("SELL_FOR_MANY_EMERALDS");
            typeMapField.setAccessible(true);
            sellForManyEmeralds = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline SELL_FOR_MANY_EMERALDS: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("BUY_FOR_ONE_EMERALD");
            typeMapField.setAccessible(true);
            buyForOneEmerald = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline BUY_FOR_ONE_EMERALD: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("BUY_FOR_MANY_EMERALDS");
            typeMapField.setAccessible(true);
            buyForOneEmerald = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline BUY_FOR_MANY_EMERALDS: {}", (Object)e.getMessage());
        }
        SELL_FOR_ONE_EMERALD = sellForOneEmerald;
        SELL_FOR_MANY_EMERALDS = sellForManyEmeralds;
        BUY_FOR_ONE_EMERALD = buyForOneEmerald;
        BUY_FOR_MANY_EMERALDS = buyForManyEmeralds;
    }
}

