/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.rei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiWidgetWrapper;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.plugin.client.ClientUtils;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import com.yanny.ali.plugin.common.NodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReiBaseCategory<T extends ReiBaseDisplay, U>
implements DisplayCategory<T> {
    static final int CATEGORY_WIDTH = 162;
    static final int CATEGORY_HEIGHT = 144;
    static final int PADDING = 4;
    static final int ITEM_SIZE = 16;
    static final int SLOT_SIZE = 18;
    static final int OUT_SLOT_SIZE = 26;
    static final int SLOT_OFFSET = 1;
    static final int OUT_SLOT_OFFSET = 5;
    private final LootCategory<U> lootCategory;

    public ReiBaseCategory(LootCategory<U> lootCategory) {
        this.lootCategory = lootCategory;
    }

    public abstract List<Widget> setupDisplay(T var1, Rectangle var2);

    public int getDisplayWidth(T display) {
        return 162;
    }

    public int getDisplayHeight() {
        return 144;
    }

    public LootCategory<U> getLootCategory() {
        return this.lootCategory;
    }

    protected WidgetHolder getBaseWidget(T display, Rectangle bounds, int y) {
        LinkedList<Holder> slotWidgets = new LinkedList<Holder>();
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        RelativeRect rect = new RelativeRect(0, y, 162, 0);
        LootTableWidget widget = new LootTableWidget(this.getUtils(slotWidgets), ((ReiBaseDisplay)((Object)display)).getLootData(), rect, 162);
        ReiWidgetWrapper widgetWrapper = new ReiWidgetWrapper(widget);
        widgets.add(Widgets.createTooltip(widgetWrapper::getTooltip));
        widgets.add((Widget)widgetWrapper);
        slotWidgets.forEach(h -> {
            Optional left = h.item.left();
            Optional right = h.item.right();
            if (left.isPresent()) {
                ItemStack itemStack = (ItemStack)left.get();
                EntryStack stack2 = EntryStacks.of((ItemStack)itemStack);
                stack2.tooltip(NodeUtils.toComponents(h.entry.getTooltip(), 0, Minecraft.getInstance().options.advancedItemTooltips));
                widgets.add((Widget)Widgets.createSlot((Point)new Point(h.rect.getX() + bounds.getX() + 1, h.rect.getY() + bounds.getY() + 1)).entry(stack2).markOutput());
            } else if (right.isPresent()) {
                TagKey tagKey = (TagKey)right.get();
                EntryIngredient ingredient = EntryIngredients.ofItemTag((TagKey)tagKey);
                ingredient.map(stack -> stack.tooltip(NodeUtils.toComponents(h.entry.getTooltip(), 0, Minecraft.getInstance().options.advancedItemTooltips)));
                widgets.add((Widget)Widgets.createSlot((Point)new Point(h.rect.getX() + bounds.getX() + 1, h.rect.getY() + bounds.getY() + 1)).entries((Collection)ingredient).markOutput());
            }
            widgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(h.rect.getX() + bounds.getX(), h.rect.getY() + bounds.getY(), 18, 18), (Renderer)new SlotCountRenderer(((IItemNode)((Object)h.entry)).getCount())));
        });
        return new WidgetHolder(widgets, widget.getRect());
    }

    @NotNull
    private IWidgetUtils getUtils(final List<Holder> widgets) {
        return new ClientUtils(this){

            @Override
            public void addSlotWidget(Either<ItemStack, TagKey<? extends ItemLike>> item, IDataNode entry, RelativeRect rect) {
                widgets.add(new Holder(item, entry, rect));
            }
        };
    }

    protected record WidgetHolder(List<Widget> widgets, RelativeRect bounds) {
    }

    private record Holder(Either<ItemStack, TagKey<? extends ItemLike>> item, IDataNode entry, RelativeRect rect) {
    }

    private static class SlotCountRenderer
    implements Renderer {
        @Nullable
        private Component count;
        private boolean isRange = false;

        public SlotCountRenderer(RangeValue count) {
            if (count.isRange() || count.min() > 1.0f) {
                this.count = Component.literal((String)count.toIntString());
                this.isRange = count.isRange();
            }
        }

        public void render(GuiGraphics guiGraphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (this.count != null) {
                Font font = Minecraft.getInstance().font;
                PoseStack stack = guiGraphics.pose();
                stack.pushPose();
                stack.translate((float)bounds.getX(), (float)bounds.getY(), 0.0f);
                if (this.isRange) {
                    stack.translate(17.0f, 13.0f, 200.0f);
                    stack.pushPose();
                    stack.scale(0.5f, 0.5f, 0.5f);
                    guiGraphics.drawString(font, this.count, -font.width((FormattedText)this.count), 0, 0xFFFFFF, false);
                    stack.popPose();
                } else {
                    stack.translate(18.0f, 10.0f, 200.0f);
                    guiGraphics.drawString(font, this.count, -font.width((FormattedText)this.count), 0, 0xFFFFFF, true);
                }
                stack.popPose();
            }
        }
    }
}

