/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin;

import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.mixin.MixinCanToolPerformAction;
import com.yanny.ali.mixin.MixinLootTableIdCondition;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import net.neoforged.neoforge.common.loot.CanToolPerformAction;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@AliEntrypoint
public class NeoForgePlugin
implements IPlugin {
    @Override
    public String getModId() {
        return "neoforge";
    }

    @Override
    public void registerServer(IServerRegistry registry) {
        registry.registerConditionTooltip(CanToolPerformAction.class, NeoForgePlugin::getCanToolPerformActionTooltip);
        registry.registerConditionTooltip(LootTableIdCondition.class, NeoForgePlugin::getLootTableIdTooltip);
    }

    public static @Unmodifiable @NotNull ITooltipNode getCanToolPerformActionTooltip(IServerUtils utils, CanToolPerformAction condition) {
        MixinCanToolPerformAction cond = (MixinCanToolPerformAction)condition;
        return GenericTooltipUtils.getStringTooltip(utils, "ali.type.condition.can_tool_perform_action", cond.getAction().name());
    }

    public static @Unmodifiable @NotNull ITooltipNode getLootTableIdTooltip(IServerUtils utils, LootTableIdCondition condition) {
        MixinLootTableIdCondition cond = (MixinLootTableIdCondition)condition;
        return GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.type.condition.loot_table_id", cond.getTargetLootTableId());
    }
}

