/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiBlockCategory;
import com.yanny.ali.compatibility.rei.ReiBlockDisplay;
import com.yanny.ali.compatibility.rei.ReiEntityCategory;
import com.yanny.ali.compatibility.rei.ReiEntityDisplay;
import com.yanny.ali.compatibility.rei.ReiGameplayCategory;
import com.yanny.ali.compatibility.rei.ReiGameplayDisplay;
import com.yanny.ali.network.AbstractClient;
import com.yanny.ali.platform.Services;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ReiCompatibility
implements REIClientPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Holder<ReiBlockDisplay, BlockLootType, class_2248>> blockCategoryList = new LinkedList<Holder<ReiBlockDisplay, BlockLootType, class_2248>>();
    private final List<Holder<ReiEntityDisplay, EntityLootType, class_1297>> entityCategoryList = new LinkedList<Holder<ReiEntityDisplay, EntityLootType, class_1297>>();
    private final List<Holder<ReiGameplayDisplay, GameplayLootType, String>> gameplayCategoryList = new LinkedList<Holder<ReiGameplayDisplay, GameplayLootType, String>>();

    public void registerCategories(CategoryRegistry registry) {
        this.blockCategoryList.clear();
        this.entityCategoryList.clear();
        this.gameplayCategoryList.clear();
        this.blockCategoryList.add(this.createCategory(LootCategories.PLANT_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.blockCategoryList.addAll(LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiBlockDisplay::new, ReiBlockCategory::new)).collect(Collectors.toSet()));
        this.blockCategoryList.add(this.createCategory(LootCategories.BLOCK_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.entityCategoryList.addAll(LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiEntityDisplay::new, ReiEntityCategory::new)).collect(Collectors.toSet()));
        this.entityCategoryList.add(this.createCategory(LootCategories.ENTITY_LOOT, ReiEntityDisplay::new, ReiEntityCategory::new));
        this.gameplayCategoryList.addAll(LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiGameplayDisplay::new, ReiGameplayCategory::new)).collect(Collectors.toSet()));
        this.gameplayCategoryList.add(this.createCategory(LootCategories.GAMEPLAY_LOOT, ReiGameplayDisplay::new, ReiGameplayCategory::new));
        for (Holder<ReiBlockDisplay, BlockLootType, class_2248> holder : this.blockCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.entityCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.gameplayCategoryList) {
            registry.add(holder.category);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerDisplays(DisplayRegistry registry) {
        AbstractClient client = Services.PLATFORM.getInfoPropagator().client();
        class_638 level = class_310.method_1551().field_1687;
        if (client != null && level != null) {
            Map<class_5321<class_52>, class_52> map = GenericUtils.getLootTables();
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap<Holder, List> gameplayRecipeTypes = new HashMap<Holder, List>();
            map.entrySet().stream().sorted(Comparator.comparing(s -> ((class_5321)s.getKey()).method_29177().method_12832())).forEach(f -> LOGGER.warn(((class_5321)f.getKey()).method_29177().method_12832()));
            for (class_2248 class_22482 : class_7923.field_41175) {
                class_22482.method_26162().ifPresent(location -> {
                    class_52 lootEntry = (class_52)map.get(location);
                    if (lootEntry != null) {
                        for (Holder<ReiBlockDisplay, BlockLootType, class_2248> holder : this.blockCategoryList) {
                            if (!holder.category.getLootCategory().validate(block)) continue;
                            blockRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new BlockLootType(block, lootEntry, GenericUtils.getItems((class_5321<class_52>)location)));
                            break;
                        }
                        map.remove(location);
                    }
                });
            }
            for (class_1299 class_12992 : class_7923.field_41177) {
                LinkedList<Object> entityList = new LinkedList<Object>();
                if (class_12992 == class_1299.field_6115) {
                    class_1472 sheep;
                    for (class_1767 color : class_1767.values()) {
                        void sheep2;
                        try {
                            class_1472 sheep22 = (class_1472)class_12992.method_5883((class_1937)level, class_3730.field_52444);
                        }
                        catch (Throwable e) {
                            LOGGER.warn("Failed to create colored sheep with color {}: {}", (Object)color.method_15434(), (Object)e.getMessage());
                            continue;
                        }
                        if (sheep2 == null) continue;
                        sheep2.method_6631(color);
                        entityList.add(sheep2);
                    }
                    try {
                        sheep = (class_1472)class_12992.method_5883((class_1937)level, class_3730.field_52444);
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Failed to create sheep: {}", (Object)throwable.getMessage());
                        continue;
                    }
                    if (sheep != null) {
                        sheep.method_6635(true);
                        entityList.add(sheep);
                    }
                } else {
                    class_1297 entity;
                    try {
                        entity = class_12992.method_5883((class_1937)level, class_3730.field_52444);
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Failed to create entity {}: {}", (Object)class_7923.field_41177.method_10221((Object)class_12992), (Object)throwable.getMessage());
                        continue;
                    }
                    entityList.add(entity);
                }
                for (class_1297 class_12972 : entityList) {
                    if (!(class_12972 instanceof class_1308)) continue;
                    class_1308 mob = (class_1308)class_12972;
                    mob.method_5991().ifPresent(location -> {
                        class_52 lootEntry = (class_52)map.get(location);
                        if (lootEntry != null) {
                            for (Holder<ReiEntityDisplay, EntityLootType, class_1297> holder : this.entityCategoryList) {
                                if (!holder.category.getLootCategory().validate(entity)) continue;
                                entityRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new EntityLootType(entity, lootEntry, GenericUtils.getItems((class_5321<class_52>)location)));
                                break;
                            }
                            map.remove(location);
                        }
                    });
                }
            }
            for (Map.Entry<class_5321<class_52>, class_52> entry : new HashMap<class_5321<class_52>, class_52>(map).entrySet()) {
                class_5321<class_52> location2 = entry.getKey();
                for (Holder holder : this.gameplayCategoryList) {
                    if (!holder.category.getLootCategory().validate(location2.method_29177().method_12832())) continue;
                    gameplayRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new GameplayLootType(entry.getValue(), "/" + location2.method_29177().method_12832(), GenericUtils.getItems(location2)));
                    break;
                }
                map.remove(location2);
            }
            for (Map.Entry<Object, Object> entry : blockRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.blockPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry<Object, Object> entry : entityRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.entityPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry<Object, Object> entry : gameplayRecipeTypes.entrySet()) {
                registry.registerFillerWithReason(this.gameplayPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
        }
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(Map.Entry<class_2960, LootCategory<U>> e, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, class_2561, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        class_2960 id = e.getKey();
        CategoryIdentifier identifier = CategoryIdentifier.of((String)id.method_12836(), (String)id.method_12832());
        class_5250 title = class_2561.method_43471((String)("emi.category." + id.method_12836() + "." + id.method_12832().replace('/', '.')));
        BiFunction<Object, DisplayAdditionReasons, ReiBaseDisplay> filler = (type, r) -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, e.getValue()), filler);
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(LootCategory<U> lootCategory, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, class_2561, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        CategoryIdentifier identifier = CategoryIdentifier.of((String)"ali", (String)lootCategory.getKey());
        class_5250 title = class_2561.method_43471((String)("emi.category.ali." + lootCategory.getKey().replace('/', '.')));
        BiFunction<Object, DisplayAdditionReasons, ReiBaseDisplay> filler = (type, r) -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, lootCategory), filler);
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> blockPredicate(List<BlockLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof BlockLootType) {
                BlockLootType type = (BlockLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> entityPredicate(List<EntityLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof EntityLootType) {
                EntityLootType type = (EntityLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private BiPredicate<Object, DisplayAdditionReasons> gameplayPredicate(List<GameplayLootType> lootTypes) {
        return (o, r) -> {
            if (o != null && o instanceof GameplayLootType) {
                GameplayLootType type = (GameplayLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    private record Holder<D extends ReiBaseDisplay, T, U>(CategoryIdentifier<D> identifier, ReiBaseCategory<D, U> category, BiFunction<T, DisplayAdditionReasons, D> filler) {
    }
}

