/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_79;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AliServerRegistry
implements IServerRegistry,
IServerUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<class_5338, BiFunction<IServerUtils, class_79, List<class_1792>>> entryItemCollectorMap = new HashMap<class_5338, BiFunction<IServerUtils, class_79, List<class_1792>>>();
    private final Map<class_5339<?>, TriFunction<IServerUtils, List<class_1792>, class_117, List<class_1792>>> functionItemCollectorMap = new HashMap();
    private final Map<class_5342, TriFunction<IServerUtils, List<class_1792>, class_5341, List<class_1792>>> conditionItemCollectorMap = new HashMap<class_5342, TriFunction<IServerUtils, List<class_1792>, class_5341, List<class_1792>>>();
    private final Map<class_5321<class_52>, class_52> lootTableMap = new HashMap<class_5321<class_52>, class_52>();
    private class_3218 serverLevel;

    public void addLootTable(class_5321<class_52> resourceLocation, class_52 lootTable) {
        this.lootTableMap.put(resourceLocation, lootTable);
    }

    public void setServerLevel(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
    }

    @Override
    public <T extends class_79> void registerItemCollector(class_5338 type, BiFunction<IServerUtils, T, List<class_1792>> itemSupplier) {
        this.entryItemCollectorMap.put(type, (u, e) -> (List)itemSupplier.apply((IServerUtils)u, (Object)e));
    }

    @Override
    public <T extends class_5341> void registerItemCollector(class_5342 type, TriFunction<IServerUtils, List<class_1792>, T, List<class_1792>> itemSupplier) {
        this.conditionItemCollectorMap.put(type, (TriFunction<IServerUtils, List<class_1792>, class_5341, List<class_1792>>)((TriFunction)(u, l, f) -> (List)itemSupplier.apply(u, l, f)));
    }

    @Override
    public <T extends class_117> void registerItemCollector(class_5339<?> type, TriFunction<IServerUtils, List<class_1792>, T, List<class_1792>> itemSupplier) {
        this.functionItemCollectorMap.put(type, (TriFunction<IServerUtils, List<class_1792>, class_117, List<class_1792>>)((TriFunction)(u, l, f) -> (List)itemSupplier.apply(u, l, f)));
    }

    @Override
    public <T extends class_79> List<class_1792> collectItems(IServerUtils utils, T entry) {
        BiFunction<IServerUtils, class_79, List<class_1792>> itemSupplier = this.entryItemCollectorMap.get(entry.method_29318());
        if (itemSupplier != null) {
            return itemSupplier.apply(utils, entry);
        }
        return List.of();
    }

    @Override
    public <T extends class_5341> List<class_1792> collectItems(IServerUtils utils, List<class_1792> items, T condition) {
        TriFunction<IServerUtils, List<class_1792>, class_5341, List<class_1792>> itemSupplier = this.conditionItemCollectorMap.get(condition.method_29325());
        if (itemSupplier != null) {
            return (List)itemSupplier.apply((Object)utils, items, condition);
        }
        return List.of();
    }

    @Override
    public <T extends class_117> List<class_1792> collectItems(IServerUtils utils, List<class_1792> items, T function) {
        TriFunction<IServerUtils, List<class_1792>, class_117, List<class_1792>> itemSupplier = this.functionItemCollectorMap.get(function.method_29321());
        if (itemSupplier != null) {
            return (List)itemSupplier.apply((Object)utils, items, function);
        }
        return List.of();
    }

    @Override
    @Nullable
    public class_3218 getServerLevel() {
        return this.serverLevel;
    }

    @Override
    @Nullable
    public class_52 getLootTable(Either<class_5321<class_52>, class_52> either) {
        return (class_52)either.map(this.lootTableMap::get, lootTable -> lootTable);
    }

    public void printServerInfo() {
        LOGGER.info("Registered {} entry item collectors", (Object)this.entryItemCollectorMap.size());
        LOGGER.info("Registered {} condition item collectors", (Object)this.conditionItemCollectorMap.size());
        LOGGER.info("Registered {} function item collectors", (Object)this.functionItemCollectorMap.size());
    }
}

