/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.network.ClearMessage;
import com.yanny.ali.network.InfoSyncLootTableMessage;
import com.yanny.ali.plugin.server.ItemCollectorUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9383;
import org.slf4j.Logger;

public abstract class AbstractServer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<InfoSyncLootTableMessage> messages = new LinkedList<InfoSyncLootTableMessage>();

    public final void readLootTables(class_9383.class_9385 manager, class_3218 level) {
        class_2378 registry = (class_2378)manager.method_58294().method_46759(class_7924.field_50079).orElseThrow();
        this.messages.clear();
        registry.method_29722().forEach(e -> PluginManager.SERVER_REGISTRY.addLootTable((class_5321<class_52>)((class_5321)e.getKey()), (class_52)e.getValue()));
        registry.method_29722().forEach(reference -> {
            class_5321 location = (class_5321)reference.getKey();
            class_52 table = (class_52)reference.getValue();
            if (table != class_52.field_948) {
                List<class_1792> items = ItemCollectorUtils.collectLootTable(PluginManager.SERVER_REGISTRY, table);
                if (!items.isEmpty()) {
                    this.messages.add(new InfoSyncLootTableMessage((class_5321<class_52>)location, table, items));
                } else {
                    LOGGER.info("LootTable {} has no items", (Object)location);
                }
            } else {
                LOGGER.warn("Ignoring {} LootTable, because it's empty or null", (Object)location);
            }
        });
        LOGGER.info("Prepared {} loot tables", (Object)this.messages.size());
    }

    public final void syncLootTables(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.sendClearMessage(serverPlayer, new ClearMessage());
            for (InfoSyncLootTableMessage message : this.messages) {
                this.sendSyncMessage(serverPlayer, message);
            }
        }
    }

    protected abstract void sendClearMessage(class_3222 var1, ClearMessage var2);

    protected abstract void sendSyncMessage(class_3222 var1, InfoSyncLootTableMessage var2);
}

