/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.compatibility.rei.ReiBaseCategory;
import com.yanny.ali.compatibility.rei.ReiBaseDisplay;
import com.yanny.ali.compatibility.rei.ReiBlockCategory;
import com.yanny.ali.compatibility.rei.ReiBlockDisplay;
import com.yanny.ali.compatibility.rei.ReiEntityCategory;
import com.yanny.ali.compatibility.rei.ReiEntityDisplay;
import com.yanny.ali.compatibility.rei.ReiGameplayCategory;
import com.yanny.ali.compatibility.rei.ReiGameplayDisplay;
import com.yanny.ali.compatibility.rei.ReiTradeCategory;
import com.yanny.ali.compatibility.rei.ReiTradeDisplay;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.registries.LootCategories;
import com.yanny.ali.registries.LootCategory;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ReiCompatibility
implements REIClientPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Holder<ReiBlockDisplay, BlockLootType, Block>> blockCategoryList = new LinkedList<Holder<ReiBlockDisplay, BlockLootType, Block>>();
    private final List<Holder<ReiEntityDisplay, EntityLootType, EntityType<?>>> entityCategoryList = new LinkedList();
    private final List<Holder<ReiGameplayDisplay, GameplayLootType, String>> gameplayCategoryList = new LinkedList<Holder<ReiGameplayDisplay, GameplayLootType, String>>();
    private final List<Holder<ReiTradeDisplay, TradeLootType, String>> tradeCategoryList = new LinkedList<Holder<ReiTradeDisplay, TradeLootType, String>>();
    private final CompletableFuture<Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>>> futureData = new CompletableFuture();

    public void registerCategories(CategoryRegistry registry) {
        this.blockCategoryList.clear();
        this.entityCategoryList.clear();
        this.gameplayCategoryList.clear();
        this.tradeCategoryList.clear();
        this.blockCategoryList.add(this.createCategory(LootCategories.PLANT_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.blockCategoryList.addAll(LootCategories.BLOCK_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiBlockDisplay::new, ReiBlockCategory::new)).collect(Collectors.toSet()));
        this.blockCategoryList.add(this.createCategory(LootCategories.BLOCK_LOOT, ReiBlockDisplay::new, ReiBlockCategory::new));
        this.entityCategoryList.addAll(LootCategories.ENTITY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiEntityDisplay::new, ReiEntityCategory::new)).collect(Collectors.toSet()));
        this.entityCategoryList.add(this.createCategory(LootCategories.ENTITY_LOOT, ReiEntityDisplay::new, ReiEntityCategory::new));
        this.gameplayCategoryList.addAll(LootCategories.GAMEPLAY_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiGameplayDisplay::new, ReiGameplayCategory::new)).collect(Collectors.toSet()));
        this.gameplayCategoryList.add(this.createCategory(LootCategories.GAMEPLAY_LOOT, ReiGameplayDisplay::new, ReiGameplayCategory::new));
        this.tradeCategoryList.addAll(LootCategories.TRADE_LOOT_CATEGORIES.entrySet().stream().map(e -> this.createCategory((Map.Entry)e, ReiTradeDisplay::new, ReiTradeCategory::new)).collect(Collectors.toSet()));
        this.tradeCategoryList.add(this.createCategory(LootCategories.TRADE_LOOT, ReiTradeDisplay::new, ReiTradeCategory::new));
        for (Holder<ReiBlockDisplay, BlockLootType, Block> holder : this.blockCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.entityCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.gameplayCategoryList) {
            registry.add(holder.category);
        }
        for (Holder<ReiBaseDisplay, Record, Object> holder : this.tradeCategoryList) {
            registry.add(holder.category);
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        PluginManager.CLIENT_REGISTRY.setOnDoneListener((lootData, tradeData) -> this.futureData.complete((Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>>)Pair.of((Object)lootData, (Object)tradeData)));
        if (!this.futureData.isDone()) {
            LOGGER.info("Blocking this thread until all data are received!");
        }
        try {
            Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>> pair = this.futureData.get(10L, TimeUnit.SECONDS);
            this.registerData(registry, (Map)pair.getLeft(), (Map)pair.getRight());
        }
        catch (TimeoutException e) {
            this.futureData.cancel(true);
            PluginManager.CLIENT_REGISTRY.clearLootData();
            LOGGER.error("Failed to received data in 10 seconds, registration aborted!");
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.error("Failed to finish registering data with error {}", (Object)e.getMessage());
        }
    }

    private void registerData(DisplayRegistry registry, Map<ResourceLocation, IDataNode> lootData, Map<ResourceLocation, IDataNode> tradeData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        ClientLevel level = Minecraft.getInstance().level;
        LOGGER.info("Adding loot information to REI");
        if (level != null) {
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap gameplayRecipeTypes = new HashMap();
            HashMap tradeRecipeTypes = new HashMap();
            GenericUtils.processData(level, clientRegistry, lootData, tradeData, (node, location, block, outputs) -> {
                for (Holder<ReiBlockDisplay, BlockLootType, Block> holder : this.blockCategoryList) {
                    if (!holder.category.getLootCategory().validate(block)) continue;
                    blockRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new BlockLootType((Block)block, (IDataNode)node, Collections.emptyList(), (List<ItemStack>)outputs));
                    break;
                }
            }, (node, location, entity, outputs) -> {
                for (Holder<ReiEntityDisplay, EntityLootType, EntityType<?>> holder : this.entityCategoryList) {
                    if (!holder.category.getLootCategory().validate(entity)) continue;
                    entityRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new EntityLootType((EntityType<?>)entity, (ResourceLocation)location, (IDataNode)node, Collections.emptyList(), (List<ItemStack>)outputs));
                    break;
                }
            }, (node, location, outputs) -> {
                for (Holder<ReiGameplayDisplay, GameplayLootType, String> holder : this.gameplayCategoryList) {
                    if (!holder.category.getLootCategory().validate(location.getPath())) continue;
                    gameplayRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new GameplayLootType((IDataNode)node, location.getPath(), Collections.emptyList(), (List<ItemStack>)outputs));
                    break;
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                for (Holder<ReiTradeDisplay, TradeLootType, String> holder : this.tradeCategoryList) {
                    if (!holder.category.getLootCategory().validate(location.getPath())) continue;
                    tradeRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new TradeLootType((IDataNode)tradeEntry, location.getPath(), (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                    break;
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                for (Holder<ReiTradeDisplay, TradeLootType, String> holder : this.tradeCategoryList) {
                    if (!holder.category.getLootCategory().validate(location.getPath())) continue;
                    tradeRecipeTypes.computeIfAbsent(holder, b -> new LinkedList()).add(new TradeLootType((IDataNode)tradeEntry, location.getPath(), (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                    break;
                }
            });
            for (Map.Entry entry : blockRecipeTypes.entrySet()) {
                registry.registerFiller(this.blockPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : entityRecipeTypes.entrySet()) {
                registry.registerFiller(this.entityPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : gameplayRecipeTypes.entrySet()) {
                registry.registerFiller(this.gameplayPredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
            for (Map.Entry entry : tradeRecipeTypes.entrySet()) {
                registry.registerFiller(this.tradePredicate((List)entry.getValue()), ((Holder)entry.getKey()).filler());
                ((List)entry.getValue()).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
            }
        } else {
            LOGGER.warn("REI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(Map.Entry<ResourceLocation, LootCategory<U>> e, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, Component, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        ResourceLocation id = e.getKey();
        CategoryIdentifier identifier = CategoryIdentifier.of((String)id.getNamespace(), (String)id.getPath());
        MutableComponent title = Component.translatable((String)("emi.category." + id.getNamespace() + "." + id.getPath().replace('/', '.')));
        Function<Object, ReiBaseDisplay> filler = type -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, e.getValue()), filler);
    }

    @NotNull
    private <D extends ReiBaseDisplay, T, U> Holder<D, T, U> createCategory(LootCategory<U> lootCategory, BiFunction<T, CategoryIdentifier<D>, D> displayFactory, TriFunction<CategoryIdentifier<D>, Component, LootCategory<U>, ReiBaseCategory<D, U>> categoryFactory) {
        CategoryIdentifier identifier = CategoryIdentifier.of((String)"ali", (String)lootCategory.getKey());
        MutableComponent title = Component.translatable((String)("emi.category.ali." + lootCategory.getKey().replace('/', '.')));
        Function<Object, ReiBaseDisplay> filler = type -> (ReiBaseDisplay)((Object)((Object)displayFactory.apply(type, identifier)));
        return new Holder(identifier, (ReiBaseCategory)categoryFactory.apply((Object)identifier, (Object)title, lootCategory), filler);
    }

    @NotNull
    private Predicate<Object> blockPredicate(List<BlockLootType> lootTypes) {
        return o -> {
            if (o != null && o instanceof BlockLootType) {
                BlockLootType type = (BlockLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private Predicate<Object> entityPredicate(List<EntityLootType> lootTypes) {
        return o -> {
            if (o != null && o instanceof EntityLootType) {
                EntityLootType type = (EntityLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private Predicate<Object> gameplayPredicate(List<GameplayLootType> lootTypes) {
        return o -> {
            if (o != null && o instanceof GameplayLootType) {
                GameplayLootType type = (GameplayLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    @NotNull
    private Predicate<Object> tradePredicate(List<TradeLootType> lootTypes) {
        return o -> {
            if (o != null && o instanceof TradeLootType) {
                TradeLootType type = (TradeLootType)o;
                return lootTypes.contains(type);
            }
            return false;
        };
    }

    private record Holder<D extends ReiBaseDisplay, T, U>(CategoryIdentifier<D> identifier, ReiBaseCategory<D, U> category, Function<T, D> filler) {
    }
}

