/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.FillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.FilteredFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionReference;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.ModifyContainerContents;
import net.minecraft.world.level.storage.loot.functions.SequenceFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetBookCoverFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetContainerLootTable;
import net.minecraft.world.level.storage.loot.functions.SetCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.SetCustomModelDataFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetFireworkExplosionFunction;
import net.minecraft.world.level.storage.loot.functions.SetFireworksFunction;
import net.minecraft.world.level.storage.loot.functions.SetInstrumentFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetLoreFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.functions.SetOminousBottleAmplifierFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.functions.SetWritableBookPagesFunction;
import net.minecraft.world.level.storage.loot.functions.SetWrittenBookPagesFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.functions.ToggleTooltips;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class FunctionTooltipUtils {
    @NotNull
    public static ITooltipNode getApplyBonusTooltip(IServerUtils utils, ApplyBonusCount fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.apply_bonus", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.enchantment", fun.enchantment, RegistriesTooltipUtils::getEnchantmentTooltip));
        tooltip.add(GenericTooltipUtils.getFormulaTooltip(utils, "ali.property.value.formula", fun.formula));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getCopyNameTooltip(IServerUtils utils, CopyNameFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.copy_name", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.source", fun.source));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getCopyCustomDataTooltip(IServerUtils utils, CopyCustomDataFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.copy_custom_data", new Object[0]));
        tooltip.add(RegistriesTooltipUtils.getLootNbtProviderTypeTooltip(utils, "ali.property.value.source", fun.source.getType()));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.copy_operations", "ali.property.branch.operation", fun.operations, GenericTooltipUtils::getCopyOperationTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getCopyStateTooltip(IServerUtils utils, CopyBlockState fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.copy_state", new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.block", fun.block, RegistriesTooltipUtils::getBlockTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.properties", "ali.property.value.null", fun.properties, GenericTooltipUtils::getPropertyTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantRandomlyTooltip(IServerUtils utils, EnchantRandomlyFunction fun) {
        ITooltipNode tooltip = fun.enchantments.isPresent() && ((HolderSet)fun.enchantments.get()).size() > 0 ? GenericTooltipUtils.getHolderSetTooltip(utils, "ali.type.function.enchant_randomly", "ali.property.value.null", (HolderSet)fun.enchantments.get(), RegistriesTooltipUtils::getEnchantmentTooltip) : new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.enchant_randomly", new Object[0]));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEnchantWithLevelsTooltip(IServerUtils utils, EnchantWithLevelsFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.enchant_with_levels", new Object[0]));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.levels", fun.levels));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.treasure", fun.treasure));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getExplorationMapTooltip(IServerUtils utils, ExplorationMapFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.exploration_map", new Object[0]));
        tooltip.add(GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.destination", fun.destination));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.map_decoration", fun.mapDecoration, RegistriesTooltipUtils::getMapDecorationTypeTooltip));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.zoom", fun.zoom));
        tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.search_radius", fun.searchRadius));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.skip_known_structures", fun.skipKnownStructures));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getExplosionDecayTooltip(IServerUtils utils, ApplyExplosionDecay fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.explosion_decay", new Object[0]));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getFillPlayerHeadTooltip(IServerUtils utils, FillPlayerHead fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.fill_player_head", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.target", fun.entityTarget));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getFurnaceSmeltTooltip(IServerUtils utils, SmeltItemFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.furnace_smelt", new Object[0]));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLimitCountTooltip(IServerUtils utils, LimitCount fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.limit_count", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.limit", fun.limiter));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getLootingEnchantTooltip(IServerUtils utils, LootingEnchantFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.looting_enchant", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.value", fun.value));
        if (fun.limit > 0) {
            tooltip.add(GenericTooltipUtils.getIntegerTooltip(utils, "ali.property.value.limit", fun.limit));
        }
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getReferenceTooltip(IServerUtils utils, FunctionReference fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.reference", new Object[0]));
        tooltip.add(GenericTooltipUtils.getResourceKeyTooltip(utils, "ali.property.value.name", fun.name));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSequenceTooltip(IServerUtils utils, SequenceFunction fun) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.function.sequence", fun.functions, utils::getFunctionTooltip);
    }

    @NotNull
    public static ITooltipNode getSetAttributesTooltip(IServerUtils utils, SetAttributesFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_attributes", new Object[0]));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.modifiers", "ali.property.branch.modifier", fun.modifiers, GenericTooltipUtils::getModifierTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.replace", fun.replace));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetBannerPatternTooltip(IServerUtils utils, SetBannerPatternFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_banner_pattern", new Object[0]));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.append", fun.append));
        tooltip.add(GenericTooltipUtils.getBannerPatternLayersTooltip(utils, "ali.property.branch.banner_patterns", fun.patterns));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetContentsTooltip(IServerUtils utils, SetContainerContents fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_contents", new Object[0]));
        tooltip.add(GenericTooltipUtils.getContainerComponentManipulatorTooltip(utils, "ali.property.value.container", fun.component));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetCountTooltip(IServerUtils utils, SetItemCountFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_count", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.count", fun.value));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.add", fun.add));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetDamageTooltip(IServerUtils utils, SetItemDamageFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_damage", new Object[0]));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.damage", fun.damage));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.add", fun.add));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetEnchantmentsTooltip(IServerUtils utils, SetEnchantmentsFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_enchantments", new Object[0]));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.enchantments", fun.enchantments, GenericTooltipUtils::getEnchantmentLevelsEntryTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.add", fun.add));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetInstrumentTooltip(IServerUtils utils, SetInstrumentFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_instrument", new Object[0]));
        tooltip.add(GenericTooltipUtils.getTagKeyTooltip(utils, "ali.property.value.options", fun.options));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetLootTableTooltip(IServerUtils utils, SetContainerLootTable fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_loot_table", new Object[0]));
        tooltip.add(GenericTooltipUtils.getResourceKeyTooltip(utils, "ali.property.value.name", fun.name));
        tooltip.add(GenericTooltipUtils.getLongTooltip(utils, "ali.property.value.seed", fun.seed));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.block_entity_type", fun.type, RegistriesTooltipUtils::getBlockEntityTypeTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetLoreTooltip(IServerUtils utils, SetLoreFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_lore", new Object[0]));
        tooltip.add(GenericTooltipUtils.getListOperationTooltip(utils, "ali.property.value.list_operation", fun.mode));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.lore", "ali.property.value.null", fun.lore, GenericTooltipUtils::getComponentTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.resolution_context", fun.resolutionContext, GenericTooltipUtils::getEnumTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetNameTooltip(IServerUtils utils, SetNameFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_name", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.name", fun.name, GenericTooltipUtils::getComponentTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.resolution_context", fun.resolutionContext, GenericTooltipUtils::getEnumTooltip));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.target", fun.target));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetCustomDataTooltip(IServerUtils utils, SetCustomDataFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_custom_data", new Object[0]));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.tag", fun.tag.getAsString()));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetPotionTooltip(IServerUtils utils, SetPotionFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_potion", new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.potion", fun.potion, RegistriesTooltipUtils::getPotionTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetStewEffectTooltip(IServerUtils utils, SetStewEffectFunction fun) {
        ITooltipNode tooltip = !fun.effects.isEmpty() ? GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.function.set_stew_effect", "ali.property.value.null", fun.effects, GenericTooltipUtils::getEffectEntryTooltip) : new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_stew_effect", new Object[0]));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetItemTooltip(IServerUtils utils, SetItemFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_item", new Object[0]));
        tooltip.add(GenericTooltipUtils.getHolderTooltip(utils, "ali.property.value.item", fun.item, RegistriesTooltipUtils::getItemTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetComponentsTooltip(IServerUtils utils, SetComponentsFunction fun) {
        ITooltipNode tooltip = GenericTooltipUtils.getDataComponentPatchTooltip(utils, "ali.type.function.set_components", fun.components);
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getModifyContentsTooltip(IServerUtils utils, ModifyContainerContents fun) {
        TooltipNode tooltips = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.modify_contents", new Object[0]));
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.modifier", new Object[0]));
        tooltips.add(GenericTooltipUtils.getContainerComponentManipulatorTooltip(utils, "ali.property.value.container", fun.component));
        tooltips.add(tooltip);
        tooltips.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        tooltip.add(utils.getFunctionTooltip(utils, fun.modifier));
        return tooltips;
    }

    @NotNull
    public static ITooltipNode getFilteredTooltip(IServerUtils utils, FilteredFunction fun) {
        TooltipNode tooltips = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.filtered", new Object[0]));
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.property.branch.modifier", new Object[0]));
        tooltips.add(GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.property.branch.filter", fun.filter));
        tooltips.add(tooltip);
        tooltips.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        tooltip.add(utils.getFunctionTooltip(utils, fun.modifier));
        return tooltips;
    }

    @NotNull
    public static ITooltipNode getCopyComponentsTooltip(IServerUtils utils, CopyComponentsFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.copy_components", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.source", fun.source));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.include", "ali.property.value.null", fun.include, RegistriesTooltipUtils::getDataComponentTypeTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.exclude", "ali.property.value.null", fun.exclude, RegistriesTooltipUtils::getDataComponentTypeTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetFireworksTooltip(IServerUtils utils, SetFireworksFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_fireworks", new Object[0]));
        tooltip.add(GenericTooltipUtils.getStandaloneTooltip(utils, "ali.property.branch.explosions", "ali.property.branch.explosion", fun.explosions, GenericTooltipUtils::getFireworkExplosionTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.flight_duration", fun.flightDuration, GenericTooltipUtils::getIntegerTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetFireworkExplosionTooltip(IServerUtils utils, SetFireworkExplosionFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_firework_explosion", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.shape", fun.shape, GenericTooltipUtils::getEnumTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.colors", fun.colors, GenericTooltipUtils::getIntListTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.fade_colors", fun.fadeColors, GenericTooltipUtils::getIntListTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.trail", fun.trail, GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.twinkle", fun.twinkle, GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetBookCoverTooltip(IServerUtils utils, SetBookCoverFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_book_cover", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.author", fun.author, GenericTooltipUtils::getStringTooltip));
        tooltip.add(GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.title", fun.title, GenericTooltipUtils::getStringTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.generation", fun.generation, GenericTooltipUtils::getIntegerTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetWrittenBookPagesTooltip(IServerUtils utils, SetWrittenBookPagesFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_written_book_pages", new Object[0]));
        tooltip.add(GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.pages", "ali.property.branch.page", fun.pages, GenericTooltipUtils::getComponentTooltip));
        tooltip.add(GenericTooltipUtils.getListOperationTooltip(utils, "ali.property.value.list_operation", fun.pageOperation));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetWritableBookPagesTooltip(IServerUtils utils, SetWritableBookPagesFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_writable_book_pages", new Object[0]));
        tooltip.add(GenericTooltipUtils.getFilterableTooltip(utils, "ali.property.branch.pages", "ali.property.branch.page", fun.pages, GenericTooltipUtils::getStringTooltip));
        tooltip.add(GenericTooltipUtils.getListOperationTooltip(utils, "ali.property.value.list_operation", fun.pageOperation));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getToggleTooltipsTooltip(IServerUtils utils, ToggleTooltips fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.toggle_tooltips", new Object[0]));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.components", fun.values, GenericTooltipUtils::getToggleEntryTooltip));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetOminousBottleAmplifierTooltip(IServerUtils utils, SetOminousBottleAmplifierFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_ominous_bottle_amplifier", new Object[0]));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.amplifier", fun.amplifierGenerator));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getSetCustomModelDataTooltip(IServerUtils utils, SetCustomModelDataFunction fun) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.function.set_custom_model_data", new Object[0]));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.value", fun.valueProvider));
        tooltip.add(GenericTooltipUtils.getSubConditionsTooltip(utils, fun.predicates));
        return tooltip;
    }
}

