/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import com.yanny.ali.api.ITooltipNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class TooltipNode
implements ITooltipNode {
    private final class_2561 component;
    private final boolean advancedTooltip;
    @Nullable
    private List<ITooltipNode> children = null;

    public TooltipNode() {
        this((class_2561)class_2561.method_43473(), false);
    }

    public TooltipNode(class_2561 component) {
        this(component, false);
    }

    public TooltipNode(class_2561 component, boolean advancedTooltip) {
        this.component = component;
        this.advancedTooltip = advancedTooltip;
    }

    public TooltipNode(class_2540 buf) {
        int count = buf.readInt();
        this.advancedTooltip = buf.readBoolean();
        this.component = buf.method_10808();
        if (count == 0) {
            this.children = Collections.emptyList();
        } else if (count == 1) {
            this.children = Collections.singletonList(new TooltipNode(buf));
        } else {
            this.children = new ArrayList<ITooltipNode>(count);
            for (int i = 0; i < count; ++i) {
                this.children.add(new TooltipNode(buf));
            }
        }
    }

    @Override
    public void add(ITooltipNode node) {
        if (this.children == null) {
            this.children = new ArrayList<ITooltipNode>();
        }
        this.children.add(node);
    }

    @Override
    public List<ITooltipNode> getChildren() {
        return Objects.requireNonNullElse(this.children, Collections.emptyList());
    }

    @Override
    public class_2561 getContent() {
        return this.component;
    }

    @Override
    public boolean isAdvancedTooltip() {
        return this.advancedTooltip;
    }

    @Override
    public void encode(class_2540 buf) {
        List<ITooltipNode> children = this.getChildren();
        buf.writeInt(children.size());
        buf.writeBoolean(this.advancedTooltip);
        buf.method_10805(this.component);
        for (ITooltipNode child : children) {
            child.encode(buf);
        }
    }
}

