/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.nodes.LootPoolNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;

public class LootTableNode
extends ListNode {
    public static final class_2960 ID = new class_2960("ali", "loot_table");
    private final List<ITooltipNode> tooltip;

    public LootTableNode(List<ILootModifier<?>> modifiers, IServerUtils utils, class_52 lootTable) {
        this(modifiers, utils, lootTable, 1.0f, Collections.emptyList(), Collections.emptyList());
    }

    public LootTableNode(IServerUtils utils, class_52 lootTable, float chance, List<class_117> functions, List<class_5341> conditions) {
        this(Collections.emptyList(), utils, lootTable, chance, functions, conditions);
    }

    public LootTableNode(List<ILootModifier<?>> modifiers, IServerUtils utils, class_52 lootTable, float chance, List<class_117> functions, List<class_5341> conditions) {
        List<class_117> allFunctions = Stream.concat(functions.stream(), Arrays.stream(lootTable.field_944)).toList();
        this.tooltip = EntryTooltipUtils.getLootTableTooltip();
        for (class_55 class_552 : utils.getLootPools(lootTable)) {
            this.addChildren(new LootPoolNode(Collections.emptyList(), utils, class_552, chance, allFunctions, conditions));
        }
        for (ILootModifier iLootModifier : modifiers) {
            NodeUtils.processLootModifier(utils, iLootModifier, this);
        }
    }

    public LootTableNode(IClientUtils utils, class_2540 buf) {
        super(utils, buf);
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
    }

    @Override
    public void encodeNode(IServerUtils utils, class_2540 buf) {
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }
}

