/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_83;

public class ReferenceNode
extends ListNode {
    public static final class_2960 ID = new class_2960("ali", "reference");
    private final List<ITooltipNode> tooltip;
    private final float chance;

    public ReferenceNode(IServerUtils utils, class_83 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        List<class_117> allFunctions = Stream.concat(functions.stream(), Arrays.stream(entry.field_996)).toList();
        List<class_5341> allConditions = Stream.concat(conditions.stream(), Arrays.stream(entry.field_988)).toList();
        class_52 lootTable = utils.getLootTable(entry.field_993);
        if (lootTable != null) {
            this.addChildren(new LootTableNode(utils, lootTable, chance * (float)entry.field_995 / (float)sumWeight, allFunctions, allConditions));
        } else {
            this.addChildren(new MissingNode());
        }
        this.chance = chance * (float)entry.field_995 / (float)sumWeight;
        this.tooltip = EntryTooltipUtils.getReferenceTooltip(entry, chance, sumWeight);
    }

    public ReferenceNode(IClientUtils utils, class_2540 buf) {
        super(utils, buf);
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
        this.chance = buf.readFloat();
    }

    @Override
    public void encodeNode(IServerUtils utils, class_2540 buf) {
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
        buf.writeFloat(this.chance);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public float getChance() {
        return this.chance;
    }
}

