/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs;

import com.almostreliable.lootjs.core.LootEntry;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.mixin.MixinLootEntry;
import com.yanny.ali.plugin.lootjs.node.ItemStackNode;
import com.yanny.ali.plugin.lootjs.node.ItemTagNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_79;
import org.jetbrains.annotations.NotNull;

public class Utils {
    @NotNull
    public static <T> List<T> getCapturedInstances(Predicate<?> predicate, Class<T> requiredType) {
        ArrayList<T> instances = new ArrayList<T>();
        try {
            Field[] fields;
            for (Field field : fields = predicate.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object entry = field.get(predicate);
                if (!requiredType.isInstance(entry)) continue;
                instances.add(requiredType.cast(entry));
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Error while accessing field: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Security error while accessing field: " + e.getMessage());
        }
        return instances;
    }

    public static IDataNode getEntry(IServerUtils utils, LootEntry entry, int sumWeight, List<class_117> functions, List<class_5341> conditions, boolean preserveCount) {
        MixinLootEntry mixinLootEntry = (MixinLootEntry)entry;
        List<class_117> allFunctions = Stream.concat(functions.stream(), mixinLootEntry.getPostModifications().stream()).toList();
        List<class_5341> allConditions = Stream.concat(conditions.stream(), mixinLootEntry.getConditions().stream()).toList();
        LootEntry.Generator generator = mixinLootEntry.getGenerator();
        int weight = mixinLootEntry.getWeight();
        if (generator instanceof LootEntry.ItemGenerator) {
            LootEntry.ItemGenerator itemGenerator = (LootEntry.ItemGenerator)generator;
            return new ItemStackNode(utils, itemGenerator.item(), (float)weight / (float)sumWeight, allFunctions, allConditions, preserveCount);
        }
        if (generator instanceof LootEntry.VanillaWrappedLootEntry) {
            LootEntry.VanillaWrappedLootEntry lootEntry = (LootEntry.VanillaWrappedLootEntry)generator;
            class_79 entryContainer = lootEntry.entry();
            return utils.getEntryFactory(utils, entryContainer).create(utils, entryContainer, 1.0f, sumWeight, allFunctions, allConditions);
        }
        if (generator instanceof LootEntry.RandomIngredientGenerator) {
            LootEntry.RandomIngredientGenerator ingredientGenerator = (LootEntry.RandomIngredientGenerator)generator;
            class_1856 ingredient = ingredientGenerator.ingredient();
            if (ingredient.field_9019.length > 0) {
                class_1856.class_1859 value = ingredient.field_9019[0];
                if (value instanceof class_1856.class_1857) {
                    class_1856.class_1857 itemValue = (class_1856.class_1857)value;
                    return new ItemStackNode(utils, itemValue.field_9021, (float)weight / (float)sumWeight, allFunctions, allConditions, preserveCount);
                }
                if (value instanceof class_1856.class_1858) {
                    class_1856.class_1858 tagValue = (class_1856.class_1858)value;
                    return new ItemTagNode(utils, (class_6862<? extends class_1935>)tagValue.field_9022, (float)weight / (float)sumWeight, allFunctions, allConditions, preserveCount);
                }
                throw new IllegalStateException("Invalid ingredient type: " + value.getClass().getCanonicalName());
            }
            throw new IllegalStateException("Ingredient has no entries");
        }
        throw new IllegalStateException("Invalid generator type: " + generator.getClass().getCanonicalName());
    }
}

