/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs.server;

import com.almostreliable.lootjs.core.ILootCondition;
import com.almostreliable.lootjs.loot.condition.AndCondition;
import com.almostreliable.lootjs.loot.condition.AnyBiomeCheck;
import com.almostreliable.lootjs.loot.condition.AnyDimension;
import com.almostreliable.lootjs.loot.condition.AnyStructure;
import com.almostreliable.lootjs.loot.condition.BiomeCheck;
import com.almostreliable.lootjs.loot.condition.ContainsLootCondition;
import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.LootItemConditionWrapper;
import com.almostreliable.lootjs.loot.condition.MainHandTableBonus;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.NotCondition;
import com.almostreliable.lootjs.loot.condition.OrCondition;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.almostreliable.lootjs.loot.condition.WrappedDamageSourceCondition;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.mixin.MixinAndCondition;
import com.yanny.ali.mixin.MixinAnyDimension;
import com.yanny.ali.mixin.MixinAnyStructure;
import com.yanny.ali.mixin.MixinBiomeCheck;
import com.yanny.ali.mixin.MixinContainsLootCondition;
import com.yanny.ali.mixin.MixinCustomParamPredicate;
import com.yanny.ali.mixin.MixinIsLightLevel;
import com.yanny.ali.mixin.MixinLootItemConditionWrapper;
import com.yanny.ali.mixin.MixinMainHandTableBonus;
import com.yanny.ali.mixin.MixinMatchEquipmentSlot;
import com.yanny.ali.mixin.MixinMatchKillerDistance;
import com.yanny.ali.mixin.MixinMatchPlayer;
import com.yanny.ali.mixin.MixinNotCondition;
import com.yanny.ali.mixin.MixinOrCondition;
import com.yanny.ali.mixin.MixinWrappedDamageSourceCondition;
import com.yanny.ali.plugin.lootjs.server.LootJsGenericTooltipUtils;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_181;
import net.minecraft.class_42;
import net.minecraft.class_5341;
import org.jetbrains.annotations.NotNull;

public class LootJsConditionTooltipUtils {
    @NotNull
    public static ITooltipNode andConditionTooltip(IServerUtils utils, AndCondition condition) {
        List<ILootCondition> conditions = List.of(((MixinAndCondition)condition).getConditions());
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.condition.and", conditions, utils::getConditionTooltip);
    }

    @NotNull
    public static ITooltipNode anyBiomeCheckTooltip(IServerUtils utils, AnyBiomeCheck condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.any_biome", new Object[0]));
        MixinBiomeCheck cond = (MixinBiomeCheck)condition;
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.biomes", "ali.property.value.null", cond.getBiomes(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.tags", "ali.property.value.null", cond.getTags(), GenericTooltipUtils::getTagKeyTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode anyDimensionTooltip(IServerUtils utils, AnyDimension condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.any_dimension", new Object[0]));
        MixinAnyDimension cond = (MixinAnyDimension)condition;
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.dimensions", "ali.property.value.null", Arrays.asList(cond.getDimensions()), GenericTooltipUtils::getResourceLocationTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode anyStructureTooltip(IServerUtils utils, AnyStructure condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.any_structure", new Object[0]));
        MixinAnyStructure cond = (MixinAnyStructure)condition;
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.structures", "ali.property.value.null", cond.getStructureLocators(), LootJsGenericTooltipUtils::getStructureLocatorTooltip));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.exact", cond.getExact()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode biomeCheckTooltip(IServerUtils utils, BiomeCheck condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.biome", new Object[0]));
        MixinBiomeCheck cond = (MixinBiomeCheck)condition;
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.biomes", "ali.property.value.null", cond.getBiomes(), GenericTooltipUtils::getResourceKeyTooltip));
        tooltip.add(GenericTooltipUtils.getCollectionTooltip(utils, "ali.property.branch.tags", "ali.property.value.null", cond.getTags(), GenericTooltipUtils::getTagKeyTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode containsLootConditionTooltip(IServerUtils utils, ContainsLootCondition condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_loot", new Object[0]));
        MixinContainsLootCondition cond = (MixinContainsLootCondition)condition;
        tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", cond.getPredicate()));
        tooltip.add(GenericTooltipUtils.getBooleanTooltip(utils, "ali.property.value.exact", cond.getExact()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode customParamPredicateTooltip(IServerUtils ignoredUtils, CustomParamPredicate<?> condition) {
        MixinCustomParamPredicate cond = (MixinCustomParamPredicate)condition;
        if (cond.getParam() == class_181.field_1226) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.entity_predicate", new Object[0]));
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
            return tooltip;
        }
        if (cond.getParam() == class_181.field_1230) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.killer_predicate", new Object[0]));
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
            return tooltip;
        }
        if (cond.getParam() == class_181.field_1227) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.direct_killer_predicate", new Object[0]));
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
            return tooltip;
        }
        if (cond.getParam() == class_181.field_1228) {
            TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.block_predicate", new Object[0]));
            tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
            return tooltip;
        }
        return new TooltipNode();
    }

    @NotNull
    public static ITooltipNode isLightLevelTooltip(IServerUtils utils, IsLightLevel condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.light_level", new Object[0]));
        MixinIsLightLevel cond = (MixinIsLightLevel)condition;
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.value", class_42.method_282((int)cond.getMin(), (int)cond.getMax())));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode lootItemConditionWrapperTooltip(IServerUtils utils, LootItemConditionWrapper condition) {
        return utils.getConditionTooltip(utils, ((MixinLootItemConditionWrapper)condition).getCondition());
    }

    @NotNull
    public static ITooltipNode mainHandTableBonusTooltip(IServerUtils utils, MainHandTableBonus condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.random_chance_with_enchantment", new Object[0]));
        MixinMainHandTableBonus cond = (MixinMainHandTableBonus)condition;
        tooltip.add(RegistriesTooltipUtils.getEnchantmentTooltip(utils, "ali.property.value.enchantment", cond.getEnchantment()));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.values", Arrays.toString(cond.getValues())));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMatchEquipmentSlotTooltip(IServerUtils utils, MatchEquipmentSlot condition) {
        MixinMatchEquipmentSlot cond = (MixinMatchEquipmentSlot)condition;
        switch (cond.getSlot()) {
            case field_6173: {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_mainhand", new Object[0]));
                tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", cond.getPredicate()));
                return tooltip;
            }
            case field_6171: {
                TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_offhand", new Object[0]));
                tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", cond.getPredicate()));
                return tooltip;
            }
        }
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_equipment_slot", new Object[0]));
        tooltip.add(LootJsGenericTooltipUtils.getItemFilterTooltip(utils, "ali.property.value.item_filter", cond.getPredicate()));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.slot", cond.getSlot()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode matchKillerDistanceTooltip(IServerUtils utils, MatchKillerDistance condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.distance_to_killer", new Object[0]));
        MixinMatchKillerDistance cond = (MixinMatchKillerDistance)condition;
        tooltip.add(GenericTooltipUtils.getDistancePredicateTooltip(utils, "ali.property.value.predicate", cond.getPredicate()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode matchPlayerTooltip(IServerUtils utils, MatchPlayer condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_player", new Object[0]));
        MixinMatchPlayer cond = (MixinMatchPlayer)condition;
        tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.value.predicate", cond.getPredicate()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode notConditionTooltip(IServerUtils utils, NotCondition condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.not", new Object[0]));
        MixinNotCondition cond = (MixinNotCondition)condition;
        tooltip.add(utils.getConditionTooltip(utils, (class_5341)cond.getCondition()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode orConditionTooltip(IServerUtils utils, OrCondition condition) {
        List<ILootCondition> conditions = List.of(((MixinOrCondition)condition).getConditions());
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.condition.or", conditions, utils::getConditionTooltip);
    }

    @NotNull
    public static ITooltipNode playerParamPredicateTooltip(IServerUtils ignoredUtils, PlayerParamPredicate ignoredCondition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.player_predicate", new Object[0]));
        tooltip.add(new TooltipNode(GenericTooltipUtils.translatable("ali.property.value.detail_not_available", new Object[0])));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode wrapperDamageSourceConditionTooltip(IServerUtils utils, WrappedDamageSourceCondition condition) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.match_damage_source", new Object[0]));
        MixinWrappedDamageSourceCondition cond = (MixinWrappedDamageSourceCondition)condition;
        List<String> sourceNames = cond.getSourceNames() != null ? Arrays.asList(cond.getSourceNames()) : null;
        tooltip.add(GenericTooltipUtils.getDamageSourcePredicateTooltip(utils, "ali.property.branch.predicate", cond.getPredicate()));
        tooltip.add(GenericTooltipUtils.getOptionalCollectionTooltip(utils, "ali.property.branch.source_names", "ali.property.value.null", sourceNames, GenericTooltipUtils::getStringTooltip));
        return tooltip;
    }
}

