/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import com.yanny.ali.plugin.server.RegistriesTooltipUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_182;
import net.minecraft.class_190;
import net.minecraft.class_199;
import net.minecraft.class_201;
import net.minecraft.class_205;
import net.minecraft.class_207;
import net.minecraft.class_212;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_221;
import net.minecraft.class_223;
import net.minecraft.class_225;
import net.minecraft.class_227;
import net.minecraft.class_2338;
import net.minecraft.class_4568;
import net.minecraft.class_4571;
import net.minecraft.class_5644;
import net.minecraft.class_8548;
import net.minecraft.class_8551;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ConditionTooltipUtils {
    private static final DecimalFormat FLOAT_FORMAT = new DecimalFormat("0.####");

    @NotNull
    public static ITooltipNode getAllOfTooltip(IServerUtils utils, class_8548 cond) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.condition.all_of", List.of(cond.field_1246), utils::getConditionTooltip);
    }

    @NotNull
    public static ITooltipNode getAnyOfTooltip(IServerUtils utils, class_8551 cond) {
        return GenericTooltipUtils.getCollectionTooltip(utils, "ali.type.condition.any_of", List.of(cond.field_1246), utils::getConditionTooltip);
    }

    @NotNull
    public static ITooltipNode getBlockStatePropertyTooltip(IServerUtils utils, class_212 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.block_state_property", new Object[0]));
        tooltip.add(RegistriesTooltipUtils.getBlockTooltip(utils, "ali.property.value.block", cond.field_1286));
        tooltip.add(GenericTooltipUtils.getStatePropertiesPredicateTooltip(utils, "ali.property.branch.properties", cond.field_1288));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getDamageSourcePropertiesTooltip(IServerUtils utils, class_190 cond) {
        return GenericTooltipUtils.getDamageSourcePredicateTooltip(utils, "ali.type.condition.damage_source_properties", cond.field_1256);
    }

    @NotNull
    public static ITooltipNode getEntityPropertiesTooltip(IServerUtils utils, class_215 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.entity_properties", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.target", cond.field_1292));
        tooltip.add(GenericTooltipUtils.getEntityPredicateTooltip(utils, "ali.property.branch.predicate", cond.field_1293));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getEntityScoresTooltip(IServerUtils utils, class_199 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.entity_scores", new Object[0]));
        tooltip.add(GenericTooltipUtils.getEnumTooltip(utils, "ali.property.value.target", cond.field_1278));
        tooltip.add(GenericTooltipUtils.getMapTooltip(utils, "ali.property.branch.scores", cond.field_1279, GenericTooltipUtils::getIntRangeEntryTooltip));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getInvertedTooltip(IServerUtils utils, class_207 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.inverted", new Object[0]));
        tooltip.add(utils.getConditionTooltip(utils, cond.field_1283));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getKilledByPlayerTooltip(IServerUtils ignoredUtils, class_221 ignoredCond) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.killed_by_player", new Object[0]));
    }

    @NotNull
    public static ITooltipNode getLocationCheckTooltip(IServerUtils utils, class_205 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.location_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getLocationPredicateTooltip(utils, "ali.property.branch.location", cond.field_1282));
        if (!cond.field_20765.equals((Object)class_2338.field_10980)) {
            tooltip.add(GenericTooltipUtils.getBlockPosTooltip(utils, "ali.property.multi.offset", cond.field_20765));
        }
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getMatchToolTooltip(IServerUtils utils, class_223 cond) {
        return GenericTooltipUtils.getItemPredicateTooltip(utils, "ali.type.condition.match_tool", cond.field_1298);
    }

    @NotNull
    public static ITooltipNode getRandomChanceTooltip(IServerUtils utils, class_219 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.random_chance", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.probability", Float.valueOf(cond.field_1296)));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getRandomChanceWithLootingTooltip(IServerUtils utils, class_225 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.random_chance_with_looting", new Object[0]), true);
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.percent", Float.valueOf(cond.field_1300)));
        tooltip.add(GenericTooltipUtils.getFloatTooltip(utils, "ali.property.value.multiplier", Float.valueOf(cond.field_1299)));
        return tooltip;
    }

    public static @Unmodifiable @NotNull ITooltipNode getReferenceTooltip(IServerUtils utils, class_4568 cond) {
        return GenericTooltipUtils.getResourceLocationTooltip(utils, "ali.type.condition.reference", cond.field_20764);
    }

    public static @Unmodifiable @NotNull ITooltipNode getSurvivesExplosionTooltip(IServerUtils ignoredUtils, class_201 ignoredCond) {
        return new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.survives_explosion", new Object[0]));
    }

    @NotNull
    public static ITooltipNode getTableBonusTooltip(IServerUtils utils, class_182 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.table_bonus", new Object[0]), true);
        List<String> list = IntStream.range(0, cond.field_1235.length).mapToDouble(i -> cond.field_1235[i]).mapToObj(FLOAT_FORMAT::format).toList();
        tooltip.add(RegistriesTooltipUtils.getEnchantmentTooltip(utils, "ali.property.value.enchantment", cond.field_1234));
        tooltip.add(GenericTooltipUtils.getStringTooltip(utils, "ali.property.value.values", list.toString()));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getTimeCheckTooltip(IServerUtils utils, class_4571 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.time_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.period", cond.field_20767, GenericTooltipUtils::getLongTooltip));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.value", cond.field_20768));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getValueCheckTooltip(IServerUtils utils, class_5644 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.value_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getNumberProviderTooltip(utils, "ali.property.value.provider", cond.field_27912));
        tooltip.add(GenericTooltipUtils.getIntRangeTooltip(utils, "ali.property.value.range", cond.field_27913));
        return tooltip;
    }

    @NotNull
    public static ITooltipNode getWeatherCheckTooltip(IServerUtils utils, class_227 cond) {
        TooltipNode tooltip = new TooltipNode(GenericTooltipUtils.translatable("ali.type.condition.weather_check", new Object[0]));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_raining", cond.field_1302, GenericTooltipUtils::getBooleanTooltip));
        tooltip.add(GenericTooltipUtils.getOptionalTooltip(utils, "ali.property.value.is_thundering", cond.field_1301, GenericTooltipUtils::getBooleanTooltip));
        return tooltip;
    }
}

