/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ItemNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = new ResourceLocation("ali", "item");
    private final List<ITooltipNode> tooltip;
    private final List<LootItemCondition> conditions;
    private final List<LootItemFunction> functions;
    private final ItemStack itemStack;
    private final RangeValue count;
    private final float chance;

    public ItemNode(IServerUtils utils, LootItem entry, float chance, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this.conditions = Stream.concat(conditions.stream(), entry.f_79636_.stream()).toList();
        this.functions = Stream.concat(functions.stream(), entry.f_79677_.stream()).toList();
        this.chance = chance * (float)entry.f_79675_ / (float)sumWeight;
        this.itemStack = TooltipUtils.getItemStack(utils, ((Item)entry.f_79564_.m_203334_()).m_7968_(), this.functions);
        this.tooltip = EntryTooltipUtils.getSingletonTooltip(utils, (LootPoolSingletonContainer)entry, chance, sumWeight, functions, conditions);
        this.count = TooltipUtils.getCount(utils, this.functions).get(null).get(0);
    }

    public ItemNode(IServerUtils utils, Item item, RangeValue count) {
        this(utils, item, count, Collections.emptyList());
    }

    public ItemNode(IServerUtils ignoredUtils, Item item, RangeValue count, List<ITooltipNode> tooltip) {
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
        this.chance = 1.0f;
        this.itemStack = item.m_7968_();
        this.tooltip = tooltip;
        this.count = count;
    }

    public ItemNode(IClientUtils utils, FriendlyByteBuf buf) {
        this.itemStack = buf.m_130267_();
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
        this.count = new RangeValue(buf);
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
        this.chance = 1.0f;
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return Either.left((Object)this.itemStack);
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
        this.count.encode(buf);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

