/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBlockLoot;
import com.yanny.ali.compatibility.emi.EmiEntityLoot;
import com.yanny.ali.compatibility.emi.EmiGameplayLoot;
import com.yanny.ali.compatibility.emi.EmiTradeLoot;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliCommonRegistry;
import com.yanny.ali.manager.PluginManager;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EmiEntrypoint
public class EmiCompatibility
implements EmiPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void register(EmiRegistry emiRegistry) {
        CompletableFuture<Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>>> futureData = PluginManager.CLIENT_REGISTRY.getCurrentDataFuture();
        if (futureData.isDone()) {
            LOGGER.info("Data already received, processing instantly.");
        } else {
            LOGGER.info("Blocking this thread until all data are received!");
        }
        try {
            Pair<Map<ResourceLocation, IDataNode>, Map<ResourceLocation, IDataNode>> pair = futureData.get();
            this.registerData(emiRegistry, (Map)pair.getLeft(), (Map)pair.getRight());
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof TimeoutException) {
                futureData.cancel(true);
                PluginManager.CLIENT_REGISTRY.clearLootData();
                LOGGER.error("Failed to received data: Inactivity timeout occurred. Registration aborted!");
            } else {
                LOGGER.error("Failed to finish registering data with error {}", (Object)cause.getMessage());
                cause.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.error("Failed to finish registering data with unexpected error {}", (Object)e.getMessage());
        }
    }

    private void registerData(EmiRegistry registry, Map<ResourceLocation, IDataNode> lootData, Map<ResourceLocation, IDataNode> tradeData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        AliCommonRegistry commonRegistry = PluginManager.COMMON_REGISTRY;
        AliConfig config = commonRegistry.getConfiguration();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LOGGER.info("Adding loot information to EMI");
        if (level != null) {
            Map blockCategories = config.blockCategories.stream().collect(EmiCompatibility.getCollector());
            Map entityCategories = config.entityCategories.stream().collect(EmiCompatibility.getCollector());
            Map gameplayCategories = config.gameplayCategories.stream().collect(EmiCompatibility.getCollector());
            Map tradeCategories = config.tradeCategories.stream().collect(EmiCompatibility.getCollector());
            blockCategories.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            entityCategories.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            gameplayCategories.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            tradeCategories.values().forEach(arg_0 -> ((EmiRegistry)registry).addCategory(arg_0));
            GenericUtils.processData(level, clientRegistry, config, lootData, tradeData, (node, location, block, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : blockCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(block)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiBlockLoot(category, (ResourceLocation)location, (Block)block, (IDataNode)node, (List<ItemStack>)outputs));
                }
            }, (node, location, entity, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : entityCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(entity)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiEntityLoot(category, (ResourceLocation)location, (EntityType<?>)entity, (IDataNode)node, (List<ItemStack>)outputs));
                }
            }, (node, location, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : gameplayCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(location)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiGameplayLoot(category, (ResourceLocation)location, (IDataNode)node, (List<ItemStack>)outputs));
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : tradeCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(location)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiTradeLoot(category, (ResourceLocation)location, (IDataNode)tradeEntry, (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                }
            }, (tradeEntry, location, inputs, outputs) -> {
                EmiRecipeCategory category = null;
                for (Map.Entry entry : tradeCategories.entrySet()) {
                    if (!((LootCategory)entry.getKey()).validate(location)) continue;
                    if (((LootCategory)entry.getKey()).isHidden()) {
                        return;
                    }
                    category = (EmiRecipeCategory)entry.getValue();
                    break;
                }
                if (category != null) {
                    registry.addRecipe((EmiRecipe)new EmiTradeLoot(category, (ResourceLocation)location, (IDataNode)tradeEntry, (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                }
            });
        } else {
            LOGGER.warn("EMI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    private static <T> Collector<LootCategory<T>, ?, Map<LootCategory<T>, EmiRecipeCategory>> getCollector() {
        return Collectors.toMap(r -> r, r -> new EmiRecipeCategory(r.getKey(), (EmiRenderable)EmiStack.of((ItemLike)r.getIcon())), (e, r) -> e, LinkedHashMap::new);
    }
}

