/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliClientRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class GenericUtils {
    private static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = Minecraft.m_91087_().f_91062_.m_92895_("...");

    public static void renderEntity(Entity entity, Rect bounds, int fullWidth, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Window window = minecraft.m_91268_();
        PoseStack poseStack = guiGraphics.m_280168_();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvpMatrix = projectionMatrix.mul((Matrix4fc)modelViewMatrix);
        Vector4f topLeftWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f topLeftClip = mvpMatrix.transform(topLeftWorld);
        Vector4f topLeftNDC = new Vector4f(topLeftClip.x / topLeftClip.w, topLeftClip.y / topLeftClip.w, 0.0f, 1.0f);
        int screenX = Math.round((topLeftNDC.x + 1.0f) / 2.0f * (float)window.m_85445_());
        int screenY = Math.round((1.0f - topLeftNDC.y) / 2.0f * (float)window.m_85446_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280411_(TEXTURE_LOC, bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0.0f, 36.0f, 36, 36, 256, 256);
            guiGraphics.m_280588_(screenX + bounds.x() + 1, screenY + bounds.y() + 1, screenX + bounds.right() - 1, screenY + bounds.bottom() - 1);
            EntityDimensions dimensions = entity.m_6095_().m_20680_();
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(-screenX + bounds.x()), (int)(-screenY + bounds.y()), (int)(screenX + bounds.right()), (int)(screenY + bounds.bottom()), (int)((int)Math.min(20.0f / dimensions.f_20378_, 20.0f / dimensions.f_20377_)), (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
            guiGraphics.m_280618_();
            guiGraphics.m_280168_().m_85849_();
        }
    }

    @NotNull
    public static Component ellipsis(String text, String fallback, int maxWidth) {
        Font font = Minecraft.m_91087_().f_91062_;
        text = Language.m_128107_().m_118919_(text, GenericUtils.getFallbackText(fallback));
        if (font.m_92895_(text) > maxWidth) {
            int index = 20;
            while (font.m_92895_(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return Component.m_237113_((String)(text.substring(0, index) + "..."));
        }
        return Component.m_237113_((String)text);
    }

    public static void processData(ClientLevel level, AliClientRegistry clientRegistry, AliConfig config, Map<ResourceLocation, IDataNode> lootData, Map<ResourceLocation, IDataNode> tradeData, QuadConsumer<IDataNode, ResourceLocation, Block, List<ItemStack>> blockConsumer, QuadConsumer<IDataNode, ResourceLocation, EntityType<?>, List<ItemStack>> entityConsumer, TriConsumer<IDataNode, ResourceLocation, List<ItemStack>> gameplayConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> traderConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> wanderingTraderConsumer) {
        List<ItemStack> outputs;
        List<ItemStack> inputs;
        IDataNode tradeEntry;
        ResourceLocation location;
        for (Block block : BuiltInRegistries.f_256975_) {
            ResourceLocation resourceLocation = block.m_60589_();
            if (resourceLocation == null) continue;
            IDataNode lootEntry = lootData.get(resourceLocation);
            List<ItemStack> outputs2 = clientRegistry.getLootItems(resourceLocation);
            if (lootEntry == null || outputs2 == null) continue;
            blockConsumer.accept(lootEntry, resourceLocation, block, outputs2);
            lootData.remove(resourceLocation);
        }
        for (EntityType entityType : BuiltInRegistries.f_256780_) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)BuiltInRegistries.f_256780_.m_7981_((Object)entityType)))) {
                lootData.remove(entityType.m_20677_());
                continue;
            }
            List<Entity> list = clientRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : list) {
                Mob mob;
                ResourceLocation location3;
                if (!(entity instanceof Mob) || (location3 = (mob = (Mob)entity).m_5743_()) == null) continue;
                IDataNode lootEntry = lootData.get(location3);
                List<ItemStack> outputs3 = clientRegistry.getLootItems(location3);
                if (lootEntry != null && outputs3 != null) {
                    entityConsumer.accept(lootEntry, location3, entityType, outputs3);
                }
                lootData.remove(location3);
            }
        }
        for (Map.Entry<ResourceLocation, IDataNode> entry : lootData.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            List<ItemStack> outputs4 = clientRegistry.getLootItems(resourceLocation);
            if (outputs4 == null) continue;
            gameplayConsumer.accept(entry.getValue(), entry.getKey(), outputs4);
        }
        lootData.clear();
        List<Map.Entry> entries = BuiltInRegistries.f_256735_.m_6579_().stream().sorted(Comparator.comparing(a -> ((ResourceKey)a.getKey()).m_135782_().m_135815_())).toList();
        for (Map.Entry entry : entries) {
            location = ((ResourceKey)entry.getKey()).m_135782_();
            tradeEntry = tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = clientRegistry.getTradeInputItems(location).stream().map(Item::m_7968_).toList();
            outputs = clientRegistry.getTradeOutputItems(location).stream().map(Item::m_7968_).toList();
            traderConsumer.accept(tradeEntry, location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            tradeEntry = tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = clientRegistry.getTradeInputItems(location).stream().map(Item::m_7968_).toList();
            outputs = clientRegistry.getTradeOutputItems(location).stream().map(Item::m_7968_).toList();
            wanderingTraderConsumer.accept(tradeEntry, location, inputs, outputs);
        }
        tradeData.clear();
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }
}

