/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.network;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.AliServerRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public class SyncTradeMessage {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final ResourceLocation location;
    public final IDataNode node;
    public final List<Item> inputs;
    public final List<Item> outputs;

    public SyncTradeMessage(IDataNode node, Pair<List<Item>, List<Item>> items) {
        this.location = new ResourceLocation("empty");
        this.node = node;
        this.inputs = (List)items.getA();
        this.outputs = (List)items.getB();
    }

    public SyncTradeMessage(ResourceLocation location, IDataNode node, Pair<List<Item>, List<Item>> items) {
        this.location = location;
        this.node = node;
        this.inputs = (List)items.getA();
        this.outputs = (List)items.getB();
    }

    public SyncTradeMessage(FriendlyByteBuf buf) {
        Object dataNode;
        this.location = buf.m_130281_();
        this.inputs = buf.m_236845_(b -> (Item)BuiltInRegistries.f_257033_.m_7745_(b.m_130281_()));
        this.outputs = buf.m_236845_(b -> (Item)BuiltInRegistries.f_257033_.m_7745_(b.m_130281_()));
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, buf);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to decode node for trade {} with error: {}", (Object)this.location, (Object)e.getMessage());
            dataNode = new MissingNode();
        }
        this.node = dataNode;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.location);
        buf.m_236828_(this.inputs, (b, i) -> b.m_130085_(BuiltInRegistries.f_257033_.m_7981_(i)));
        buf.m_236828_(this.outputs, (b, i) -> b.m_130085_(BuiltInRegistries.f_257033_.m_7981_(i)));
        AliServerRegistry utils = PluginManager.SERVER_REGISTRY;
        try {
            this.node.encode(utils, buf);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to encode trade node with error: {}", (Object)e.getMessage());
            new MissingNode().encode(utils, buf);
        }
    }
}

