/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.server.EntryTooltipUtils;
import com.yanny.ali.plugin.server.TooltipUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_117;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import net.minecraft.class_91;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

public class TagNode
implements IDataNode,
IItemNode {
    public static final class_2960 ID = new class_2960("ali", "tag");
    private final List<ITooltipNode> tooltip;
    private final List<class_5341> conditions;
    private final List<class_117> functions;
    private final class_6862<? extends class_1935> tag;
    private final RangeValue count;
    private final float chance;

    public TagNode(IServerUtils utils, class_6862<? extends class_1935> tag, RangeValue count) {
        this(utils, tag, count, Collections.emptyList());
    }

    public TagNode(IServerUtils ignoredUtils, class_6862<? extends class_1935> tag, RangeValue count, List<ITooltipNode> tooltip) {
        this.tag = tag;
        this.tooltip = tooltip;
        this.count = count;
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
        this.chance = 1.0f;
    }

    public TagNode(IServerUtils utils, class_91 entry, float chance, int sumWeight, List<class_117> functions, List<class_5341> conditions) {
        this.conditions = Stream.concat(conditions.stream(), entry.field_988.stream()).toList();
        this.functions = Stream.concat(functions.stream(), entry.field_996.stream()).toList();
        this.chance = chance * (float)entry.field_995 / (float)sumWeight;
        this.tag = entry.field_1005;
        this.tooltip = EntryTooltipUtils.getSingletonTooltip(utils, (class_85)entry, chance, sumWeight, functions, conditions);
        this.count = TooltipUtils.getCount(utils, this.functions).get(null).get(0);
    }

    public TagNode(IClientUtils utils, class_9129 buf) {
        this.tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)buf.method_10810());
        this.tooltip = NodeUtils.decodeTooltipNodes(utils, buf);
        this.count = new RangeValue((class_2540)buf);
        this.chance = buf.readFloat();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
    }

    @Override
    public Either<class_1799, class_6862<? extends class_1935>> getModifiedItem() {
        return Either.right(this.tag);
    }

    @Override
    public List<class_5341> getConditions() {
        return this.conditions;
    }

    @Override
    public List<class_117> getFunctions() {
        return this.functions;
    }

    @Override
    @NotNull
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, class_9129 buf) {
        buf.method_10812(this.tag.comp_327());
        NodeUtils.encodeTooltipNodes(utils, buf, this.tooltip);
        this.count.encode((class_2540)buf);
        buf.method_52941(this.chance);
    }

    @Override
    public List<ITooltipNode> getTooltip() {
        return this.tooltip;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }
}

